/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.grammar.dragonExpr.handler;

import java.math.BigDecimal;
import kd.bos.olapServer.grammar.DragonEngine;
import kd.bos.olapServer.grammar.common.OperateUtils;
import kd.bos.olapServer.grammar.dragonExpr.handler.DragonCalcHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.decimal4j.immutable.Decimal6f;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00152\b\u0010\u0007\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00172\b\u0010\u0007\u001a\u0004\u0018\u00010\tH\u0016J\u001e\u0010\u0018\u001a\u0004\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00192\b\u0010\u0007\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkd/bos/olapServer/grammar/dragonExpr/handler/AddDragonCalcHandler;", "Lkd/bos/olapServer/grammar/dragonExpr/handler/DragonCalcHandler;", "()V", "name", "", "calcString", "left", "right", "leftOrRightNullString", "", "value", "operateBigDecimal", "Ljava/math/BigDecimal;", "operateDecimal6f", "Lorg/decimal4j/immutable/Decimal6f;", "operateLeftBigDecimal", "operateLeftBool", "", "operateLeftChar", "operateLeftDecimal6f", "operateLeftInt", "", "operateLeftLong", "", "operateLeftNull", "", "operateLeftStr", "operateLong", "bos-olap-dragonEngine"})
public final class AddDragonCalcHandler
extends DragonCalcHandler {
    @NotNull
    public static final AddDragonCalcHandler INSTANCE = new AddDragonCalcHandler();
    @NotNull
    private static final String name = "+";

    private AddDragonCalcHandler() {
    }

    @Override
    @Nullable
    public Object operateLeftBool(boolean left, @Nullable Object right) {
        Object object;
        Object object2 = object = right;
        return (((object2 == null ? true : object2 instanceof Boolean) ? true : object instanceof String) ? true : object instanceof Character) ? null : right;
    }

    @Override
    @Nullable
    public Object operateLeftChar(@NotNull String left, @Nullable Object right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        return this.operateLeftStr(left, right);
    }

    @Override
    @Nullable
    public Object operateLeftStr(@NotNull String left, @Nullable Object right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Object object = right;
        return (object instanceof String ? true : object instanceof Character) ? this.calcString(left, right.toString()) : (object == null ? this.leftOrRightNullString(left) : (object instanceof Boolean ? null : right));
    }

    private final String calcString(String left, String right) {
        return StringsKt.equals((String)left, (String)right, (boolean)true) ? left : null;
    }

    @Override
    @Nullable
    public Object operateLeftLong(long left, @Nullable Object right) {
        Object object;
        Object object2 = right;
        if (object2 == null) {
            object = this.leftOrRightNullString(left);
        } else if (object2 instanceof Integer) {
            object = this.operateLong(left, ((Number)right).intValue());
        } else if (object2 instanceof Long) {
            object = this.operateLong(left, ((Number)right).longValue());
        } else if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            object = this.operateBigDecimal(bigDecimal, (BigDecimal)right);
        } else if (object2 instanceof Decimal6f) {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            BigDecimal bigDecimal2 = ((Decimal6f)right).toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(bigDecimal, bigDecimal2);
        } else if (object2 instanceof Boolean) {
            object = left;
        } else if (object2 instanceof String ? true : object2 instanceof Character) {
            object = left;
        } else {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            object = this.operateBigDecimal(bigDecimal, DragonEngine.Companion.toDecimal(right));
        }
        return object;
    }

    private final Object operateLong(long left, long right) {
        try {
            return Math.addExact(left, right);
        }
        catch (ArithmeticException ex) {
            throw this.beyondScope(left, right, name);
        }
    }

    @Override
    @Nullable
    public Object operateLeftInt(int left, @Nullable Object right) {
        Object object;
        Object object2 = right;
        if (object2 == null) {
            object = this.leftOrRightNullString(left);
        } else if (object2 instanceof Integer) {
            object = (long)left + (long)((Number)right).intValue();
        } else if (object2 instanceof Decimal6f) {
            Decimal6f decimal6f = Decimal6f.valueOf((long)left);
            Intrinsics.checkNotNullExpressionValue((Object)decimal6f, (String)"valueOf(...)");
            object = this.operateDecimal6f(decimal6f, (Decimal6f)right);
        } else if (object2 instanceof Boolean) {
            object = left;
        } else if (object2 instanceof String ? true : object2 instanceof Character) {
            object = left;
        } else if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
            object = this.operateBigDecimal(bigDecimal, (BigDecimal)right);
        } else {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
            object = this.operateBigDecimal(bigDecimal, DragonEngine.Companion.toDecimal(right));
        }
        return object;
    }

    @Override
    @Nullable
    public Object operateLeftDecimal6f(@NotNull Decimal6f left, @Nullable Object right) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Object object2 = right;
        if (object2 == null) {
            object = this.leftOrRightNullString(left);
        } else if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = left.toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(bigDecimal, (BigDecimal)right);
        } else if (object2 instanceof Decimal6f) {
            object = this.operateDecimal6f(left, (Decimal6f)right);
        } else if (object2 instanceof Integer) {
            Decimal6f decimal6f = Decimal6f.valueOf((long)((Number)right).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)decimal6f, (String)"valueOf(...)");
            object = this.operateDecimal6f(left, decimal6f);
        } else if (object2 instanceof Boolean) {
            object = left;
        } else if (object2 instanceof String ? true : object2 instanceof Character) {
            object = left;
        } else {
            BigDecimal bigDecimal = left.toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(bigDecimal, DragonEngine.Companion.toDecimal(right));
        }
        return object;
    }

    private final Object operateDecimal6f(Decimal6f left, Decimal6f right) {
        Object object;
        long y;
        long r;
        long x = left.unscaledValue();
        if (((x ^ (r = x + (y = right.unscaledValue()))) & (y ^ r)) < 0L) {
            BigDecimal bigDecimal = left.toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"toBigDecimal(...)");
            BigDecimal bigDecimal2 = right.toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(bigDecimal, bigDecimal2);
        } else {
            object = Decimal6f.valueOfUnscaled((long)r);
        }
        return object;
    }

    @Override
    @Nullable
    public Object operateLeftBigDecimal(@NotNull BigDecimal left, @Nullable Object right) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Object object2 = right;
        if (object2 == null) {
            object = this.leftOrRightNullString(left);
        } else if (object2 instanceof BigDecimal) {
            object = this.operateBigDecimal(left, (BigDecimal)right);
        } else if (object2 instanceof Decimal6f) {
            BigDecimal bigDecimal = ((Decimal6f)right).toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(left, bigDecimal);
        } else {
            object = object2 instanceof Integer ? this.operateBigDecimal(left, new BigDecimal(((Number)right).intValue())) : (object2 instanceof Long ? this.operateBigDecimal(left, new BigDecimal(((Number)right).longValue())) : (object2 instanceof Boolean ? left : ((object2 instanceof String ? true : object2 instanceof Character) ? left : this.operateBigDecimal(left, DragonEngine.Companion.toDecimal(right)))));
        }
        return object;
    }

    private final Object operateBigDecimal(BigDecimal left, BigDecimal right) {
        BigDecimal result = left.add(right);
        Intrinsics.checkNotNull((Object)result);
        if (DragonEngine.Companion.isInScope(result)) {
            return result;
        }
        throw super.beyondScope(left, right, name);
    }

    @Override
    @Nullable
    public Object operateLeftNull(@Nullable Void left, @Nullable Object right) {
        Object object = right;
        return (object == null ? true : object instanceof Boolean) ? null : this.leftOrRightNullString(right);
    }

    private final Object leftOrRightNullString(Object value) {
        return OperateUtils.INSTANCE.getDEBUG() ? (value instanceof String || value instanceof Character ? null : value) : value;
    }
}

