/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.grammar.dragonExpr.handler;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bos.olapServer.grammar.DragonEngine;
import kd.bos.olapServer.grammar.dragonExpr.handler.DragonCalcHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.decimal4j.api.Decimal;
import org.decimal4j.immutable.Decimal6f;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001e\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u0019\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u001a2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lkd/bos/olapServer/grammar/dragonExpr/handler/DragonCompareHandler;", "Lkd/bos/olapServer/grammar/dragonExpr/handler/DragonCalcHandler;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "operateBigDecimal", "", "left", "Ljava/math/BigDecimal;", "right", "operateBool", "operateDecimal6f", "Lorg/decimal4j/immutable/Decimal6f;", "operateInt", "", "operateLeftBigDecimal", "operateLeftBool", "", "operateLeftChar", "operateLeftDecimal6f", "operateLeftInt", "operateLeftLong", "", "operateLeftNull", "", "operateLeftStr", "operateStr", "Companion", "bos-olap-dragonEngine"})
public final class DragonCompareHandler
extends DragonCalcHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final DragonCompareHandler largerInstance = new DragonCompareHandler(">");
    @NotNull
    private static final DragonCompareHandler largerEqualInstance = new DragonCompareHandler(">=");
    @NotNull
    private static final DragonCompareHandler lessInstance = new DragonCompareHandler("<");
    @NotNull
    private static final DragonCompareHandler lessEqualInstance = new DragonCompareHandler("<=");

    private DragonCompareHandler(String name) {
        this.name = name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Object operateLeftBool(boolean left, @Nullable Object right) {
        return this.operateBool(left, right);
    }

    @Override
    @NotNull
    public Object operateLeftChar(@NotNull String left, @Nullable Object right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        return this.operateLeftStr(left, right);
    }

    @Override
    @NotNull
    public Object operateLeftStr(@NotNull String left, @Nullable Object right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Object object = right;
        if (!(object instanceof String ? true : object instanceof Character)) {
            throw this.notSupportExcept(left, right, this.name);
        }
        return left.compareTo(right.toString());
    }

    @Override
    @Nullable
    public Object operateLeftLong(long left, @Nullable Object right) {
        Object object;
        Object object2 = right;
        if (object2 == null) {
            object = Intrinsics.compare((long)left, (long)0L);
        } else if (object2 instanceof Integer) {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)right).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(this.toLong())");
            object = this.operateBigDecimal(bigDecimal, bigDecimal2);
        } else if (object2 instanceof Long) {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            BigDecimal bigDecimal3 = BigDecimal.valueOf(((Number)right).longValue());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(this)");
            object = this.operateBigDecimal(bigDecimal, bigDecimal3);
        } else if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            object = this.operateBigDecimal(bigDecimal, (BigDecimal)right);
        } else if (object2 instanceof Decimal6f) {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            BigDecimal bigDecimal4 = ((Decimal6f)right).toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(bigDecimal, bigDecimal4);
        } else if (object2 instanceof Boolean) {
            object = this.operateBool(left, right);
        } else if (object2 instanceof String ? true : object2 instanceof Character) {
            object = this.operateStr(left, right.toString());
        } else {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            object = this.operateBigDecimal(bigDecimal, DragonEngine.Companion.toDecimal(right));
        }
        return object;
    }

    @Override
    @Nullable
    public Object operateLeftInt(int left, @Nullable Object right) {
        Object object;
        Object object2 = right;
        if (object2 == null) {
            object = Intrinsics.compare((int)left, (int)0);
        } else if (object2 instanceof Integer) {
            object = this.operateInt(left, ((Number)right).intValue());
        } else if (object2 instanceof Decimal6f) {
            Decimal6f decimal6f = Decimal6f.valueOf((long)left);
            Intrinsics.checkNotNullExpressionValue((Object)decimal6f, (String)"valueOf(...)");
            object = this.operateDecimal6f(decimal6f, (Decimal6f)right);
        } else if (object2 instanceof String ? true : object2 instanceof Character) {
            object = this.operateStr(left, right.toString());
        } else if (object2 instanceof Boolean) {
            object = this.operateBool(left, right);
        } else if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
            object = this.operateBigDecimal(bigDecimal, (BigDecimal)right);
        } else {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
            object = this.operateBigDecimal(bigDecimal, DragonEngine.Companion.toDecimal(right));
        }
        return object;
    }

    private final Object operateInt(int left, int right) {
        return Intrinsics.compare((int)left, (int)right);
    }

    @Override
    @Nullable
    public Object operateLeftDecimal6f(@NotNull Decimal6f left, @Nullable Object right) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Object object2 = right;
        if (object2 == null) {
            object = left.compareTo((Decimal)Decimal6f.ZERO);
        } else if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = left.toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(bigDecimal, (BigDecimal)right);
        } else if (object2 instanceof Decimal6f) {
            object = this.operateDecimal6f(left, (Decimal6f)right);
        } else if (object2 instanceof Integer) {
            Decimal6f decimal6f = Decimal6f.valueOf((long)((Number)right).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)decimal6f, (String)"valueOf(...)");
            object = this.operateDecimal6f(left, decimal6f);
        } else if (object2 instanceof Boolean) {
            object = this.operateBool(left, right);
        } else if (object2 instanceof String ? true : object2 instanceof Character) {
            object = this.operateStr(left, right.toString());
        } else {
            BigDecimal bigDecimal = left.toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(bigDecimal, DragonEngine.Companion.toDecimal(right));
        }
        return object;
    }

    private final Object operateDecimal6f(Decimal6f left, Decimal6f right) {
        return left.compareTo((Decimal)right);
    }

    @Override
    @Nullable
    public Object operateLeftBigDecimal(@NotNull BigDecimal left, @Nullable Object right) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Object object2 = right;
        if (object2 == null) {
            object = left.compareTo(BigDecimal.ZERO);
        } else if (object2 instanceof BigDecimal) {
            object = this.operateBigDecimal(left, (BigDecimal)right);
        } else if (object2 instanceof Decimal6f) {
            BigDecimal bigDecimal = ((Decimal6f)right).toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(left, bigDecimal);
        } else {
            object = object2 instanceof Integer ? this.operateBigDecimal(left, new BigDecimal(((Number)right).intValue())) : (object2 instanceof Long ? this.operateBigDecimal(left, new BigDecimal(((Number)right).longValue())) : (object2 instanceof Boolean ? this.operateBool(left, right) : ((object2 instanceof String ? true : object2 instanceof Character) ? this.operateStr(left, right.toString()) : this.operateBigDecimal(left, DragonEngine.Companion.toDecimal(right)))));
        }
        return object;
    }

    private final Object operateStr(Object left, String right) {
        Object object = left;
        if (!(object instanceof String ? true : object instanceof Character)) {
            throw this.notSupportExcept(left, right, this.name);
        }
        return left.toString().compareTo(right);
    }

    private final Object operateBool(Object left, Object right) {
        throw this.notSupportExcept(left, right, this.name);
    }

    private final Object operateBigDecimal(BigDecimal left, BigDecimal right) {
        return left.compareTo(right);
    }

    @Override
    @NotNull
    public Object operateLeftNull(@Nullable Void left, @Nullable Object right) {
        int n;
        Object object = right;
        if (object == null) {
            n = 0;
        } else if (object instanceof BigDecimal) {
            n = BigDecimal.ZERO.compareTo((BigDecimal)right);
        } else if (object instanceof Decimal6f) {
            n = Decimal6f.ZERO.compareTo((Decimal)right);
        } else if (object instanceof Integer) {
            n = Intrinsics.compare((int)0, (int)((Number)right).intValue());
        } else if (object instanceof Long) {
            n = Intrinsics.compare((long)0L, (long)((Number)right).longValue());
        } else if (object instanceof Float) {
            n = Float.compare(0.0f, ((Number)right).floatValue());
        } else if (object instanceof Double) {
            n = Double.compare(0.0, ((Number)right).doubleValue());
        } else if (object instanceof String) {
            n = "".compareTo((String)right);
        } else if (object instanceof Short) {
            n = Intrinsics.compare((int)0, (int)((Number)right).intValue());
        } else if (object instanceof BigInteger) {
            n = BigInteger.ZERO.compareTo((BigInteger)right);
        } else if (object instanceof Number) {
            n = BigDecimal.ZERO.compareTo(new BigDecimal(((Number)right).toString()));
        } else {
            throw this.notSupportExcept(null, right, this.name);
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lkd/bos/olapServer/grammar/dragonExpr/handler/DragonCompareHandler$Companion;", "", "()V", "largerEqualInstance", "Lkd/bos/olapServer/grammar/dragonExpr/handler/DragonCompareHandler;", "getLargerEqualInstance", "()Lkd/bos/olapServer/grammar/dragonExpr/handler/DragonCompareHandler;", "largerInstance", "getLargerInstance", "lessEqualInstance", "getLessEqualInstance", "lessInstance", "getLessInstance", "bos-olap-dragonEngine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DragonCompareHandler getLargerInstance() {
            return largerInstance;
        }

        @NotNull
        public final DragonCompareHandler getLargerEqualInstance() {
            return largerEqualInstance;
        }

        @NotNull
        public final DragonCompareHandler getLessInstance() {
            return lessInstance;
        }

        @NotNull
        public final DragonCompareHandler getLessEqualInstance() {
            return lessEqualInstance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

