/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.grammar.dragonExpr.handler;

import java.math.BigDecimal;
import kd.bos.olapServer.grammar.DragonEngine;
import kd.bos.olapServer.grammar.common.OperateUtils;
import kd.bos.olapServer.grammar.dragonExpr.handler.DragonCalcHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.decimal4j.immutable.Decimal6f;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00122\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00142\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00162\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkd/bos/olapServer/grammar/dragonExpr/handler/SubDragonCalcHandler;", "Lkd/bos/olapServer/grammar/dragonExpr/handler/DragonCalcHandler;", "()V", "name", "", "operateBigDecimal", "", "left", "Ljava/math/BigDecimal;", "right", "operateDecimal6f", "Lorg/decimal4j/immutable/Decimal6f;", "operateLeftBigDecimal", "operateLeftBool", "", "operateLeftChar", "operateLeftDecimal6f", "operateLeftInt", "", "operateLeftLong", "", "operateLeftNull", "", "operateLeftStr", "operateLong", "bos-olap-dragonEngine"})
public final class SubDragonCalcHandler
extends DragonCalcHandler {
    @NotNull
    public static final SubDragonCalcHandler INSTANCE = new SubDragonCalcHandler();
    @NotNull
    private static final String name = "-";

    private SubDragonCalcHandler() {
    }

    @Override
    @Nullable
    public Object operateLeftBool(boolean left, @Nullable Object right) {
        return OperateUtils.negate(right);
    }

    @Override
    @Nullable
    public Object operateLeftChar(@NotNull String left, @Nullable Object right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        return OperateUtils.negate(right);
    }

    @Override
    @Nullable
    public Object operateLeftStr(@NotNull String left, @Nullable Object right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        return OperateUtils.negate(right);
    }

    @Override
    @Nullable
    public Object operateLeftLong(long left, @Nullable Object right) {
        Object object;
        Object object2 = right;
        if (object2 == null) {
            object = left;
        } else if (object2 instanceof Integer) {
            object = this.operateLong(left, ((Number)right).intValue());
        } else if (object2 instanceof Long) {
            object = this.operateLong(left, ((Number)right).longValue());
        } else if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            object = this.operateBigDecimal(bigDecimal, (BigDecimal)right);
        } else if (object2 instanceof Decimal6f) {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            BigDecimal bigDecimal2 = ((Decimal6f)right).toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(bigDecimal, bigDecimal2);
        } else if (object2 instanceof Boolean) {
            object = left;
        } else if (object2 instanceof String ? true : object2 instanceof Character) {
            object = left;
        } else {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            object = this.operate(bigDecimal, DragonEngine.Companion.toDecimal(right));
        }
        return object;
    }

    private final long operateLong(long left, long right) {
        try {
            return Math.subtractExact(left, right);
        }
        catch (ArithmeticException ex) {
            throw this.beyondScope(left, right, name);
        }
    }

    @Override
    @Nullable
    public Object operateLeftInt(int left, @Nullable Object right) {
        Object object;
        Object object2 = right;
        if (object2 == null) {
            object = left;
        } else if (object2 instanceof Integer) {
            object = (long)left - (long)((Number)right).intValue();
        } else if (object2 instanceof Decimal6f) {
            Decimal6f decimal6f = Decimal6f.valueOf((long)left);
            Intrinsics.checkNotNullExpressionValue((Object)decimal6f, (String)"valueOf(...)");
            object = this.operateDecimal6f(decimal6f, (Decimal6f)right);
        } else if (object2 instanceof Boolean) {
            object = left;
        } else if (object2 instanceof String ? true : object2 instanceof Character) {
            object = left;
        } else if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
            object = this.operateBigDecimal(bigDecimal, (BigDecimal)right);
        } else {
            BigDecimal bigDecimal = BigDecimal.valueOf(left);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this.toLong())");
            object = this.operateBigDecimal(bigDecimal, DragonEngine.Companion.toDecimal(right));
        }
        return object;
    }

    @Override
    @Nullable
    public Object operateLeftDecimal6f(@NotNull Decimal6f left, @Nullable Object right) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Object object2 = right;
        if (object2 == null) {
            object = left;
        } else if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = left.toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(bigDecimal, (BigDecimal)right);
        } else if (object2 instanceof Decimal6f) {
            object = this.operateDecimal6f(left, (Decimal6f)right);
        } else if (object2 instanceof Integer) {
            Decimal6f decimal6f = Decimal6f.valueOf((long)((Number)right).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)decimal6f, (String)"valueOf(...)");
            object = this.operateDecimal6f(left, decimal6f);
        } else if (object2 instanceof Boolean) {
            object = left;
        } else if (object2 instanceof String ? true : object2 instanceof Character) {
            object = left;
        } else {
            BigDecimal bigDecimal = left.toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(bigDecimal, DragonEngine.Companion.toDecimal(right));
        }
        return object;
    }

    private final Object operateDecimal6f(Decimal6f left, Decimal6f right) {
        Object object;
        long y;
        long r;
        long x = left.unscaledValue();
        if (((x ^ (r = x - (y = right.unscaledValue()))) & (x ^ r)) < 0L) {
            BigDecimal bigDecimal = left.toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"toBigDecimal(...)");
            BigDecimal bigDecimal2 = right.toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(bigDecimal, bigDecimal2);
        } else {
            object = Decimal6f.valueOfUnscaled((long)r);
        }
        return object;
    }

    @Override
    @Nullable
    public Object operateLeftBigDecimal(@NotNull BigDecimal left, @Nullable Object right) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Object object2 = right;
        if (object2 == null) {
            object = left;
        } else if (object2 instanceof BigDecimal) {
            object = this.operateBigDecimal(left, (BigDecimal)right);
        } else if (object2 instanceof Decimal6f) {
            BigDecimal bigDecimal = ((Decimal6f)right).toBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"toBigDecimal(...)");
            object = this.operateBigDecimal(left, bigDecimal);
        } else {
            object = object2 instanceof Integer ? this.operateBigDecimal(left, new BigDecimal(((Number)right).intValue())) : (object2 instanceof Long ? this.operateBigDecimal(left, new BigDecimal(((Number)right).longValue())) : (object2 instanceof Boolean ? left : ((object2 instanceof String ? true : object2 instanceof Character) ? left : this.operateBigDecimal(left, DragonEngine.Companion.toDecimal(right)))));
        }
        return object;
    }

    private final Object operateBigDecimal(BigDecimal left, BigDecimal right) {
        BigDecimal result = left.subtract(right);
        Intrinsics.checkNotNull((Object)result);
        if (DragonEngine.Companion.isInScope(result)) {
            return result;
        }
        throw this.beyondScope(left, right, name);
    }

    @Override
    @Nullable
    public Object operateLeftNull(@Nullable Void left, @Nullable Object right) {
        return OperateUtils.negate(right);
    }
}

