/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.grammar.expr;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bos.olapServer.grammar.IExecuteContext;
import kd.bos.olapServer.grammar.common.IntCompactUtil;
import kd.bos.olapServer.grammar.common.NumberUtil;
import kd.bos.olapServer.grammar.common.Res;
import kd.bos.olapServer.grammar.exception.ExecuteException;
import kd.bos.olapServer.grammar.expr.AbstractExpr;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0011"}, d2={"Lkd/bos/olapServer/grammar/expr/NumberExpr;", "Lkd/bos/olapServer/grammar/expr/AbstractExpr;", "number", "", "(Ljava/lang/String;)V", "_number", "", "priority", "", "getPriority", "()I", "returnDataType", "getReturnDataType", "encode", "execute", "ctx", "Lkd/bos/olapServer/grammar/IExecuteContext;", "bos-olap-dragonEngine"})
public final class NumberExpr
extends AbstractExpr {
    @NotNull
    private final Object _number;

    public NumberExpr(@NotNull String number) {
        Number number2;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        BigDecimal numberTemp = new BigDecimal(number);
        if (!IntCompactUtil.isInScope(numberTemp)) {
            Object[] objectArray = new Object[]{IntCompactUtil.getLongMinValue(), IntCompactUtil.getLongMaxValue()};
            throw ExecuteException.Companion.unexpectedParamValue(Res.INSTANCE.getConstNodeException_1(), objectArray);
        }
        BigDecimal bigDecimal = IntCompactUtil.tryInScale(numberTemp);
        if (bigDecimal == null) {
            Object[] objectArray = new Object[]{IntCompactUtil.getFloatScaleLength()};
            throw ExecuteException.Companion.unexpectedParamValue(Res.INSTANCE.getConstNodeException_2(), objectArray);
        }
        numberTemp = bigDecimal;
        if (numberTemp.scale() > 0) {
            number2 = numberTemp;
        } else {
            BigInteger value = numberTemp.toBigInteger();
            Intrinsics.checkNotNull((Object)value);
            number2 = NumberUtil.INSTANCE.narrow(value);
        }
        Number ret = number2;
        this._number = ret;
    }

    @Override
    @NotNull
    public String encode() {
        return this._number.toString();
    }

    @Override
    @NotNull
    public Object execute(@NotNull IExecuteContext ctx) throws ExecuteException {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this._number;
    }

    @Override
    public int getPriority() {
        return 99;
    }

    @Override
    public int getReturnDataType() {
        return 2;
    }
}

