/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olapServer.plugins;

import java.io.Closeable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.olapServer2.common.CommonTypesKt;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.dataEntities.IDimensionKeys;
import kd.bos.olapServer2.dataEntities.IInputRow;
import kd.bos.olapServer2.dataEntities.IMeasureValues;
import kd.bos.olapServer2.storages.ICubeDataObserver;
import kd.bos.olapServer2.storages.plugins.CommandExtendContext;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePlugin;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePluginContext;
import kd.bos.olapServer2.storages.plugins.InputRowWriterCreatingEventArgs;
import kd.bos.olapServer2.storages.plugins.OlapWorkspaceBasicPlugin;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kd.bos.olapServer2.tools.DecimalTools;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.decimal4j.api.Decimal;
import org.decimal4j.immutable.Decimal6f;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0003\u0017\u0018\u0019B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001a\u0010\u0005\u001a\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0015\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0016H\u0014R\u0016\u0010\n\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\rj\u0002`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lkd/bos/olapServer/plugins/Audit;", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspaceBasicPlugin;", "Lkd/bos/olapServer/plugins/Audit$CubeAuditPlugin;", "context", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "properties", "", "", "Lkd/bos/olapServer2/common/string;", "(Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;Ljava/util/Map;)V", "auditIp", "auditPassword", "auditPort", "", "Lkd/bos/olapServer2/common/int;", "auditUser", "batchSize", "cubePluginKey", "", "getCubePluginKey", "()Ljava/lang/Object;", "createCubePlugin", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "AuditDataObserver", "Companion", "CubeAuditPlugin", "bos-olap-plugin-audit"})
public final class Audit
extends OlapWorkspaceBasicPlugin<CubeAuditPlugin> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String auditIp;
    private int auditPort;
    @Nullable
    private String auditUser;
    @Nullable
    private String auditPassword;
    private int batchSize;
    @NotNull
    private static final Class<CubeAuditPlugin> pluginKey = CubeAuditPlugin.class;
    private static final Logger logger = LoggerFactory.getLogger((String)"auditLog");

    public Audit(@NotNull OlapWorkspacePluginContext context, @NotNull Map<String, String> properties) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        super(context, true);
        this.auditIp = properties.get("AuditIp");
        Object object = properties.get("AuditPort");
        this.auditPort = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 9200;
        this.auditUser = properties.get("AuditUser");
        this.auditPassword = properties.get("AuditPassword");
        Object object2 = properties.get("BatchSize");
        this.batchSize = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 1000;
        System.out.println((Object)("ES Server   : " + this.auditIp + ':' + this.auditPort + "  user:" + this.auditUser));
    }

    @NotNull
    protected Object getCubePluginKey() {
        return pluginKey;
    }

    @NotNull
    protected CubeAuditPlugin createCubePlugin(@NotNull CubeWorkspacePluginContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new CubeAuditPlugin(context);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010%\u001a\u00020\u001dH\u0016J\b\u0010&\u001a\u00020\u001dH\u0016J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020!H\u0016J*\u0010(\u001a\u00020\u001d2\u0018\u0010)\u001a\u0014\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0006\u0012\u0004\u0018\u00010\u001f0*2\u0006\u0010#\u001a\u00020$H\u0002R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lkd/bos/olapServer/plugins/Audit$AuditDataObserver;", "Lkd/bos/olapServer2/storages/ICubeDataObserver;", "client", "Lorg/elasticsearch/client/RestHighLevelClient;", "ctx", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "eventId", "", "Lkd/bos/olapServer2/common/string;", "indexName", "batchSize", "", "Lkd/bos/olapServer2/common/int;", "(Lorg/elasticsearch/client/RestHighLevelClient;Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;Ljava/lang/String;Ljava/lang/String;I)V", "bulkRequest", "Lorg/elasticsearch/action/bulk/BulkRequest;", "listener", "Lorg/elasticsearch/action/ActionListener;", "Lorg/elasticsearch/action/bulk/BulkResponse;", "getListener", "()Lorg/elasticsearch/action/ActionListener;", "now", "Ljava/util/Date;", "row", "Lkd/bos/olapServer2/dataEntities/IInputRow;", "str", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "bulkAsync", "", "measureToString", "", "value", "Lkd/bos/olapServer2/dataEntities/IMeasureValues;", "onAdded", "key", "Lkd/bos/olapServer2/dataEntities/IDimensionKeys;", "onFlush", "onForcePartition", "onUpdated", "setKey", "json", "Ljava/util/HashMap;", "bos-olap-plugin-audit"})
    public static final class AuditDataObserver
    implements ICubeDataObserver {
        @NotNull
        private final RestHighLevelClient client;
        @NotNull
        private final String eventId;
        @NotNull
        private final String indexName;
        private final int batchSize;
        @NotNull
        private final BulkRequest bulkRequest;
        @NotNull
        private final IInputRow row;
        @NotNull
        private final Date now;
        @NotNull
        private final StringBuilder str;
        @NotNull
        private final ActionListener<BulkResponse> listener;

        public AuditDataObserver(@NotNull RestHighLevelClient client, @NotNull CubeWorkspacePluginContext ctx, @NotNull String eventId, @NotNull String indexName, int batchSize) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
            this.client = client;
            this.eventId = eventId;
            this.indexName = indexName;
            this.batchSize = batchSize;
            this.bulkRequest = new BulkRequest();
            this.row = ctx.createInputRow();
            this.bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.now = new Date();
            this.str = new StringBuilder();
            this.listener = (ActionListener)new ActionListener<BulkResponse>(){

                public void onResponse(@Nullable BulkResponse bulkResponse) {
                    if (bulkResponse != null && bulkResponse.hasFailures()) {
                        Audit.access$getLogger$cp().error("BulkResponse Error: " + bulkResponse.buildFailureMessage());
                    }
                }

                public void onFailure(@Nullable Exception e) {
                    Audit.access$getLogger$cp().error("BulkResponse Exception: " + e);
                }
            };
        }

        private final void setKey(HashMap<String, Object> json, IDimensionKeys key) {
            int n = key.getCount();
            for (int i = 0; i < n; ++i) {
                this.row.setDimensionValue(i, key.get(i));
                ((Map)json).put(this.row.getDimensionName(i), this.row.getMemberName(i));
            }
        }

        public void onAdded(@NotNull IDimensionKeys key, @NotNull IMeasureValues value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object newValue = value.getMeasureValue(0);
            if (newValue != CommonTypesKt.getIgnoreValue() && newValue != CommonTypesKt.getUndefined()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                ((Map)data).put("eventId", this.eventId);
                this.setKey(data, key);
                ((Map)data).put("newValue", this.measureToString(value));
                ((Map)data).put("created", this.now);
                IndexRequest req = new IndexRequest(this.indexName).type("_doc").source((Map)data, XContentType.JSON);
                this.bulkRequest.add(req, (Object)RequestOptions.DEFAULT);
                int reqSize = this.bulkRequest.requests().size();
                if (reqSize >= this.batchSize) {
                    this.bulkAsync();
                }
            }
        }

        public void onUpdated(@NotNull IDimensionKeys key, @NotNull IMeasureValues value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value.getMeasureValue(0) != CommonTypesKt.getIgnoreValue()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                ((Map)data).put("eventId", this.eventId);
                this.setKey(data, key);
                ((Map)data).put("newValue", this.measureToString(value));
                ((Map)data).put("created", this.now);
                IndexRequest req = new IndexRequest(this.indexName).type("_doc").source((Map)data, XContentType.JSON);
                this.bulkRequest.add(req, (Object)RequestOptions.DEFAULT);
                int reqSize = this.bulkRequest.requests().size();
                if (reqSize >= this.batchSize) {
                    this.bulkAsync();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Object measureToString(IMeasureValues value) {
            Object object;
            Object measure = value.getMeasureValue(0);
            if (measure instanceof Decimal6f) {
                this.str.setLength(0);
                DecimalTools.INSTANCE.toString((Decimal)measure, (Appendable)this.str);
                object = this.str.toString();
            } else {
                void var2_2;
                object = measure instanceof BigDecimal ? ((BigDecimal)measure).toPlainString() : (measure == CommonTypesKt.getUndefined() ? null : var2_2);
            }
            return object;
        }

        public void onForcePartition() {
        }

        public void onFlush() {
            this.bulkAsync();
        }

        private final void bulkAsync() {
            List list = this.bulkRequest.requests();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"requests(...)");
            if (!((Collection)list).isEmpty()) {
                this.client.bulkAsync(this.bulkRequest, RequestOptions.DEFAULT, this.listener);
                this.bulkRequest.requests().clear();
            }
        }

        @NotNull
        public final ActionListener<BulkResponse> getListener() {
            return this.listener;
        }

        public void beforeUpdate() {
            ICubeDataObserver.DefaultImpls.beforeUpdate((ICubeDataObserver)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u00060\bR\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkd/bos/olapServer/plugins/Audit$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "pluginKey", "Ljava/lang/Class;", "Lkd/bos/olapServer/plugins/Audit$CubeAuditPlugin;", "Lkd/bos/olapServer/plugins/Audit;", "bos-olap-plugin-audit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J,\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lkd/bos/olapServer/plugins/Audit$CubeAuditPlugin;", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePlugin;", "Ljava/io/Closeable;", "ctx", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "(Lkd/bos/olapServer/plugins/Audit;Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;)V", "_client", "Lorg/elasticsearch/client/RestHighLevelClient;", "key", "", "getKey", "()Ljava/lang/Object;", "close", "", "createDataObserver", "Lkd/bos/olapServer/plugins/Audit$AuditDataObserver;", "createRestHighLevelClient", "ip", "", "port", "", "username", "password", "bos-olap-plugin-audit"})
    public final class CubeAuditPlugin
    extends CubeWorkspacePlugin
    implements Closeable {
        @Nullable
        private volatile RestHighLevelClient _client;

        public CubeAuditPlugin(CubeWorkspacePluginContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            super(ctx);
            ctx.getInputRowWriterCreating().plusAssign((Function2)new Function2<CubeWorkspacePluginContext, InputRowWriterCreatingEventArgs, Unit>(){

                public final void invoke(@NotNull CubeWorkspacePluginContext cubeWorkspacePluginContext, @NotNull InputRowWriterCreatingEventArgs e) {
                    Intrinsics.checkNotNullParameter((Object)cubeWorkspacePluginContext, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AuditDataObserver observer = this.createDataObserver();
                    if (observer != null) {
                        e.registerObserver((ICubeDataObserver)observer);
                    }
                }
            });
        }

        private final AuditDataObserver createDataObserver() {
            Map exProperties;
            CommandExtendContext commandExtendContext = (CommandExtendContext)OlapContext.Companion.tryGetContext(CommandExtendContext.class);
            Map map = exProperties = commandExtendContext != null ? commandExtendContext.getExtProperties() : null;
            if (exProperties != null && !exProperties.isEmpty()) {
                AuditDataObserver auditDataObserver;
                String eventId = (String)exProperties.get("eventId");
                String indexName = (String)exProperties.get("auditIndex");
                if (eventId == null || indexName == null || ((CharSequence)eventId).length() == 0 || ((CharSequence)indexName).length() == 0) {
                    auditDataObserver = null;
                } else {
                    RestHighLevelClient restHighLevelClient;
                    if (exProperties.get("audit.ip") != null) {
                        try {
                            Audit.this.auditIp = (String)exProperties.get("audit.ip");
                            Object object = (String)exProperties.get("audit.port");
                            Audit.this.auditPort = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 9200;
                            Audit.this.auditUser = (String)exProperties.get("audit.username");
                            Audit.this.auditPassword = (String)exProperties.get("audit.password");
                            Object object2 = (String)exProperties.get("audit.batchSize");
                            Audit.this.batchSize = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 1000;
                        }
                        catch (Exception e) {
                            logger.error("Get Audit Connect info from Bcm Error : ", (Throwable)e);
                        }
                    }
                    if ((restHighLevelClient = this._client) == null) {
                        String string = Audit.this.auditIp;
                        Intrinsics.checkNotNull((Object)string);
                        restHighLevelClient = this.createRestHighLevelClient(string, Audit.this.auditPort, Audit.this.auditUser, Audit.this.auditPassword);
                    }
                    RestHighLevelClient client = restHighLevelClient;
                    auditDataObserver = new AuditDataObserver(client, this.getContext(), eventId, indexName, Audit.this.batchSize);
                }
                return auditDataObserver;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final RestHighLevelClient createRestHighLevelClient(String ip, int port, String username, String password) {
            RestHighLevelClient restHighLevelClient;
            CubeAuditPlugin cubeAuditPlugin = this;
            synchronized (cubeAuditPlugin) {
                boolean bl = false;
                RestHighLevelClient client = this._client;
                if (client == null) {
                    RestHighLevelClient restHighLevelClient2;
                    if (username != null && password != null) {
                        CredentialsProvider credentialsProvider = (CredentialsProvider)new BasicCredentialsProvider();
                        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                        HttpHost[] httpHostArray = new HttpHost[]{new HttpHost(ip, port)};
                        RestHighLevelClient restHighLevelClient3 = new RestHighLevelClient(RestClient.builder((HttpHost[])httpHostArray).setHttpClientConfigCallback(arg_0 -> CubeAuditPlugin.createRestHighLevelClient$lambda$1$lambda$0(credentialsProvider, arg_0)));
                        restHighLevelClient2 = restHighLevelClient3;
                    } else {
                        HttpHost[] httpHostArray = new HttpHost[]{new HttpHost(ip, port, "http")};
                        RestHighLevelClient restHighLevelClient4 = new RestHighLevelClient(RestClient.builder((HttpHost[])httpHostArray));
                        restHighLevelClient2 = restHighLevelClient4;
                    }
                    this._client = client = restHighLevelClient2;
                }
                restHighLevelClient = client;
            }
            return restHighLevelClient;
        }

        @Override
        public void close() {
            block0: {
                RestHighLevelClient restHighLevelClient = this._client;
                if (restHighLevelClient == null) break block0;
                restHighLevelClient.close();
            }
        }

        @NotNull
        public Object getKey() {
            return pluginKey;
        }

        private static final HttpAsyncClientBuilder createRestHighLevelClient$lambda$1$lambda$0(CredentialsProvider $credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
            Intrinsics.checkNotNullParameter((Object)$credentialsProvider, (String)"$credentialsProvider");
            httpClientBuilder.disableAuthCaching();
            return httpClientBuilder.setDefaultCredentialsProvider($credentialsProvider);
        }
    }
}

