/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.security.authc.IAuthenticationInfo;
import kd.bos.security.authc.IAuthenticationToken;
import kd.bos.security.authc.SimpleAccount;
import kd.bos.security.authc.UsernamePasswordToken;
import kd.bos.security.authz.IAuthorizationInfo;
import kd.bos.security.authz.SimpleRole;
import kd.bos.security.exceptions.ExpiredCredentialsException;
import kd.bos.security.exceptions.LockedAccountException;
import kd.bos.security.realm.AuthorizingRealm;
import kd.bos.security.subject.principal.IPrincipalCollection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\bH\u0004J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0004J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u0007H\u0004J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"LSimpleAccountRealm;", "Lkd/bos/security/realm/AuthorizingRealm;", "()V", "roleLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "roles", "", "", "Lkd/bos/security/authz/SimpleRole;", "userLock", "users", "Lkd/bos/security/authc/SimpleAccount;", "add", "", "account", "role", "doGetAuthenticationInfo", "Lkd/bos/security/authc/IAuthenticationInfo;", "token", "Lkd/bos/security/authc/IAuthenticationToken;", "doGetAuthorizationInfo", "Lkd/bos/security/authz/IAuthorizationInfo;", "principals", "Lkd/bos/security/subject/principal/IPrincipalCollection;", "getRole", "rolename", "getUser", "username", "getUsername", "bos-olap-security"})
public class SimpleAccountRealm
extends AuthorizingRealm {
    @NotNull
    private final Map<String, SimpleAccount> users = new LinkedHashMap();
    @NotNull
    private final Map<String, SimpleRole> roles = new LinkedHashMap();
    @NotNull
    private final ReentrantReadWriteLock userLock = new ReentrantReadWriteLock();
    @NotNull
    private final ReentrantReadWriteLock roleLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final SimpleAccount getUser(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        ReentrantReadWriteLock.ReadLock readLock = this.userLock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            SimpleAccount simpleAccount = this.users.get(username);
            return simpleAccount;
        }
        finally {
            lock.unlock();
        }
    }

    private final String getUsername(SimpleAccount account) {
        return this.getUsername(account.getPrincipals());
    }

    private final String getUsername(IPrincipalCollection principals) {
        return principals.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void add(@NotNull SimpleAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        ReentrantReadWriteLock.WriteLock writeLock = this.userLock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            String username = this.getUsername(account);
            this.users.put(username, account);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final SimpleRole getRole(@NotNull String rolename) {
        Intrinsics.checkNotNullParameter((Object)rolename, (String)"rolename");
        ReentrantReadWriteLock.ReadLock readLock = this.roleLock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            SimpleRole simpleRole = this.roles.get(rolename);
            return simpleRole;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void add(@NotNull SimpleRole role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        ReentrantReadWriteLock.WriteLock writeLock = this.roleLock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.roles.put(role.getName(), role);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @Nullable
    public IAuthenticationInfo doGetAuthenticationInfo(@NotNull IAuthenticationToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        SimpleAccount account = this.getUser(upToken.getUsername());
        if (account != null) {
            if (account.isLocked()) {
                throw new LockedAccountException("Account [" + account + "] is locked.");
            }
            if (account.isCredentialsExpired()) {
                String msg = "The credentials for account [" + account + "] are expired";
                throw new ExpiredCredentialsException(msg);
            }
        }
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected IAuthorizationInfo doGetAuthorizationInfo(@NotNull IPrincipalCollection principals) {
        Intrinsics.checkNotNullParameter((Object)principals, (String)"principals");
        ReentrantReadWriteLock.ReadLock readLock = this.userLock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            String username = this.getUsername(principals);
            SimpleAccount simpleAccount = this.users.get(username);
            if (simpleAccount == null) {
                throw new RuntimeException("can not find account by " + username);
            }
            IAuthorizationInfo iAuthorizationInfo = simpleAccount;
            return iAuthorizationInfo;
        }
        finally {
            lock.unlock();
        }
    }
}

