/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.authc;

import kd.bos.security.authc.IAuthenticationInfo;
import kd.bos.security.authc.IAuthenticationToken;
import kd.bos.security.authc.IAuthenticator;
import kd.bos.security.exceptions.AuthenticationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H$\u00a8\u0006\b"}, d2={"Lkd/bos/security/authc/AbstractAuthenticator;", "Lkd/bos/security/authc/IAuthenticator;", "()V", "authenticate", "Lkd/bos/security/authc/IAuthenticationInfo;", "token", "Lkd/bos/security/authc/IAuthenticationToken;", "doAuthenticate", "bos-olap-security"})
public abstract class AbstractAuthenticator
implements IAuthenticator {
    @Override
    @NotNull
    public final IAuthenticationInfo authenticate(@NotNull IAuthenticationToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        try {
            return this.doAuthenticate(token);
        }
        catch (Throwable t) {
            AuthenticationException authenticationException;
            if (t instanceof AuthenticationException) {
                authenticationException = (AuthenticationException)t;
            } else {
                String msg = "Authentication failed for token submission [" + token + "].  Possible unexpected error? (Typical or expected login exceptions should extend from AuthenticationException).";
                authenticationException = new AuthenticationException(msg, t);
            }
            AuthenticationException ae = authenticationException;
            throw ae;
        }
    }

    @NotNull
    protected abstract IAuthenticationInfo doAuthenticate(@NotNull IAuthenticationToken var1);
}

