/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.authc;

import java.util.Collection;
import kd.bos.security.authc.AbstractAuthenticator;
import kd.bos.security.authc.IAuthenticationInfo;
import kd.bos.security.authc.IAuthenticationToken;
import kd.bos.security.exceptions.MddSecurityException;
import kd.bos.security.exceptions.UnknownAccountException;
import kd.bos.security.exceptions.UnsupportedTokenException;
import kd.bos.security.realm.IRealm;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lkd/bos/security/authc/ModularRealmAuthenticator;", "Lkd/bos/security/authc/AbstractAuthenticator;", "()V", "_realms", "", "Lkd/bos/security/realm/IRealm;", "value", "realms", "getRealms", "()Ljava/util/Collection;", "setRealms", "(Ljava/util/Collection;)V", "doAuthenticate", "Lkd/bos/security/authc/IAuthenticationInfo;", "token", "Lkd/bos/security/authc/IAuthenticationToken;", "doSingleRealmAuthentication", "realm", "bos-olap-security"})
public final class ModularRealmAuthenticator
extends AbstractAuthenticator {
    @Nullable
    private Collection<? extends IRealm> _realms;

    @NotNull
    public final Collection<IRealm> getRealms() {
        Collection collection = this._realms;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    public final void setRealms(@NotNull Collection<? extends IRealm> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this._realms = value;
    }

    @Override
    @NotNull
    protected IAuthenticationInfo doAuthenticate(@NotNull IAuthenticationToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        if (this.getRealms().size() != 1) {
            throw new MddSecurityException("realms size is not 1");
        }
        return this.doSingleRealmAuthentication(this.getRealms().iterator().next(), token);
    }

    private final IAuthenticationInfo doSingleRealmAuthentication(IRealm realm, IAuthenticationToken token) {
        if (!realm.supports(token)) {
            String msg = "Realm [" + realm + "] does not support authentication token [" + token + "].  Please ensure that the appropriate Realm implementation is configured correctly or that the realm accepts AuthenticationTokens of this type.";
            throw new UnsupportedTokenException(msg);
        }
        IAuthenticationInfo iAuthenticationInfo = realm.getAuthenticationInfo(token);
        if (iAuthenticationInfo == null) {
            throw new UnknownAccountException("Realm [" + realm + "] was unable to find account data for the submitted AuthenticationToken [" + token + "].");
        }
        return iAuthenticationInfo;
    }
}

