/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.authz;

import java.util.Collection;
import kd.bos.security.authz.IAuthorizer;
import kd.bos.security.realm.IRealm;
import kd.bos.security.subject.principal.IPrincipalCollection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0013H\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lkd/bos/security/authz/ModularRealmAuthorizer;", "Lkd/bos/security/authz/IAuthorizer;", "()V", "_realms", "", "Lkd/bos/security/realm/IRealm;", "value", "realms", "getRealms", "()Ljava/util/Collection;", "setRealms", "(Ljava/util/Collection;)V", "assertRealmsConfigured", "", "hasRole", "", "principals", "Lkd/bos/security/subject/principal/IPrincipalCollection;", "roleIdentifier", "", "isPermitted", "permission", "bos-olap-security"})
public final class ModularRealmAuthorizer
implements IAuthorizer {
    @Nullable
    private Collection<? extends IRealm> _realms;

    @NotNull
    public final Collection<IRealm> getRealms() {
        Collection collection = this._realms;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    public final void setRealms(@NotNull Collection<? extends IRealm> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this._realms = value;
    }

    @Override
    public boolean isPermitted(@Nullable IPrincipalCollection principals, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        this.assertRealmsConfigured();
        for (IRealm realm : this.getRealms()) {
            if (!(realm instanceof IAuthorizer) || !((IAuthorizer)((Object)realm)).isPermitted(principals, permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRole(@Nullable IPrincipalCollection principals, @NotNull String roleIdentifier) {
        Intrinsics.checkNotNullParameter((Object)roleIdentifier, (String)"roleIdentifier");
        this.assertRealmsConfigured();
        for (IRealm realm : this.getRealms()) {
            if (!(realm instanceof IAuthorizer) || !((IAuthorizer)((Object)realm)).hasRole(principals, roleIdentifier)) continue;
            return true;
        }
        return false;
    }

    private final void assertRealmsConfigured() {
        Collection<? extends IRealm> collection = this._realms;
        if (collection == null || collection.isEmpty()) {
            throw new IllegalStateException("Configuration error:  No realms have been configured!  One or more realms must be present to execute an authorization operation.");
        }
    }
}

