/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.authz;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.bos.security.authz.permission.IPermission;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\u0014\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\tJ\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lkd/bos/security/authz/SimpleRole;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "permissions", "", "Lkd/bos/security/authz/permission/IPermission;", "getPermissions", "()Ljava/util/Set;", "setPermissions", "(Ljava/util/Set;)V", "add", "", "permission", "addAll", "perms", "", "equals", "", "other", "hashCode", "", "isPermitted", "p", "toString", "bos-olap-security"})
public final class SimpleRole {
    @NotNull
    private final String name;
    @NotNull
    private Set<IPermission> permissions;

    public SimpleRole(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.permissions = new LinkedHashSet();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Set<IPermission> getPermissions() {
        return this.permissions;
    }

    public final void setPermissions(@NotNull Set<IPermission> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.permissions = set;
    }

    public final void add(@NotNull IPermission permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        this.permissions.add(permission);
    }

    public final void addAll(@NotNull Collection<? extends IPermission> perms) {
        Intrinsics.checkNotNullParameter(perms, (String)"perms");
        if (!perms.isEmpty()) {
            this.permissions.addAll(perms);
        }
    }

    public final boolean isPermitted(@NotNull IPermission p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (!((Collection)this.permissions).isEmpty()) {
            for (IPermission perm : this.permissions) {
                if (!perm.implies(p)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type kd.bos.security.authz.SimpleRole");
        SimpleRole cfr_ignored_0 = (SimpleRole)other;
        return Intrinsics.areEqual((Object)this.name, (Object)((SimpleRole)other).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

