/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.authz.permission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import kd.bos.security.authz.permission.IPermission;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0014\u001a\u00020\u0004H\u0016R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkd/bos/security/authz/permission/WildcardPermission;", "Lkd/bos/security/authz/permission/IPermission;", "Ljava/io/Serializable;", "wildcardString", "", "caseSensitive", "", "(Ljava/lang/String;Z)V", "parts", "", "", "equals", "other", "", "hashCode", "", "implies", "p", "setParts", "", "toString", "Companion", "bos-olap-security"})
@SourceDebugExtension(value={"SMAP\nWildcardPermission.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WildcardPermission.kt\nkd/bos/security/authz/permission/WildcardPermission\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,101:1\n1#2:102\n731#3,9:103\n731#3,9:114\n37#4,2:112\n37#4,2:123\n*S KotlinDebug\n*F\n+ 1 WildcardPermission.kt\nkd/bos/security/authz/permission/WildcardPermission\n*L\n24#1:103,9\n28#1:114,9\n25#1:112,2\n29#1:123,2\n*E\n"})
public final class WildcardPermission
implements IPermission,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<Set<String>> parts;
    @NotNull
    private static final String WILDCARD_TOKEN = "*";
    @NotNull
    private static final String PART_DIVIDER_TOKEN = ":";
    @NotNull
    private static final String SUBPART_DIVIDER_TOKEN = ",";
    private static final boolean DEFAULT_CASE_SENSITIVE = false;

    public WildcardPermission(@NotNull String wildcardString, boolean caseSensitive) {
        Intrinsics.checkNotNullParameter((Object)wildcardString, (String)"wildcardString");
        this.parts = new ArrayList();
        this.setParts(wildcardString, caseSensitive);
    }

    public /* synthetic */ WildcardPermission(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void setParts(String wildcardString, boolean caseSensitive) {
        void $this$toTypedArray$iv;
        List list;
        Object it;
        Collection $this$dropLastWhile$iv;
        String tempString = ((Object)StringsKt.trim((CharSequence)wildcardString)).toString();
        if (!(!StringsKt.isBlank((CharSequence)tempString))) {
            boolean $i$a$-require-WildcardPermission$setParts$42 = false;
            String $i$a$-require-WildcardPermission$setParts$42 = "Wildcard string cannot be null or blank. Make sure permission strings are properly formatted.";
            throw new IllegalArgumentException($i$a$-require-WildcardPermission$setParts$42.toString());
        }
        if (!caseSensitive) {
            String string = tempString;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            tempString = string2;
        }
        Object $i$a$-require-WildcardPermission$setParts$42 = tempString;
        Regex regex = new Regex(PART_DIVIDER_TOKEN);
        int n = 0;
        $i$a$-require-WildcardPermission$setParts$42 = regex.split((CharSequence)$i$a$-require-WildcardPermission$setParts$42, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        List parts = ArraysKt.toList((Object[])thisCollection$iv.toArray(new String[0]));
        this.parts = new ArrayList();
        for (String part : parts) {
            void $this$toTypedArray$iv2;
            List list2;
            Collection $this$dropLastWhile$iv2;
            it = part;
            Regex bl = new Regex(SUBPART_DIVIDER_TOKEN);
            int n2 = 0;
            it = bl.split((CharSequence)it, n2);
            boolean $i$f$dropLastWhile2 = false;
            if (!$this$dropLastWhile$iv2.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    if (((CharSequence)it2).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv2 = list2;
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv2;
            Set subparts = ArraysKt.toSet((Object[])thisCollection$iv2.toArray(new String[0]));
            if (!(!((Collection)subparts).isEmpty())) {
                boolean bl3 = false;
                String string = "Wildcard string cannot contain parts with only dividers. Make sure permission strings are properly formatted.";
                throw new IllegalArgumentException(string.toString());
            }
            this.parts.add(subparts);
        }
        if (!(!((Collection)this.parts).isEmpty())) {
            boolean bl = false;
            String string = "Wildcard string cannot contain only dividers. Make sure permission strings are properly formatted.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean implies(@Nullable IPermission p) {
        if (!(p instanceof WildcardPermission)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List<Set<String>> otherParts = ((WildcardPermission)p).parts;
        int i = 0;
        for (Set<String> otherPart : otherParts) {
            if (this.parts.size() - 1 < i) {
                return true;
            }
            Set<String> part = this.parts.get(i);
            if (!part.contains(WILDCARD_TOKEN) && !part.containsAll((Collection)otherPart)) {
                return false;
            }
            ++i;
        }
        while (i < this.parts.size()) {
            Set<String> part = this.parts.get(i);
            if (!part.contains(WILDCARD_TOKEN)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Set<String> part : this.parts) {
            if (((CharSequence)buffer).length() > 0) {
                buffer.append(PART_DIVIDER_TOKEN);
            }
            Iterator<String> partIt = part.iterator();
            while (partIt.hasNext()) {
                buffer.append(partIt.next());
                if (!partIt.hasNext()) continue;
                buffer.append(SUBPART_DIVIDER_TOKEN);
            }
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof WildcardPermission) {
            return Intrinsics.areEqual(this.parts, ((WildcardPermission)other).parts);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.parts).hashCode();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkd/bos/security/authz/permission/WildcardPermission$Companion;", "", "()V", "DEFAULT_CASE_SENSITIVE", "", "PART_DIVIDER_TOKEN", "", "SUBPART_DIVIDER_TOKEN", "WILDCARD_TOKEN", "bos-olap-security"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

