/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.chain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import kd.bos.security.chain.IFilterChainManager;
import kd.bos.security.chain.INamedFilterList;
import kd.bos.security.chain.SimpleNamedFilterList;
import kd.bos.security.exceptions.ConfigurationException;
import kd.bos.security.filter.DefaultFilter;
import kd.bos.security.filter.INameable;
import kd.bos.security.filter.IPathConfigProcessor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J$\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0016J\"\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!H\u0016J\u0010\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0005J\b\u0010#\u001a\u00020\u0015H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0016\u0010'\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050(H\u0016J\u001b\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050*2\u0006\u0010+\u001a\u00020\u0005\u00a2\u0006\u0002\u0010,R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lkd/bos/security/chain/DefaultFilterChainManager;", "Lkd/bos/security/chain/IFilterChainManager;", "()V", "filterChains", "", "", "Lkd/bos/security/chain/INamedFilterList;", "getFilterChains", "()Ljava/util/Map;", "setFilterChains", "(Ljava/util/Map;)V", "filters", "Ljavax/servlet/Filter;", "getFilters", "globalFilterNames", "", "addFilter", "", "name", "filter", "overwrite", "", "addToChain", "chainName", "filterName", "chainSpecificFilterConfig", "applyChainConfig", "createChain", "chainDefinition", "createDefaultChain", "ensureChain", "getChain", "getChainNames", "", "getFilter", "hasChains", "proxy", "Ljavax/servlet/FilterChain;", "originalChain", "setGlobalFilters", "", "toNameConfigPair", "", "token", "(Ljava/lang/String;)[Ljava/lang/String;", "bos-olap-security"})
@SourceDebugExtension(value={"SMAP\nDefaultFilterChainManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultFilterChainManager.kt\nkd/bos/security/chain/DefaultFilterChainManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
public final class DefaultFilterChainManager
implements IFilterChainManager {
    @NotNull
    private final Map<String, Filter> filters = new LinkedHashMap();
    @NotNull
    private final List<String> globalFilterNames = new ArrayList();
    @NotNull
    private Map<String, INamedFilterList> filterChains = new LinkedHashMap();

    public DefaultFilterChainManager() {
        for (DefaultFilter defaultFilter : DefaultFilter.values()) {
            this.addFilter(defaultFilter.name(), defaultFilter.newInstance(), false);
        }
    }

    @Override
    @NotNull
    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    @NotNull
    public final Map<String, INamedFilterList> getFilterChains() {
        return this.filterChains;
    }

    public final void setFilterChains(@NotNull Map<String, INamedFilterList> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.filterChains = map;
    }

    @Override
    @Nullable
    public INamedFilterList getChain(@NotNull String chainName) {
        Intrinsics.checkNotNullParameter((Object)chainName, (String)"chainName");
        return this.filterChains.get(chainName);
    }

    @Override
    public boolean hasChains() {
        return !this.filterChains.isEmpty();
    }

    @Override
    @NotNull
    public Set<String> getChainNames() {
        return this.filterChains.keySet();
    }

    @Override
    @NotNull
    public FilterChain proxy(@NotNull FilterChain originalChain, @NotNull String chainName) {
        Intrinsics.checkNotNullParameter((Object)originalChain, (String)"originalChain");
        Intrinsics.checkNotNullParameter((Object)chainName, (String)"chainName");
        INamedFilterList iNamedFilterList = this.getChain(chainName);
        if (iNamedFilterList == null) {
            throw new IllegalArgumentException("There is no configured chain under the name/key [" + chainName + "].");
        }
        INamedFilterList configured = iNamedFilterList;
        return configured.proxy(originalChain);
    }

    @Nullable
    public final Filter getFilter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getFilters().get(name);
    }

    @Override
    public void addFilter(@NotNull String name, @NotNull Filter filter, boolean overwrite) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Filter existing = this.getFilter(name);
        if (existing == null || overwrite) {
            if (filter instanceof INameable) {
                ((INameable)filter).resetName(name);
            }
            this.getFilters().put(name, filter);
        }
    }

    @Override
    public void createChain(@NotNull String chainName, @NotNull String chainDefinition) {
        Intrinsics.checkNotNullParameter((Object)chainName, (String)"chainName");
        Intrinsics.checkNotNullParameter((Object)chainDefinition, (String)"chainDefinition");
        if (StringsKt.isBlank((CharSequence)chainName)) {
            throw new NullPointerException("chainName cannot be null or empty.");
        }
        if (StringsKt.isBlank((CharSequence)chainDefinition)) {
            throw new NullPointerException("chainDefinition cannot be null or empty.");
        }
        if (!((Collection)this.globalFilterNames).isEmpty()) {
            this.globalFilterNames.stream().forEach(arg_0 -> DefaultFilterChainManager.createChain$lambda$0((Function1)new Function1<String, Unit>(this, chainName){
                final /* synthetic */ DefaultFilterChainManager this$0;
                final /* synthetic */ String $chainName;
                {
                    this.this$0 = $receiver;
                    this.$chainName = $chainName;
                    super(1);
                }

                public final void invoke(String filterName) {
                    Intrinsics.checkNotNull((Object)filterName);
                    this.this$0.addToChain(this.$chainName, filterName);
                }
            }, arg_0));
        }
        String[] stringArray = new String[]{","};
        List filterTokens = StringsKt.split$default((CharSequence)chainDefinition, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (String token : filterTokens) {
            String[] nameConfigPair = this.toNameConfigPair(token);
            this.addToChain(chainName, nameConfigPair[0], nameConfigPair[1]);
        }
    }

    @Override
    public void createDefaultChain(@NotNull String chainName) {
        Intrinsics.checkNotNullParameter((Object)chainName, (String)"chainName");
        if (!this.getChainNames().contains(chainName) && !((Collection)this.globalFilterNames).isEmpty()) {
            this.globalFilterNames.stream().forEach(arg_0 -> DefaultFilterChainManager.createDefaultChain$lambda$1((Function1)new Function1<String, Unit>(this, chainName){
                final /* synthetic */ DefaultFilterChainManager this$0;
                final /* synthetic */ String $chainName;
                {
                    this.this$0 = $receiver;
                    this.$chainName = $chainName;
                    super(1);
                }

                public final void invoke(String filterName) {
                    Intrinsics.checkNotNull((Object)filterName);
                    this.this$0.addToChain(this.$chainName, filterName);
                }
            }, arg_0));
        }
    }

    @Override
    public void addToChain(@NotNull String chainName, @NotNull String filterName) {
        Intrinsics.checkNotNullParameter((Object)chainName, (String)"chainName");
        Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
        this.addToChain(chainName, filterName, null);
    }

    @Override
    public void addToChain(@NotNull String chainName, @Nullable String filterName, @Nullable String chainSpecificFilterConfig) {
        Intrinsics.checkNotNullParameter((Object)chainName, (String)"chainName");
        if (!(!StringsKt.isBlank((CharSequence)chainName))) {
            boolean $i$a$-require-DefaultFilterChainManager$addToChain$32 = false;
            String $i$a$-require-DefaultFilterChainManager$addToChain$32 = "chainName cannot be null or empty.";
            throw new IllegalArgumentException($i$a$-require-DefaultFilterChainManager$addToChain$32.toString());
        }
        CharSequence charSequence = filterName;
        if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) {
            boolean bl = false;
            String string = "chainName cannot be null or empty.";
            throw new IllegalArgumentException(string.toString());
        }
        Filter filter = this.getFilter(filterName);
        if (filter == null) {
            throw new IllegalArgumentException("There is no filter with name '" + filterName + "' to apply to chain [" + chainName + "] in the pool of available Filters.  Ensure a filter with that name/path has first been registered with the addFilter method(s).");
        }
        Filter filter2 = filter;
        this.applyChainConfig(chainName, filter2, chainSpecificFilterConfig);
        this.ensureChain(chainName).add(filter2);
    }

    @Override
    public void setGlobalFilters(@NotNull List<String> globalFilterNames) {
        Intrinsics.checkNotNullParameter(globalFilterNames, (String)"globalFilterNames");
        if (!((Collection)globalFilterNames).isEmpty()) {
            for (String filterName : globalFilterNames) {
                if (this.getFilters().get(filterName) == null) {
                    throw new ConfigurationException("There is no filter with name '" + filterName + "' to apply to the global filters in the pool of available Filters.  Ensure a filter with that name/path has first been registered with the addFilter method(s).");
                }
                this.globalFilterNames.add(filterName);
            }
        }
    }

    private final void applyChainConfig(String chainName, Filter filter, String chainSpecificFilterConfig) {
        if (filter instanceof IPathConfigProcessor) {
            ((IPathConfigProcessor)filter).processPathConfig(chainName, chainSpecificFilterConfig);
        } else {
            CharSequence charSequence = chainSpecificFilterConfig;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                String msg = "chainSpecificFilterConfig was specified, but the underlying Filter instance is not an 'instanceof' " + IPathConfigProcessor.class.getName() + ".  This is required if the filter is to accept chain-specific configuration.";
                throw new ConfigurationException(msg);
            }
        }
    }

    @NotNull
    public final String[] toNameConfigPair(@NotNull String token) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        try {
            String string;
            CharSequence charSequence = token;
            Regex regex = new Regex("\\[");
            int n = 2;
            List pair = regex.split(charSequence, n);
            String name = ((Object)StringsKt.trim((CharSequence)((String)pair.get(0)))).toString();
            String config = null;
            if (pair.size() == 2) {
                config = ((Object)StringsKt.trim((CharSequence)((String)pair.get(1)))).toString();
                String string2 = config.substring(0, config.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                config = string2;
                config = ((Object)StringsKt.trim((CharSequence)config)).toString();
                if (StringsKt.startsWith$default((String)config, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)config, (String)"\"", (boolean)false, (int)2, null)) {
                    String string3 = config.substring(1, config.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String stripped = string3;
                    stripped = ((Object)StringsKt.trim((CharSequence)stripped)).toString();
                    if (StringsKt.indexOf$default((CharSequence)stripped, (char)'\"', (int)0, (boolean)false, (int)6, null) == -1) {
                        config = stripped;
                    }
                }
            }
            String[] stringArray2 = new String[2];
            stringArray2[0] = name;
            String[] stringArray3 = stringArray2;
            int n2 = 1;
            String string4 = config;
            if (string4 != null) {
                CharSequence charSequence2;
                CharSequence charSequence3 = string4;
                if (StringsKt.isBlank((CharSequence)charSequence3)) {
                    int n3 = n2;
                    String[] stringArray4 = stringArray3;
                    boolean bl = false;
                    Object var10_14 = null;
                    stringArray3 = stringArray4;
                    n2 = n3;
                    charSequence2 = var10_14;
                } else {
                    charSequence2 = charSequence3;
                }
                string = (String)charSequence2;
            } else {
                string = null;
            }
            stringArray3[n2] = string;
            stringArray = stringArray2;
        }
        catch (Exception e) {
            String msg = "Unable to parse filter chain definition token: " + token;
            throw new ConfigurationException(msg, e);
        }
        return stringArray;
    }

    private final INamedFilterList ensureChain(String chainName) {
        INamedFilterList chain = this.getChain(chainName);
        if (chain == null) {
            chain = new SimpleNamedFilterList(chainName);
            this.filterChains.put(chainName, chain);
        }
        return chain;
    }

    private static final void createChain$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createDefaultChain$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

