/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.chain;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.security.chain.DefaultFilterChainManager;
import kd.bos.security.chain.IFilterChainManager;
import kd.bos.security.chain.IFilterChainResolver;
import kd.bos.security.matcher.AntPathMatcher;
import kd.bos.security.matcher.IPatternMatcher;
import kd.bos.security.utils.WebUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lkd/bos/security/chain/PathMatchingFilterChainResolver;", "Lkd/bos/security/chain/IFilterChainResolver;", "()V", "filterChainManager", "Lkd/bos/security/chain/IFilterChainManager;", "getFilterChainManager", "()Lkd/bos/security/chain/IFilterChainManager;", "pathMatcher", "Lkd/bos/security/matcher/IPatternMatcher;", "getPathMatcher", "()Lkd/bos/security/matcher/IPatternMatcher;", "getChain", "Ljavax/servlet/FilterChain;", "request", "Ljavax/servlet/ServletRequest;", "response", "Ljavax/servlet/ServletResponse;", "originalChain", "pathMatches", "", "pattern", "", "path", "removeTrailingSlash", "bos-olap-security"})
public final class PathMatchingFilterChainResolver
implements IFilterChainResolver {
    @NotNull
    private final IFilterChainManager filterChainManager = new DefaultFilterChainManager();
    @NotNull
    private final IPatternMatcher pathMatcher = new AntPathMatcher();

    @NotNull
    public final IFilterChainManager getFilterChainManager() {
        return this.filterChainManager;
    }

    @NotNull
    public final IPatternMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Override
    @Nullable
    public FilterChain getChain(@NotNull ServletRequest request, @NotNull ServletResponse response, @NotNull FilterChain originalChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)originalChain, (String)"originalChain");
        if (!(request instanceof HttpServletRequest)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(response instanceof HttpServletResponse)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        IFilterChainManager fcm = this.filterChainManager;
        if (!fcm.hasChains()) {
            return null;
        }
        String string = WebUtils.INSTANCE.getPathWithinApplication((HttpServletRequest)request);
        Intrinsics.checkNotNull((Object)string);
        String requestURI = string;
        String requestURINoTrailingSlash = this.removeTrailingSlash(requestURI);
        for (String pathPattern : this.filterChainManager.getChainNames()) {
            String tempPattern;
            if (this.pathMatches(pathPattern, requestURI)) {
                return this.filterChainManager.proxy(originalChain, pathPattern);
            }
            Intrinsics.checkNotNull((Object)this.removeTrailingSlash(pathPattern));
            if (!this.pathMatches(tempPattern, requestURINoTrailingSlash)) continue;
            return this.filterChainManager.proxy(originalChain, tempPattern);
        }
        return null;
    }

    private final boolean pathMatches(String pattern, String path) {
        return this.pathMatcher.match(pattern, path);
    }

    private final String removeTrailingSlash(String path) {
        String string;
        if (path != null && !Intrinsics.areEqual((Object)"/", (Object)path) && StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            String string2 = path.substring(0, path.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = path;
        }
        return string;
    }
}

