/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.config;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import kd.bos.security.exceptions.MddSecurityException;
import kd.bos.security.mgt.DefaultSecurityManager;
import kd.bos.security.realm.IniRealm;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0007\u0018\u0000 :2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002:;B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0013\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u0002H\u0096\u0002J\u000e\u0010#\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00022\u0006\u0010%\u001a\u00020\u0002H\u0002J\b\u0010&\u001a\u00020\u001eH\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0002H\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u0002J\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u0002H\u0002J\u001a\u00102\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0003H\u0016J\u001e\u00103\u001a\u00020\u00182\u0014\u00104\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000305H\u0016J\u0012\u00106\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u000e\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u0002J\u0010\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u0002R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006<"}, d2={"Lkd/bos/security/config/Ini;", "", "", "Lkd/bos/security/config/Ini$Section;", "()V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "sections", "getSections", "()Ljava/util/Map;", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "addSection", "", "name", "content", "Ljava/lang/StringBuilder;", "clear", "containsKey", "", "key", "containsValue", "value", "get", "getSection", "getSectionName", "line", "isEmpty", "isSectionHeader", "load", "ins", "Ljava/io/InputStream;", "reader", "Ljava/io/InputStreamReader;", "scanner", "Ljava/util/Scanner;", "iniConfig", "loadFromPath", "resourcePath", "put", "putAll", "from", "", "remove", "removeSection", "s", "tryGetSection", "Companion", "Section", "bos-olap-security"})
public final class Ini
implements Map<String, Section>,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Section> sections = new LinkedHashMap();
    @NotNull
    public static final String DEFAULT_SECTION_NAME = "";
    @NotNull
    private static final String COMMENT_POUND = "#";
    @NotNull
    private static final String COMMENT_SEMICOLON = ";";
    @NotNull
    private static final String SECTION_PREFIX = "[";
    @NotNull
    private static final String SECTION_SUFFIX = "]";
    public static final char ESCAPE_TOKEN = '\\';

    @NotNull
    public final Map<String, Section> getSections() {
        return this.sections;
    }

    @NotNull
    public final Section getSection(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Section section = this.sections.get(key);
        if (section == null) {
            throw new MddSecurityException("can not find section by: " + key);
        }
        return section;
    }

    @Nullable
    public final Section tryGetSection(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sections.get(key);
    }

    public final void removeSection(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.sections.remove(s);
    }

    public final void load(@NotNull String iniConfig) {
        Intrinsics.checkNotNullParameter((Object)iniConfig, (String)"iniConfig");
        this.load(new Scanner(iniConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadFromPath(String resourcePath) {
        Closeable closeable = new FileInputStream(resourcePath);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            this.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load(InputStream ins) {
        Closeable closeable = new InputStreamReader(ins);
        Throwable throwable = null;
        try {
            InputStreamReader it = (InputStreamReader)closeable;
            boolean bl = false;
            this.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load(InputStreamReader reader) {
        Closeable closeable = new Scanner(reader);
        Throwable throwable = null;
        try {
            Scanner it = (Scanner)closeable;
            boolean bl = false;
            this.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void load(Scanner scanner) {
        String sectionName = DEFAULT_SECTION_NAME;
        StringBuilder sectionContent = new StringBuilder();
        while (scanner.hasNextLine()) {
            String rawLine = scanner.nextLine();
            Intrinsics.checkNotNull((Object)rawLine);
            String line = ((Object)StringsKt.trim((CharSequence)rawLine)).toString();
            if (StringsKt.isBlank((CharSequence)line) || StringsKt.startsWith$default((String)line, (String)COMMENT_POUND, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)COMMENT_SEMICOLON, (boolean)false, (int)2, null)) continue;
            String newSectionName = this.getSectionName(line);
            if (newSectionName != null) {
                this.addSection(sectionName, sectionContent);
                sectionContent = new StringBuilder();
                sectionName = newSectionName;
                continue;
            }
            sectionContent.append(rawLine).append("\n");
        }
        this.addSection(sectionName, sectionContent);
    }

    private final void addSection(String name, StringBuilder content) {
        if (((CharSequence)content).length() > 0) {
            Section section;
            String string = content.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String contentString = string;
            String cleaned = ((Object)StringsKt.trim((CharSequence)contentString)).toString();
            if (!StringsKt.isBlank((CharSequence)cleaned) && !((Map)(section = new Section(name, contentString))).isEmpty()) {
                this.sections.put(name, section);
            }
        }
    }

    private final String getSectionName(String line) {
        String string;
        if (this.isSectionHeader(((Object)StringsKt.trim((CharSequence)line)).toString())) {
            String string2 = line.substring(1, line.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            string = null;
        }
        return string;
    }

    private final boolean isSectionHeader(String line) {
        String s = ((Object)StringsKt.trim((CharSequence)line)).toString();
        return StringsKt.startsWith$default((String)s, (String)SECTION_PREFIX, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)s, (String)SECTION_SUFFIX, (boolean)false, (int)2, null);
    }

    @NotNull
    public Set<Map.Entry<String, Section>> getEntries() {
        return this.sections.entrySet();
    }

    @NotNull
    public Set<String> getKeys() {
        return this.sections.keySet();
    }

    public int getSize() {
        return this.sections.size();
    }

    @NotNull
    public Collection<Section> getValues() {
        return this.sections.values();
    }

    @Override
    public void clear() {
        this.sections.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.sections.isEmpty();
    }

    @Nullable
    public Section remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sections.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends Section> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.sections.putAll(from);
    }

    @Override
    @Nullable
    public Section put(@NotNull String key, @NotNull Section value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.sections.put(key, value);
    }

    @Nullable
    public Section get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sections.get(key);
    }

    public boolean containsValue(@NotNull Section value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.sections.containsValue(value);
    }

    public boolean containsKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sections.containsKey(key);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0004J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0004J\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\"2\u0006\u0010#\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lkd/bos/security/config/Ini$Companion;", "", "()V", "COMMENT_POUND", "", "COMMENT_SEMICOLON", "DEFAULT_SECTION_NAME", "ESCAPE_TOKEN", "", "SECTION_PREFIX", "SECTION_SUFFIX", "createSecurityManager", "Lkd/bos/security/mgt/DefaultSecurityManager;", "ini", "Lkd/bos/security/config/Ini;", "isCharEscaped", "", "s", "", "index", "", "isContinued", "line", "isKeyValueSeparatorChar", "c", "read", "inputStream", "Ljava/io/InputStream;", "resourcePath", "splitKeyValue", "", "keyValueLine", "(Ljava/lang/String;)[Ljava/lang/String;", "toMapProps", "", "content", "bos-olap-security"})
    @SourceDebugExtension(value={"SMAP\nIni.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ini.kt\nkd/bos/security/config/Ini$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n1#2:294\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Ini read(@NotNull InputStream inputStream) {
            Ini ini;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Ini $this$read_u24lambda_u241 = ini = new Ini();
            boolean bl = false;
            Closeable closeable = new InputStreamReader(inputStream);
            Throwable throwable = null;
            try {
                InputStreamReader iniReader = (InputStreamReader)closeable;
                boolean bl2 = false;
                $this$read_u24lambda_u241.load(iniReader);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return ini;
        }

        @NotNull
        public final Ini read(@NotNull String resourcePath) {
            Ini ini;
            Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
            if (!(!StringsKt.isBlank((CharSequence)resourcePath))) {
                boolean $i$a$-require-Ini$Companion$read$32 = false;
                String $i$a$-require-Ini$Companion$read$32 = "Resource Path argument cannot be null or empty.";
                throw new IllegalArgumentException($i$a$-require-Ini$Companion$read$32.toString());
            }
            Ini $this$read_u24lambda_u243 = ini = new Ini();
            boolean bl = false;
            $this$read_u24lambda_u243.loadFromPath(resourcePath);
            return ini;
        }

        @NotNull
        public final DefaultSecurityManager createSecurityManager(@NotNull Ini ini) {
            Intrinsics.checkNotNullParameter((Object)ini, (String)"ini");
            return ini.isEmpty() ? new DefaultSecurityManager() : new DefaultSecurityManager(new IniRealm(ini));
        }

        private final Map<String, String> toMapProps(String content) {
            Map props = new LinkedHashMap();
            String line = null;
            StringBuilder lineBuffer = new StringBuilder();
            Scanner scanner = new Scanner(content);
            while (scanner.hasNextLine()) {
                String string = scanner.nextLine();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextLine(...)");
                line = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (this.isContinued(line)) {
                    String string2 = line.substring(0, line.length() - 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    line = string2;
                    lineBuffer.append(line);
                    continue;
                }
                lineBuffer.append(line);
                String string3 = lineBuffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                line = string3;
                lineBuffer = new StringBuilder();
                String[] kvPair = this.splitKeyValue(line);
                props.put(kvPair[0], kvPair[1]);
            }
            return props;
        }

        public final boolean isContinued(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (StringsKt.isBlank((CharSequence)line)) {
                return false;
            }
            int length = line.length();
            int backslashCount = 0;
            for (int i = length - 1; 0 < i && line.charAt(i) == '\\'; --i) {
                ++backslashCount;
            }
            return backslashCount % 2 != 0;
        }

        private final String[] splitKeyValue(String keyValueLine) {
            String line = ((Object)StringsKt.trim((CharSequence)keyValueLine)).toString();
            StringBuilder keyBuffer = new StringBuilder();
            StringBuilder valueBuffer = new StringBuilder();
            boolean buildingKey = true;
            int n = line.length();
            for (int i = 0; i < n; ++i) {
                char c = line.charAt(i);
                if (buildingKey) {
                    if (this.isKeyValueSeparatorChar(c) && !this.isCharEscaped(line, i) && !this.isCharEscaped(line, i - 1)) {
                        buildingKey = false;
                        continue;
                    }
                    if (this.isCharEscaped(line, i)) continue;
                    keyBuffer.append(c);
                    continue;
                }
                if (((CharSequence)valueBuffer).length() == 0 && this.isKeyValueSeparatorChar(c) && !this.isCharEscaped(line, i)) continue;
                valueBuffer.append(c);
            }
            String string = keyBuffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String key = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String string2 = valueBuffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String value = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (StringsKt.isBlank((CharSequence)value)) {
                String msg = "Line argument must contain a key and a value.  Only one String token was found.";
                throw new IllegalArgumentException(msg);
            }
            String[] stringArray = new String[]{key, value};
            return stringArray;
        }

        private final boolean isKeyValueSeparatorChar(char c) {
            return Character.isWhitespace(c) || c == ':' || c == '=';
        }

        private final boolean isCharEscaped(CharSequence s, int index) {
            return index > 0 && s.charAt(index) == '\\';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0002H\u0016J\u0013\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0096\u0002J\b\u0010\"\u001a\u00020\u001dH\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0002H\u0016J\u001e\u0010$\u001a\u00020\u001b2\u0014\u0010%\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020&H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0016R&\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lkd/bos/security/config/Ini$Section;", "", "", "name", "(Ljava/lang/String;)V", "sectionContent", "(Ljava/lang/String;Ljava/lang/String;)V", "props", "(Ljava/lang/String;Ljava/util/Map;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "getName", "()Ljava/lang/String;", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "clear", "", "containsKey", "", "key", "containsValue", "value", "get", "isEmpty", "put", "putAll", "from", "", "remove", "bos-olap-security"})
    public static final class Section
    implements Map<String, String>,
    KMutableMap {
        @NotNull
        private final String name;
        @NotNull
        private final Map<String, String> props;

        public Section(@NotNull String name, @NotNull Map<String, String> props) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(props, (String)"props");
            this.name = name;
            this.props = props;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public Section(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this(name, new LinkedHashMap());
        }

        public Section(@NotNull String name, @NotNull String sectionContent) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)sectionContent, (String)"sectionContent");
            this(name);
            if (!StringsKt.isBlank((CharSequence)sectionContent)) {
                this.props.putAll(Companion.toMapProps(sectionContent));
            }
        }

        @NotNull
        public Set<Map.Entry<String, String>> getEntries() {
            return this.props.entrySet();
        }

        @NotNull
        public Set<String> getKeys() {
            return this.props.keySet();
        }

        public int getSize() {
            return this.props.size();
        }

        @NotNull
        public Collection<String> getValues() {
            return this.props.values();
        }

        @Override
        public void clear() {
            this.props.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.props.isEmpty();
        }

        @Nullable
        public String remove(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.props.remove(key);
        }

        @Override
        public void putAll(@NotNull Map<? extends String, ? extends String> from) {
            Intrinsics.checkNotNullParameter(from, (String)"from");
            this.props.putAll(from);
        }

        @Override
        @Nullable
        public String put(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.props.put(key, value);
        }

        @Nullable
        public String get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.props.get(key);
        }

        public boolean containsValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.props.containsValue(value);
        }

        public boolean containsKey(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.props.containsKey(key);
        }
    }
}

