/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.env;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.security.env.INamedObjectEnvironment;
import kd.bos.security.exceptions.RequiredTypeException;
import kd.bos.security.mgt.ISecurityManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lkd/bos/security/env/DefaultEnvironment;", "Lkd/bos/security/env/INamedObjectEnvironment;", "()V", "objects", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getObjects", "()Ljava/util/concurrent/ConcurrentHashMap;", "value", "Lkd/bos/security/mgt/ISecurityManager;", "securityManager", "getSecurityManager", "()Lkd/bos/security/mgt/ISecurityManager;", "setSecurityManager", "(Lkd/bos/security/mgt/ISecurityManager;)V", "getObject", "T", "name", "requiredType", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "setObject", "", "instance", "bos-olap-security"})
public class DefaultEnvironment
implements INamedObjectEnvironment {
    @NotNull
    private final ConcurrentHashMap<String, Object> objects = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<String, Object> getObjects() {
        return this.objects;
    }

    @Override
    @NotNull
    public ISecurityManager getSecurityManager() {
        ISecurityManager iSecurityManager = this.getObject("securityManager", ISecurityManager.class);
        if (iSecurityManager == null) {
            throw new IllegalStateException("No SecurityManager found in Environment.  This is an invalid environment state.");
        }
        return iSecurityManager;
    }

    public void setSecurityManager(@NotNull ISecurityManager value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setObject("securityManager", value);
    }

    @Override
    @Nullable
    public final <T> T getObject(@NotNull String name, @NotNull Class<T> requiredType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(requiredType, (String)"requiredType");
        Object object = this.objects.get(name);
        if (object == null) {
            return null;
        }
        Object o = object;
        if (!requiredType.isInstance(o)) {
            String msg = "Object named '" + name + "' (of type [" + o.getClass().getName() + "]) is not of required type [" + requiredType.getName() + "].";
            throw new RequiredTypeException(msg);
        }
        return (T)o;
    }

    public final void setObject(@NotNull String name, @Nullable Object instance) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (instance == null) {
            this.objects.remove(name);
        } else {
            ((Map)this.objects).put(name, instance);
        }
    }
}

