/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.env;

import javax.servlet.ServletContext;
import kd.bos.security.env.IResourceConfigurable;
import kd.bos.security.env.IWebEnvironment;
import kd.bos.security.env.IniWebEnvironment;
import kd.bos.security.utils.LifecycleUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0010\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\b\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lkd/bos/security/env/EnvironmentLoader;", "", "()V", "createEnvironment", "Lkd/bos/security/env/IWebEnvironment;", "sc", "Ljavax/servlet/ServletContext;", "destroyEnvironment", "", "servletContext", "getDefaultWebEnvironment", "initEnvironment", "Companion", "bos-olap-security"})
public class EnvironmentLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ENVIRONMENT_ATTRIBUTE_KEY = EnvironmentLoader.class.getName() + ".ENVIRONMENT_ATTRIBUTE_KEY";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IWebEnvironment initEnvironment(@NotNull ServletContext servletContext) {
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)servletContext, (String)"servletContext");
        if (servletContext.getAttribute(ENVIRONMENT_ATTRIBUTE_KEY) != null) {
            String msg = "There is already a mdd environment associated with the current ServletContext.  Check if you have multiple EnvironmentLoader* definitions in your web.xml!";
            throw new IllegalStateException(msg);
        }
        try {
            IWebEnvironment environment = this.createEnvironment(servletContext);
            servletContext.setAttribute(ENVIRONMENT_ATTRIBUTE_KEY, (Object)environment);
        }
        catch (Exception ex) {
            servletContext.setAttribute(ENVIRONMENT_ATTRIBUTE_KEY, (Object)ex);
            throw ex;
        }
        return var2_3;
    }

    private final IWebEnvironment getDefaultWebEnvironment() {
        return new IniWebEnvironment();
    }

    @NotNull
    public final IWebEnvironment createEnvironment(@NotNull ServletContext sc) {
        Intrinsics.checkNotNullParameter((Object)sc, (String)"sc");
        IWebEnvironment webEnvironment = this.getDefaultWebEnvironment();
        String locations = sc.getInitParameter("mddConfigLocations");
        CharSequence charSequence = locations;
        boolean configSpecified = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
        webEnvironment.setServletContext(sc);
        if (configSpecified && webEnvironment instanceof IResourceConfigurable) {
            IResourceConfigurable iResourceConfigurable = (IResourceConfigurable)((Object)webEnvironment);
            Intrinsics.checkNotNull((Object)locations);
            iResourceConfigurable.setConfigLocations(locations);
        }
        LifecycleUtils.INSTANCE.init(webEnvironment);
        return webEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroyEnvironment(@NotNull ServletContext servletContext) {
        Intrinsics.checkNotNullParameter((Object)servletContext, (String)"servletContext");
        try {
            Object environment = servletContext.getAttribute(ENVIRONMENT_ATTRIBUTE_KEY);
            Intrinsics.checkNotNull((Object)environment);
            LifecycleUtils.INSTANCE.destroy(environment);
        }
        finally {
            servletContext.removeAttribute(ENVIRONMENT_ATTRIBUTE_KEY);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lkd/bos/security/env/EnvironmentLoader$Companion;", "", "()V", "ENVIRONMENT_ATTRIBUTE_KEY", "", "getENVIRONMENT_ATTRIBUTE_KEY", "()Ljava/lang/String;", "bos-olap-security"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getENVIRONMENT_ATTRIBUTE_KEY() {
            return ENVIRONMENT_ATTRIBUTE_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

