/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.env;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.security.chain.IFilterChainResolver;
import kd.bos.security.config.Ini;
import kd.bos.security.env.ResourceBasedWebEnvironment;
import kd.bos.security.exceptions.ConfigurationException;
import kd.bos.security.exceptions.MddSecurityException;
import kd.bos.security.factory.IFactory;
import kd.bos.security.factory.IniFactorySupport;
import kd.bos.security.factory.IniFilterChainResolverFactory;
import kd.bos.security.factory.WebIniSecurityManagerFactory;
import kd.bos.security.mgt.IWebSecurityManager;
import kd.bos.security.utils.Initializable;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/security/env/IniWebEnvironment;", "Lkd/bos/security/env/ResourceBasedWebEnvironment;", "Lkd/bos/security/utils/Initializable;", "()V", "_ini", "Lkd/bos/security/config/Ini;", "ini", "getIni", "()Lkd/bos/security/config/Ini;", "securityManagerFactory", "Lkd/bos/security/factory/WebIniSecurityManagerFactory;", "configure", "", "convertPathToIni", "path", "", "createFilterChainResolver", "Lkd/bos/security/chain/IFilterChainResolver;", "createWebSecurityManager", "Lkd/bos/security/mgt/IWebSecurityManager;", "getDefaults", "", "", "getSpecifiedIni", "configLocations", "", "([Ljava/lang/String;)Lkd/bos/security/config/Ini;", "init", "parseConfig", "stripPrefix", "resourcePath", "bos-olap-security"})
public final class IniWebEnvironment
extends ResourceBasedWebEnvironment
implements Initializable {
    @Nullable
    private Ini _ini;
    @NotNull
    private final WebIniSecurityManagerFactory securityManagerFactory = new WebIniSecurityManagerFactory();

    @NotNull
    public final Ini getIni() {
        Ini ini = this._ini;
        if (ini == null) {
            throw new ConfigurationException("ini is null");
        }
        return ini;
    }

    @Override
    public void init() {
        this._ini = this.parseConfig();
        this.configure();
    }

    private final Ini parseConfig() {
        Ini tempIni = this._ini;
        String[] configLocations = this.getConfigLocations();
        Map map = tempIni;
        if (map == null || map.isEmpty()) {
            tempIni = this.getSpecifiedIni(configLocations);
        }
        if ((map = (Map)tempIni) == null || map.isEmpty()) {
            throw new ConfigurationException("Mdd INI configuration was either not found or discovered to be empty/unconfigured.");
        }
        return tempIni;
    }

    private final void configure() {
        this.getObjects().clear();
        IWebSecurityManager securityManager = this.createWebSecurityManager();
        this.setWebSecurityManager(securityManager);
        IFilterChainResolver resolver = this.createFilterChainResolver();
        if (resolver != null) {
            this.setFilterChainResolver(resolver);
        }
    }

    private final Ini getSpecifiedIni(String[] configLocations) {
        Ini ini = null;
        String[] stringArray = configLocations;
        if (!(stringArray == null || stringArray.length == 0) && (ini = this.convertPathToIni(configLocations[0])).isEmpty()) {
            String msg = "Required configuration location '" + configLocations[0] + "' does not exist or did not contain any INI configuration.";
            throw new ConfigurationException(msg);
        }
        return ini;
    }

    private final IFilterChainResolver createFilterChainResolver() {
        IFilterChainResolver resolver = null;
        Ini ini = this.getIni();
        if (!((Map)ini).isEmpty()) {
            Object object = this.getObjects().get("filterChainResolver");
            if (object == null) {
                throw new MddSecurityException("filterChainResolver is null");
            }
            Object factory = object;
            if (factory instanceof IniFactorySupport) {
                ((IniFactorySupport)factory).setIni(ini);
                ((IniFactorySupport)factory).setDefaultBeans((Map<String, Object>)this.getObjects());
            }
            resolver = (IFilterChainResolver)((IFactory)factory).getInstance();
        }
        return resolver;
    }

    private final IWebSecurityManager createWebSecurityManager() {
        Ini ini = this.getIni();
        if (!((Map)ini).isEmpty()) {
            this.securityManagerFactory.setIni(ini);
        }
        Map<String, Object> defaults = this.getDefaults();
        this.securityManagerFactory.setDefaultBeans(defaults);
        Object t = this.securityManagerFactory.getInstance();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kd.bos.security.mgt.IWebSecurityManager");
        IWebSecurityManager wsm = (IWebSecurityManager)t;
        Map<String, Object> beans = this.securityManagerFactory.getBeans();
        if (!beans.isEmpty()) {
            this.getObjects().putAll(beans);
        }
        return wsm;
    }

    private final Map<String, Object> getDefaults() {
        Map map;
        Map $this$getDefaults_u24lambda_u240 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$getDefaults_u24lambda_u240.put("filterChainResolver", new IniFilterChainResolverFactory());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Ini convertPathToIni(String path) {
        if (StringsKt.isBlank((CharSequence)path)) {
            throw new ConfigurationException(path + " is blank");
        }
        try {
            Closeable closeable = new FileInputStream(this.stripPrefix(path));
            Throwable throwable = null;
            try {
                FileInputStream ins = (FileInputStream)closeable;
                boolean bl = false;
                Ini ini = Ini.Companion.read(ins);
                return ini;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    private final String stripPrefix(String resourcePath) {
        String string = resourcePath.substring(StringsKt.indexOf$default((CharSequence)resourcePath, (String)":", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }
}

