/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.factory;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import kd.bos.security.chain.IFilterChainManager;
import kd.bos.security.chain.IFilterChainResolver;
import kd.bos.security.chain.PathMatchingFilterChainResolver;
import kd.bos.security.config.Ini;
import kd.bos.security.factory.IniFactorySupport;
import kd.bos.security.factory.ReflectionBuilder;
import kd.bos.security.filter.DefaultFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\n2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014J,\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0011H\u0002J@\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00112\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00112\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180\u0011H\u0002J&\u0010\u001c\u001a\u00020\n2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/security/factory/IniFilterChainResolverFactory;", "Lkd/bos/security/factory/IniFactorySupport;", "Lkd/bos/security/chain/IFilterChainResolver;", "()V", "globalFilters", "", "", "kotlin.jvm.PlatformType", "", "buildChains", "", "manager", "Lkd/bos/security/chain/IFilterChainManager;", "ini", "Lkd/bos/security/config/Ini;", "createChains", "urls", "", "createDefaultInstance", "createInstance", "extractFilters", "", "Ljavax/servlet/Filter;", "objects", "", "getFilters", "section", "defaults", "registerFilters", "filters", "Companion", "bos-olap-security"})
public final class IniFilterChainResolverFactory
extends IniFactorySupport<IFilterChainResolver> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final List<String> globalFilters = Collections.singletonList(DefaultFilter.invalidRequest.name());
    @NotNull
    private static final String FILTERS = "filters";
    @NotNull
    private static final String URLS = "urls";

    @Override
    @NotNull
    protected IFilterChainResolver createInstance(@NotNull Ini ini) {
        Intrinsics.checkNotNullParameter((Object)ini, (String)"ini");
        IFilterChainResolver filterChainResolver = this.createDefaultInstance();
        if (filterChainResolver instanceof PathMatchingFilterChainResolver) {
            IFilterChainManager manager = ((PathMatchingFilterChainResolver)filterChainResolver).getFilterChainManager();
            this.buildChains(manager, ini);
        }
        return filterChainResolver;
    }

    @Override
    @NotNull
    protected IFilterChainResolver createDefaultInstance() {
        return new PathMatchingFilterChainResolver();
    }

    private final void buildChains(IFilterChainManager manager, Ini ini) {
        Map<String, Object> defaultBeans;
        Map<String, Object> map;
        Ini.Section section = ini.tryGetSection(FILTERS);
        Map defaults = new LinkedHashMap();
        Map<String, Filter> defaultFilters = manager.getFilters();
        if (!defaultFilters.isEmpty()) {
            defaults.putAll(defaultFilters);
        }
        if (!((map = (defaultBeans = this.getDefaultBeans())) == null || map.isEmpty())) {
            defaults.putAll(defaultBeans);
        }
        Map<String, Filter> filters = this.getFilters(section, defaults);
        this.registerFilters(filters, manager);
        List<String> list = this.globalFilters;
        Intrinsics.checkNotNullExpressionValue(list, (String)"globalFilters");
        manager.setGlobalFilters(list);
        section = ini.tryGetSection(URLS);
        this.createChains(section, manager);
        manager.createDefaultChain("/**");
    }

    private final void registerFilters(Map<String, ? extends Filter> filters, IFilterChainManager manager) {
        Map<String, ? extends Filter> map = filters;
        if (!(map == null || map.isEmpty())) {
            for (Map.Entry entry : filters.entrySet()) {
                String name = (String)entry.getKey();
                Filter filter = (Filter)entry.getValue();
                IFilterChainManager.DefaultImpls.addFilter$default(manager, name, filter, false, 4, null);
            }
        }
    }

    private final Map<String, Filter> getFilters(Map<String, String> section, Map<String, ? extends Object> defaults) {
        Map<String, Filter> filters = this.extractFilters(defaults);
        Map<String, String> map = section;
        if (!(map == null || map.isEmpty())) {
            ReflectionBuilder builder = new ReflectionBuilder(defaults);
            Map<String, Object> built = builder.buildObjects(section);
            Map<String, Filter> sectionFilters = this.extractFilters(built);
            Map<String, Filter> map2 = filters;
            if (map2 == null || map2.isEmpty()) {
                filters = sectionFilters;
            } else {
                map2 = sectionFilters;
                if (!(map2 == null || map2.isEmpty())) {
                    filters.putAll(sectionFilters);
                }
            }
        }
        return filters;
    }

    private final Map<String, Filter> extractFilters(Map<String, ? extends Object> objects) {
        Map<String, ? extends Object> map = objects;
        if (map == null || map.isEmpty()) {
            return null;
        }
        Map filterMap = new LinkedHashMap();
        for (Map.Entry<String, ? extends Object> entry : objects.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Filter)) continue;
            filterMap.put(key, value);
        }
        return filterMap;
    }

    private final void createChains(Map<String, String> urls, IFilterChainManager manager) {
        Map<String, String> map = urls;
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry entry : urls.entrySet()) {
            manager.createChain((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkd/bos/security/factory/IniFilterChainResolverFactory$Companion;", "", "()V", "FILTERS", "", "URLS", "bos-olap-security"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

