/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.factory;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.security.config.Ini;
import kd.bos.security.exceptions.ConfigurationException;
import kd.bos.security.factory.IniFactorySupport;
import kd.bos.security.factory.ReflectionBuilder;
import kd.bos.security.mgt.DefaultSecurityManager;
import kd.bos.security.mgt.ISecurityManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\f\u001a\u00020\u0002H\u0014J&\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0014J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/security/factory/IniSecurityManagerFactory;", "Lkd/bos/security/factory/IniFactorySupport;", "Lkd/bos/security/mgt/ISecurityManager;", "()V", "builder", "Lkd/bos/security/factory/ReflectionBuilder;", "buildInstances", "", "", "", "section", "Lkd/bos/security/config/Ini$Section;", "createDefaultInstance", "createDefaults", "", "ini", "Lkd/bos/security/config/Ini;", "mainSection", "createInstance", "createSecurityManager", "destroy", "", "getBeans", "getSecurityManagerBean", "bos-olap-security"})
public class IniSecurityManagerFactory
extends IniFactorySupport<ISecurityManager> {
    @NotNull
    private final ReflectionBuilder builder = new ReflectionBuilder(null, 1, null);

    @NotNull
    public final Map<String, Object> getBeans() {
        Map<String, Object> map = Collections.unmodifiableMap(this.builder.getObjects());
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        return map;
    }

    public final void destroy() {
        this.builder.destroy();
    }

    private final ISecurityManager getSecurityManagerBean() {
        return this.builder.getBean("securityManager", ISecurityManager.class);
    }

    @Override
    @NotNull
    protected ISecurityManager createDefaultInstance() {
        return new DefaultSecurityManager();
    }

    @Override
    @NotNull
    protected ISecurityManager createInstance(@NotNull Ini ini) {
        Intrinsics.checkNotNullParameter((Object)ini, (String)"ini");
        if (ini.isEmpty()) {
            throw new NullPointerException("Ini argument cannot be null or empty.");
        }
        ISecurityManager securityManager = this.createSecurityManager(ini, ini.tryGetSection("main"));
        if (securityManager == null) {
            String msg = ISecurityManager.class.getName() + " instance cannot be null.";
            throw new ConfigurationException(msg);
        }
        return securityManager;
    }

    private final ISecurityManager createSecurityManager(Ini ini, Ini.Section mainSection) {
        this.builder.setObjects(this.createDefaults(ini, mainSection));
        this.buildInstances(mainSection);
        return this.getSecurityManagerBean();
    }

    private final Map<String, Object> buildInstances(Ini.Section section) {
        return this.builder.buildObjects(section);
    }

    @NotNull
    protected Map<String, Object> createDefaults(@NotNull Ini ini, @Nullable Ini.Section mainSection) {
        Map<String, Object> defaultBeans;
        Intrinsics.checkNotNullParameter((Object)ini, (String)"ini");
        Map defaults = new LinkedHashMap();
        ISecurityManager securityManager = this.createDefaultInstance();
        defaults.put("securityManager", securityManager);
        Map<String, Object> map = defaultBeans = this.getDefaultBeans();
        if (!(map == null || map.isEmpty())) {
            defaults.putAll(defaultBeans);
        }
        return defaults;
    }
}

