/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.filter;

import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.security.filter.AccessControlFilter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J/\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0002J-\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001bH\u0014\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/security/filter/InvalidRequestFilter;", "Lkd/bos/security/filter/AccessControlFilter;", "()V", "backslash", "", "", "isBlockBackslash", "", "()Z", "setBlockBackslash", "(Z)V", "isBlockNonAscii", "setBlockNonAscii", "isBlockSemicolon", "setBlockSemicolon", "semicolon", "containsBackslash", "uri", "containsNonAsciiCharacters", "containsOnlyPrintableAsciiCharacters", "containsSemicolon", "isAccessAllowed", "request", "Ljavax/servlet/ServletRequest;", "response", "Ljavax/servlet/ServletResponse;", "configValue", "", "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;[Ljava/lang/String;)Z", "isValid", "onAccessDenied", "bos-olap-security"})
public final class InvalidRequestFilter
extends AccessControlFilter {
    @NotNull
    private final List<String> semicolon;
    @NotNull
    private final List<String> backslash;
    private boolean isBlockSemicolon;
    private boolean isBlockBackslash;
    private boolean isBlockNonAscii;

    public InvalidRequestFilter() {
        Object[] objectArray = new String[]{";", "%3b", "%3B"};
        this.semicolon = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"\\", "%5c", "%5C"};
        this.backslash = CollectionsKt.listOf((Object[])objectArray);
        this.isBlockSemicolon = true;
        this.isBlockBackslash = true;
        this.isBlockNonAscii = true;
    }

    public final boolean isBlockSemicolon() {
        return this.isBlockSemicolon;
    }

    public final void setBlockSemicolon(boolean bl) {
        this.isBlockSemicolon = bl;
    }

    public final boolean isBlockBackslash() {
        return this.isBlockBackslash;
    }

    public final void setBlockBackslash(boolean bl) {
        this.isBlockBackslash = bl;
    }

    public final boolean isBlockNonAscii() {
        return this.isBlockNonAscii;
    }

    public final void setBlockNonAscii(boolean bl) {
        this.isBlockNonAscii = bl;
    }

    @Override
    public boolean isAccessAllowed(@NotNull ServletRequest request, @Nullable ServletResponse response, @Nullable String[] configValue) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(request instanceof HttpServletRequest)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.isValid(((HttpServletRequest)request).getRequestURI()) && this.isValid(((HttpServletRequest)request).getServletPath()) && this.isValid(((HttpServletRequest)request).getPathInfo());
    }

    private final boolean isValid(String uri) {
        CharSequence charSequence = uri;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !this.containsSemicolon(uri) && !this.containsBackslash(uri) && !this.containsNonAsciiCharacters(uri);
    }

    @Override
    protected boolean onAccessDenied(@NotNull ServletRequest request, @NotNull ServletResponse response, @Nullable String[] configValue) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!(response instanceof HttpServletResponse)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ((HttpServletResponse)response).sendError(400, "Invalid request");
        return false;
    }

    private final boolean containsSemicolon(String uri) {
        return this.isBlockSemicolon ? this.semicolon.stream().anyMatch(arg_0 -> InvalidRequestFilter.containsSemicolon$lambda$0((Function1)new Function1<CharSequence, Boolean>((Object)uri){

            @NotNull
            public final Boolean invoke(@NotNull CharSequence p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return StringsKt.contains$default((CharSequence)((String)this.receiver), (CharSequence)p0, (boolean)false, (int)2, null);
            }
        }, arg_0)) : false;
    }

    private final boolean containsBackslash(String uri) {
        return this.isBlockBackslash ? this.backslash.stream().anyMatch(arg_0 -> InvalidRequestFilter.containsBackslash$lambda$2((Function1)new Function1<CharSequence, Boolean>((Object)uri){

            @NotNull
            public final Boolean invoke(@NotNull CharSequence p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return StringsKt.contains$default((CharSequence)((String)this.receiver), (CharSequence)p0, (boolean)false, (int)2, null);
            }
        }, arg_0)) : false;
    }

    private final boolean containsNonAsciiCharacters(String uri) {
        return this.isBlockNonAscii ? !this.containsOnlyPrintableAsciiCharacters(uri) : false;
    }

    private final boolean containsOnlyPrintableAsciiCharacters(String uri) {
        int length = uri.length();
        for (int i = 0; i < length; ++i) {
            char c = uri.charAt(i);
            if (Intrinsics.compare((int)c, (int)32) >= 0 && Intrinsics.compare((int)c, (int)126) <= 0) continue;
            return false;
        }
        return true;
    }

    private static final boolean containsSemicolon$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean containsBackslash$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

