/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import kd.bos.security.matcher.IPatternMatcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J%\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lkd/bos/security/matcher/AntPathMatcher;", "Lkd/bos/security/matcher/IPatternMatcher;", "()V", "pathSeparator", "", "getPathSeparator", "()Ljava/lang/String;", "setPathSeparator", "(Ljava/lang/String;)V", "match", "", "pattern", "path", "matchStrings", "str", "tokenizeToStringArray", "", "delimiters", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "bos-olap-security"})
@SourceDebugExtension(value={"SMAP\nAntPathMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AntPathMatcher.kt\nkd/bos/security/matcher/AntPathMatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,260:1\n1#2:261\n37#3,2:262\n*S KotlinDebug\n*F\n+ 1 AntPathMatcher.kt\nkd/bos/security/matcher/AntPathMatcher\n*L\n258#1:262,2\n*E\n"})
public final class AntPathMatcher
implements IPatternMatcher {
    @NotNull
    private String pathSeparator = "/";

    @NotNull
    public final String getPathSeparator() {
        return this.pathSeparator;
    }

    public final void setPathSeparator(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pathSeparator = string;
    }

    @Override
    public boolean match(@NotNull String pattern, @Nullable String path) {
        String patDir;
        int pathIdxStart;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        if (path == null || StringsKt.startsWith$default((String)path, (String)this.pathSeparator, (boolean)false, (int)2, null) != StringsKt.startsWith$default((String)pattern, (String)this.pathSeparator, (boolean)false, (int)2, null)) {
            return false;
        }
        String[] pattDirs = this.tokenizeToStringArray(pattern, this.pathSeparator);
        String[] pathDirs = this.tokenizeToStringArray(path, this.pathSeparator);
        int pattIdxStart = 0;
        int pattIdxEnd = pattDirs.length - 1;
        int pathIdxEnd = pathDirs.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !Intrinsics.areEqual((Object)"**", (Object)(patDir = pattDirs[pattIdxStart])); ++pattIdxStart, ++pathIdxStart) {
            if (this.matchStrings(patDir, pathDirs[pathIdxStart])) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return StringsKt.endsWith$default((String)pattern, (String)this.pathSeparator, (boolean)false, (int)2, null) ? StringsKt.endsWith$default((String)path, (String)this.pathSeparator, (boolean)false, (int)2, null) : !StringsKt.endsWith$default((String)path, (String)this.pathSeparator, (boolean)false, (int)2, null);
            }
            if (pattIdxStart == pattIdxEnd && Intrinsics.areEqual((Object)pattDirs[pattIdxStart], (Object)"*") && StringsKt.endsWith$default((String)path, (String)this.pathSeparator, (boolean)false, (int)2, null)) {
                return true;
            }
            int i = pattIdxStart;
            int n = pattIdxEnd;
            if (i <= n) {
                while (true) {
                    if (!Intrinsics.areEqual((Object)pattDirs[i], (Object)"**")) {
                        return false;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !Intrinsics.areEqual((Object)(patDir = pattDirs[pattIdxEnd]), (Object)"**")) {
            if (!this.matchStrings(patDir, pathDirs[pathIdxEnd])) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            int i = pattIdxStart;
            int n = pattIdxEnd;
            if (i <= n) {
                while (true) {
                    if (!Intrinsics.areEqual((Object)pattDirs[i], (Object)"**")) {
                        return false;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            int i = pattIdxStart + 1;
            int n = pattIdxEnd;
            if (i <= n) {
                while (true) {
                    if (Intrinsics.areEqual((Object)pattDirs[i], (Object)"**")) {
                        patIdxTmp = i;
                        break;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            int i2 = 0;
            int n2 = strLength - patLength;
            if (i2 <= n2) {
                while (true) {
                    block28: {
                        for (int j = 0; j < patLength; ++j) {
                            if (this.matchStrings(pattDirs[pattIdxStart + j + 1], pathDirs[pathIdxStart + i2 + j])) {
                                continue;
                            }
                            break block28;
                        }
                        foundIdx = pathIdxStart + i2;
                        break;
                    }
                    if (i2 == n2) break;
                    ++i2;
                }
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        int i = pattIdxStart;
        int n = pattIdxEnd;
        if (i <= n) {
            while (true) {
                if (!Intrinsics.areEqual((Object)pattDirs[i], (Object)"**")) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    private final boolean matchStrings(String pattern, String str) {
        int n;
        int it;
        int i;
        char[] cArray = pattern.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] patArr = cArray;
        char[] cArray2 = str.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
        char[] strArr = cArray2;
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        int ch = 0;
        boolean containsStar = false;
        int n2 = patArr.length;
        for (int j = 0; j < n2; ++j) {
            char aPatArr = patArr[j];
            if (aPatArr != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            n2 = patIdxEnd;
            if (i <= n2) {
                while (true) {
                    if ((ch = patArr[i]) != 63 && ch != strArr[i]) {
                        return false;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while (true) {
            it = i = patArr[patIdxStart];
            boolean bl = false;
            ch = it;
            if (i == 42 || strIdxStart > strIdxEnd) break;
            if (ch != 63 && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            i = patIdxStart;
            it = patIdxEnd;
            if (i <= it) {
                while (true) {
                    if (patArr[i] != '*') {
                        return false;
                    }
                    if (i == it) break;
                    ++i;
                }
            }
            return true;
        }
        while (true) {
            it = i = patArr[patIdxEnd];
            n = 0;
            ch = it;
            if (i == 42 || strIdxStart > strIdxEnd) break;
            if (ch != 63 && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            i = patIdxStart;
            it = patIdxEnd;
            if (i <= it) {
                while (true) {
                    if (patArr[i] != '*') {
                        return false;
                    }
                    if (i == it) break;
                    ++i;
                }
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            int i2 = patIdxStart + 1;
            n = patIdxEnd;
            if (i2 <= n) {
                while (true) {
                    if (patArr[i2] == '*') {
                        patIdxTmp = i2;
                        break;
                    }
                    if (i2 == n) break;
                    ++i2;
                }
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            int i3 = 0;
            int n3 = strLength - patLength;
            if (i3 <= n3) {
                while (true) {
                    block32: {
                        for (int j = 0; j < patLength; ++j) {
                            ch = patArr[patIdxStart + j + 1];
                            if (ch == 63 || ch == strArr[strIdxStart + i3 + j]) {
                                continue;
                            }
                            break block32;
                        }
                        foundIdx = strIdxStart + i3;
                        break;
                    }
                    if (i3 == n3) break;
                    ++i3;
                }
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        i = patIdxStart;
        n2 = patIdxEnd;
        if (i <= n2) {
            while (true) {
                if (patArr[i] != '*') {
                    return false;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return true;
    }

    private final String[] tokenizeToStringArray(String str, String delimiters) {
        StringTokenizer st = new StringTokenizer(str, delimiters);
        List tokens = new ArrayList();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Intrinsics.checkNotNull((Object)token);
            if (!(((CharSequence)token).length() > 0)) continue;
            tokens.add(token);
        }
        Collection $this$toTypedArray$iv = tokens;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }
}

