/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.realm;

import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.security.authc.IAuthenticationInfo;
import kd.bos.security.authc.IAuthenticationToken;
import kd.bos.security.authc.UsernamePasswordToken;
import kd.bos.security.authc.credential.ICredentialsMatcher;
import kd.bos.security.authc.credential.SimpleCredentialsMatcher;
import kd.bos.security.exceptions.IncorrectCredentialsException;
import kd.bos.security.filter.INameable;
import kd.bos.security.realm.IRealm;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lkd/bos/security/realm/AuthenticatingRealm;", "Lkd/bos/security/realm/IRealm;", "Lkd/bos/security/filter/INameable;", "()V", "_name", "", "credentialsMatcher", "Lkd/bos/security/authc/credential/ICredentialsMatcher;", "getCredentialsMatcher", "()Lkd/bos/security/authc/credential/ICredentialsMatcher;", "setCredentialsMatcher", "(Lkd/bos/security/authc/credential/ICredentialsMatcher;)V", "name", "getName", "()Ljava/lang/String;", "assertCredentialsMatch", "", "token", "Lkd/bos/security/authc/IAuthenticationToken;", "info", "Lkd/bos/security/authc/IAuthenticationInfo;", "doGetAuthenticationInfo", "getAuthenticationInfo", "resetName", "newName", "supports", "", "Companion", "bos-olap-security"})
public abstract class AuthenticatingRealm
implements IRealm,
INameable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ICredentialsMatcher credentialsMatcher = new SimpleCredentialsMatcher();
    @NotNull
    private String _name;
    @NotNull
    private final String name = this._name = this.getClass().getName() + '_' + INSTANCE_COUNT.getAndIncrement();
    @NotNull
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();

    @NotNull
    protected final ICredentialsMatcher getCredentialsMatcher() {
        return this.credentialsMatcher;
    }

    protected final void setCredentialsMatcher(@NotNull ICredentialsMatcher iCredentialsMatcher) {
        Intrinsics.checkNotNullParameter((Object)iCredentialsMatcher, (String)"<set-?>");
        this.credentialsMatcher = iCredentialsMatcher;
    }

    @Override
    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public void resetName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        this._name = newName;
    }

    @Override
    @Nullable
    public final IAuthenticationInfo getAuthenticationInfo(@NotNull IAuthenticationToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        IAuthenticationInfo info = this.doGetAuthenticationInfo(token);
        if (info != null) {
            this.assertCredentialsMatch(token, info);
        }
        return info;
    }

    @Nullable
    public abstract IAuthenticationInfo doGetAuthenticationInfo(@NotNull IAuthenticationToken var1);

    private final void assertCredentialsMatch(IAuthenticationToken token, IAuthenticationInfo info) {
        if (!this.credentialsMatcher.doCredentialsMatch(token, info)) {
            throw new IncorrectCredentialsException("Submitted credentials for token [" + token + "] did not match the expected credentials.");
        }
    }

    @Override
    public boolean supports(@NotNull IAuthenticationToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return token instanceof UsernamePasswordToken;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/security/realm/AuthenticatingRealm$Companion;", "", "()V", "INSTANCE_COUNT", "Ljava/util/concurrent/atomic/AtomicInteger;", "bos-olap-security"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

