/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.realm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.security.authz.IAuthorizationInfo;
import kd.bos.security.authz.IAuthorizer;
import kd.bos.security.authz.permission.IPermission;
import kd.bos.security.authz.permission.WildcardPermissionResolver;
import kd.bos.security.realm.AuthenticatingRealm;
import kd.bos.security.realm.IRealm;
import kd.bos.security.subject.principal.IPrincipalCollection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH$J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u0018\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u0017J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkd/bos/security/realm/AuthorizingRealm;", "Lkd/bos/security/realm/AuthenticatingRealm;", "Lkd/bos/security/authz/IAuthorizer;", "()V", "permissionResolver", "Lkd/bos/security/authz/permission/WildcardPermissionResolver;", "getPermissionResolver", "()Lkd/bos/security/authz/permission/WildcardPermissionResolver;", "realms", "", "Lkd/bos/security/realm/IRealm;", "doGetAuthorizationInfo", "Lkd/bos/security/authz/IAuthorizationInfo;", "principals", "Lkd/bos/security/subject/principal/IPrincipalCollection;", "getAuthorizationInfo", "getPermissions", "", "Lkd/bos/security/authz/permission/IPermission;", "info", "hasRole", "", "roleIdentifier", "", "isPermitted", "permission", "resolvePermissions", "", "stringPerms", "bos-olap-security"})
public abstract class AuthorizingRealm
extends AuthenticatingRealm
implements IAuthorizer {
    @NotNull
    private List<IRealm> realms = new ArrayList();
    @NotNull
    private final WildcardPermissionResolver permissionResolver = new WildcardPermissionResolver(false, 1, null);

    @NotNull
    protected final WildcardPermissionResolver getPermissionResolver() {
        return this.permissionResolver;
    }

    @Override
    public final boolean isPermitted(@Nullable IPrincipalCollection principals, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        IPermission p = this.permissionResolver.resolvePermission(permission);
        return this.isPermitted(principals, p);
    }

    private final boolean isPermitted(IPrincipalCollection principals, IPermission permission) {
        IAuthorizationInfo info = this.getAuthorizationInfo(principals);
        return this.isPermitted(permission, info);
    }

    private final boolean isPermitted(IPermission permission, IAuthorizationInfo info) {
        Collection perms = this.getPermissions(info);
        if (!perms.isEmpty()) {
            for (IPermission perm : perms) {
                if (!perm.implies(permission)) continue;
                return true;
            }
        }
        return false;
    }

    private final Set<IPermission> getPermissions(IAuthorizationInfo info) {
        Set set;
        block0: {
            Set $this$getPermissions_u24lambda_u241 = set = (Set)new LinkedHashSet();
            boolean bl = false;
            IAuthorizationInfo iAuthorizationInfo = info;
            if (iAuthorizationInfo == null) break block0;
            IAuthorizationInfo it = iAuthorizationInfo;
            boolean bl2 = false;
            $this$getPermissions_u24lambda_u241.addAll((Collection)it.getObjectPermissions());
            $this$getPermissions_u24lambda_u241.addAll(this.resolvePermissions((Collection<String>)it.getStringPermissions()));
        }
        return set;
    }

    private final Collection<IPermission> resolvePermissions(Collection<String> stringPerms) {
        Set perms = new LinkedHashSet();
        WildcardPermissionResolver resolver = this.permissionResolver;
        if (!stringPerms.isEmpty()) {
            perms = new LinkedHashSet(stringPerms.size());
            for (String strPermission : stringPerms) {
                if (!(!StringsKt.isBlank((CharSequence)strPermission))) continue;
                IPermission permission = resolver.resolvePermission(strPermission);
                perms.add(permission);
            }
        }
        return perms;
    }

    @Override
    public final boolean hasRole(@Nullable IPrincipalCollection principals, @NotNull String roleIdentifier) {
        Intrinsics.checkNotNullParameter((Object)roleIdentifier, (String)"roleIdentifier");
        IAuthorizationInfo info = this.getAuthorizationInfo(principals);
        return info != null && !((Collection)info.getRoles()).isEmpty() && info.getRoles().contains(roleIdentifier);
    }

    private final IAuthorizationInfo getAuthorizationInfo(IPrincipalCollection principals) {
        if (principals == null || principals.isEmpty()) {
            return null;
        }
        return this.doGetAuthorizationInfo(principals);
    }

    @NotNull
    protected abstract IAuthorizationInfo doGetAuthorizationInfo(@NotNull IPrincipalCollection var1);
}

