/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.realm;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.security.authc.SimpleAccount;
import kd.bos.security.authz.SimpleRole;
import kd.bos.security.authz.permission.IPermission;
import kd.bos.security.utils.PermissionUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0004J\u001c\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0004\u00a8\u0006\n"}, d2={"Lkd/bos/security/realm/TextConfigurationRealm;", "LSimpleAccountRealm;", "()V", "processRoleDefinitions", "", "roleDefs", "", "", "processUserDefinitions", "userDefs", "bos-olap-security"})
public class TextConfigurationRealm
extends SimpleAccountRealm {
    protected final void processRoleDefinitions(@NotNull Map<String, String> roleDefs) {
        Intrinsics.checkNotNullParameter(roleDefs, (String)"roleDefs");
        if (roleDefs.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : roleDefs.entrySet()) {
            String roleName = entry.getKey();
            String value = entry.getValue();
            SimpleRole role = this.getRole(roleName);
            if (role == null) {
                role = new SimpleRole(roleName);
                this.add(role);
            }
            role.setPermissions(PermissionUtils.INSTANCE.resolveDelimitedPermissions(value, this.getPermissionResolver()));
        }
    }

    protected final void processUserDefinitions(@NotNull Map<String, String> userDefs) {
        Intrinsics.checkNotNullParameter(userDefs, (String)"userDefs");
        if (userDefs.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : userDefs.entrySet()) {
            String username = entry.getKey();
            String value = entry.getValue();
            String[] stringArray = new String[]{","};
            List passwordAndRolesArray = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String password = (String)passwordAndRolesArray.get(0);
            SimpleAccount account = this.getUser(username);
            if (account == null) {
                account = new SimpleAccount(username, password, this.getName());
                this.add(account);
            }
            account.setCredentials(password);
            if (passwordAndRolesArray.size() > 1) {
                int n = passwordAndRolesArray.size();
                for (int i = 1; i < n; ++i) {
                    String roleName = (String)passwordAndRolesArray.get(i);
                    account.addRole(roleName);
                    SimpleRole role = this.getRole(roleName);
                    if (role == null) continue;
                    account.addObjectPermissions((Collection<? extends IPermission>)role.getPermissions());
                }
                continue;
            }
            account.setRoles(new LinkedHashSet());
        }
    }
}

