/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.subject;

import java.util.Map;
import kd.bos.security.authc.IAuthenticationToken;
import kd.bos.security.mgt.ISecurityManager;
import kd.bos.security.subject.ISubject;
import kd.bos.security.subject.principal.IPrincipalCollection;
import kd.bos.security.subject.principal.IPrincipalCollectionKt;
import kd.bos.security.utils.ThreadContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016R\u001c\u0010\t\u001a\u00020\u00058FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lkd/bos/security/subject/DelegatingSubject;", "Lkd/bos/security/subject/ISubject;", "principals", "Lkd/bos/security/subject/principal/IPrincipalCollection;", "_isAuthenticated", "", "securityManager", "Lkd/bos/security/mgt/ISecurityManager;", "(Lkd/bos/security/subject/principal/IPrincipalCollection;ZLkd/bos/security/mgt/ISecurityManager;)V", "isAuthenticated", "()Z", "setAuthenticated", "(Z)V", "originalResources", "", "", "getPrincipals", "()Lkd/bos/security/subject/principal/IPrincipalCollection;", "setPrincipals", "(Lkd/bos/security/subject/principal/IPrincipalCollection;)V", "getSecurityManager", "()Lkd/bos/security/mgt/ISecurityManager;", "execute", "", "function", "Lkotlin/Function0;", "hasRole", "roleIdentifier", "", "isPermitted", "permission", "login", "authenticationToken", "Lkd/bos/security/authc/IAuthenticationToken;", "logout", "bos-olap-security"})
public class DelegatingSubject
implements ISubject {
    @Nullable
    private IPrincipalCollection principals;
    @NotNull
    private final ISecurityManager securityManager;
    private boolean isAuthenticated;
    @NotNull
    private Map<Object, ? extends Object> originalResources;

    public DelegatingSubject(@Nullable IPrincipalCollection principals, boolean _isAuthenticated, @NotNull ISecurityManager securityManager) {
        Intrinsics.checkNotNullParameter((Object)securityManager, (String)"securityManager");
        this.principals = principals;
        this.securityManager = securityManager;
        this.isAuthenticated = _isAuthenticated;
        this.originalResources = MapsKt.emptyMap();
    }

    @Override
    @Nullable
    public final IPrincipalCollection getPrincipals() {
        return this.principals;
    }

    public final void setPrincipals(@Nullable IPrincipalCollection iPrincipalCollection) {
        this.principals = iPrincipalCollection;
    }

    @NotNull
    public final ISecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public final boolean isAuthenticated() {
        return this.isAuthenticated && !IPrincipalCollectionKt.isNullOrEmpty(this.principals);
    }

    public final void setAuthenticated(boolean bl) {
        this.isAuthenticated = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(@NotNull Function0<Unit> function) {
        boolean bl;
        Intrinsics.checkNotNullParameter(function, (String)"function");
        try {
            this.originalResources = ThreadContext.INSTANCE.getResources();
            ThreadContext.INSTANCE.remove();
            ThreadContext.INSTANCE.bind(this);
            ThreadContext.INSTANCE.bind(this.securityManager);
            function.invoke();
            ThreadContext.INSTANCE.remove();
            if (this.originalResources.isEmpty()) return;
            bl = true;
        }
        catch (Throwable throwable) {
            ThreadContext.INSTANCE.remove();
            if (!(!this.originalResources.isEmpty())) throw throwable;
            ThreadContext.INSTANCE.setResources(this.originalResources);
            throw throwable;
        }
        if (!bl) return;
        ThreadContext.INSTANCE.setResources(this.originalResources);
    }

    @Override
    public boolean isPermitted(@NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return !IPrincipalCollectionKt.isNullOrEmpty(this.principals) && this.securityManager.isPermitted(this.principals, permission);
    }

    @Override
    public boolean hasRole(@NotNull String roleIdentifier) {
        Intrinsics.checkNotNullParameter((Object)roleIdentifier, (String)"roleIdentifier");
        return !IPrincipalCollectionKt.isNullOrEmpty(this.principals) && this.securityManager.hasRole(this.principals, roleIdentifier);
    }

    @Override
    public void login(@NotNull IAuthenticationToken authenticationToken) {
        Intrinsics.checkNotNullParameter((Object)authenticationToken, (String)"authenticationToken");
        ISubject subject = this.securityManager.login(this, authenticationToken);
        if (!subject.isAuthenticated()) {
            throw new IllegalStateException("this subject returned from securityManager.login( token ) is not authenticated");
        }
        this.principals = subject.getPrincipals();
        this.isAuthenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() {
        try {
            this.securityManager.logout(this);
        }
        finally {
            this.principals = null;
            this.isAuthenticated = false;
        }
    }
}

