/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.subject.principal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.security.subject.principal.IPrincipalCollection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0001H\u0016J\u001e\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\u001d\u0010\u001f\u001a\u00020\u00052\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030!H\u0002\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0005H\u0016R\u001c\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR,\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\t0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lkd/bos/security/subject/principal/SimplePrincipalCollection;", "Lkd/bos/security/subject/principal/IPrincipalCollection;", "principal", "", "realmName", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "()V", "realmNames", "", "getRealmNames", "()Ljava/util/Set;", "realmPrincipals", "", "getRealmPrincipals", "()Ljava/util/Map;", "setRealmPrincipals", "(Ljava/util/Map;)V", "add", "", "addAll", "principals", "", "equals", "", "other", "fromRealm", "getPrincipals", "hashCode", "", "isEmpty", "toDelimitedString", "array", "", "([Ljava/lang/Object;)Ljava/lang/String;", "toString", "bos-olap-security"})
@SourceDebugExtension(value={"SMAP\nSimplePrincipalCollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplePrincipalCollection.kt\nkd/bos/security/subject/principal/SimplePrincipalCollection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,118:1\n37#2,2:119\n*S KotlinDebug\n*F\n+ 1 SimplePrincipalCollection.kt\nkd/bos/security/subject/principal/SimplePrincipalCollection\n*L\n85#1:119,2\n*E\n"})
public final class SimplePrincipalCollection
implements IPrincipalCollection {
    @NotNull
    private Map<String, Set<Object>> realmPrincipals;

    public SimplePrincipalCollection() {
        this.realmPrincipals = new LinkedHashMap();
    }

    @NotNull
    public final Map<String, Set<Object>> getRealmPrincipals() {
        return this.realmPrincipals;
    }

    public final void setRealmPrincipals(@NotNull Map<String, Set<Object>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.realmPrincipals = map;
    }

    @Override
    @Nullable
    public Set<String> getRealmNames() {
        return this.realmPrincipals.isEmpty() ? null : this.realmPrincipals.keySet();
    }

    public SimplePrincipalCollection(@NotNull Object principal, @NotNull String realmName) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)realmName, (String)"realmName");
        this();
        if (principal instanceof Collection) {
            this.addAll((Collection)principal, realmName);
        } else {
            this.add(principal, realmName);
        }
    }

    @Override
    public void addAll(@NotNull Collection<? extends Object> principals, @NotNull String realmName) {
        Intrinsics.checkNotNullParameter(principals, (String)"principals");
        Intrinsics.checkNotNullParameter((Object)realmName, (String)"realmName");
        if (principals.isEmpty()) {
            throw new IllegalArgumentException("principals argument cannot be an empty collection.");
        }
        this.getPrincipals(realmName).addAll(principals);
    }

    @Override
    public boolean isEmpty() {
        return this.realmPrincipals.isEmpty();
    }

    @Override
    public void addAll(@NotNull IPrincipalCollection principals) {
        Intrinsics.checkNotNullParameter((Object)principals, (String)"principals");
        Set<String> names = principals.getRealmNames();
        Collection collection = names;
        if (!(collection == null || collection.isEmpty())) {
            for (String realmName : names) {
                for (Object principal : principals.fromRealm(realmName)) {
                    this.add(principal, realmName);
                }
            }
        }
    }

    @Override
    public void add(@NotNull Object principal, @NotNull String realmName) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)realmName, (String)"realmName");
        this.getPrincipals(realmName).add(principal);
    }

    @Override
    @NotNull
    public Collection<Object> fromRealm(@NotNull String realmName) {
        Intrinsics.checkNotNullParameter((Object)realmName, (String)"realmName");
        if (this.realmPrincipals.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set<Object> principals = this.realmPrincipals.get(realmName);
        Collection collection = principals;
        if (collection == null || collection.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set<Object> set = Collections.unmodifiableSet(principals);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        return set;
    }

    private final Set<Object> getPrincipals(String realmName) {
        Set principals = this.realmPrincipals.get(realmName);
        if (principals == null) {
            principals = new LinkedHashSet();
            this.realmPrincipals.put(realmName, principals);
        }
        return principals;
    }

    @NotNull
    public String toString() {
        String string;
        Collection<Set<Object>> principals = this.realmPrincipals.values();
        if (!principals.isEmpty()) {
            Collection<Set<Object>> $this$toTypedArray$iv = principals;
            boolean $i$f$toTypedArray = false;
            Collection<Set<Object>> thisCollection$iv = $this$toTypedArray$iv;
            string = this.toDelimitedString(thisCollection$iv.toArray(new Object[0]));
        } else {
            string = "empty";
        }
        return string;
    }

    private final String toDelimitedString(Object[] array) {
        if (array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            Object any = array[i];
            sb.append(StringsKt.replace$default((String)StringsKt.replace$default((String)String.valueOf(any), (String)"[", (String)"", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SimplePrincipalCollection && Intrinsics.areEqual(((SimplePrincipalCollection)other).realmPrincipals, this.realmPrincipals);
    }

    public int hashCode() {
        return !this.realmPrincipals.isEmpty() ? ((Object)this.realmPrincipals).hashCode() : super.hashCode();
    }

    @Override
    public boolean isNotEmpty() {
        return IPrincipalCollection.DefaultImpls.isNotEmpty(this);
    }
}

