/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.utils;

import java.security.MessageDigest;
import javax.security.auth.login.CredentialException;
import kd.bos.security.subject.ISubject;
import kd.bos.security.utils.ThreadContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lkd/bos/security/utils/SecurityUtils;", "", "()V", "subject", "Lkd/bos/security/subject/ISubject;", "getSubject", "()Lkd/bos/security/subject/ISubject;", "encodeToHexString", "", "data", "", "sha512Hash", "source", "salt", "bos-olap-security"})
public final class SecurityUtils {
    @NotNull
    public static final SecurityUtils INSTANCE = new SecurityUtils();

    private SecurityUtils() {
    }

    @NotNull
    public final ISubject getSubject() {
        ISubject tempSubject = ThreadContext.INSTANCE.getSubject();
        if (tempSubject == null) {
            tempSubject = new ISubject.Builder(null, 1, null).buildSubject();
            ThreadContext.INSTANCE.bind(tempSubject);
        }
        return tempSubject;
    }

    @NotNull
    public final String sha512Hash(@NotNull String source, @NotNull String salt) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        if (StringsKt.isBlank((CharSequence)source)) {
            throw new CredentialException("sha512Hash source is blank");
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-512");
        if (((CharSequence)salt).length() > 0) {
            digest.reset();
            byte[] byArray = salt.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            digest.update(byArray);
        }
        byte[] byArray = source.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = digest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        return this.encodeToHexString(byArray2);
    }

    private final String encodeToHexString(byte[] data) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] digits = cArray;
        int byteSize = data.length;
        char[] chars = new char[byteSize << 1];
        int j = 0;
        for (int i = 0; i < byteSize; ++i) {
            chars[j++] = digits[(0xF0 & data[i]) >>> 4];
            chars[j++] = digits[0xF & data[i]];
        }
        return new String(chars);
    }
}

