/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security.utils;

import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkd/bos/security/utils/WebUtils;", "", "()V", "INCLUDE_PATH_INFO_ATTRIBUTE", "", "INCLUDE_SERVLET_PATH_ATTRIBUTE", "getPathInfo", "request", "Ljavax/servlet/http/HttpServletRequest;", "getPathWithinApplication", "getServletPath", "normalize", "path", "removeSemicolon", "uri", "bos-olap-security"})
public final class WebUtils {
    @NotNull
    public static final WebUtils INSTANCE = new WebUtils();
    @NotNull
    private static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    @NotNull
    private static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";

    private WebUtils() {
    }

    @Nullable
    public final String getPathWithinApplication(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.normalize(this.removeSemicolon(this.getServletPath(request) + this.getPathInfo(request)));
    }

    private final String normalize(String path) {
        int index;
        String normalized = path;
        if (Intrinsics.areEqual((Object)normalized, (Object)"/.")) {
            return "/";
        }
        if (!StringsKt.startsWith$default((String)normalized, (String)"/", (boolean)false, (int)2, null)) {
            normalized = '/' + normalized;
        }
        while ((index = StringsKt.indexOf$default((CharSequence)normalized, (String)"//", (int)0, (boolean)false, (int)6, null)) >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = normalized.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            String string2 = normalized.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            normalized = stringBuilder2.append(string2).toString();
        }
        while ((index = StringsKt.indexOf$default((CharSequence)normalized, (String)"/./", (int)0, (boolean)false, (int)6, null)) >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = normalized.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            StringBuilder stringBuilder3 = stringBuilder.append(string);
            String string3 = normalized.substring(index + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            normalized = stringBuilder3.append(string3).toString();
        }
        while ((index = StringsKt.indexOf$default((CharSequence)normalized, (String)"/../", (int)0, (boolean)false, (int)6, null)) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = StringsKt.lastIndexOf$default((CharSequence)normalized, (char)'/', (int)(index - 1), (boolean)false, (int)4, null);
            StringBuilder stringBuilder = new StringBuilder();
            String string = normalized.substring(0, index2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            StringBuilder stringBuilder4 = stringBuilder.append(string);
            String string4 = normalized.substring(index + 3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            normalized = stringBuilder4.append(string4).toString();
        }
        return normalized;
    }

    private final String removeSemicolon(String uri) {
        String string;
        int semicolonIndex = StringsKt.indexOf$default((CharSequence)uri, (char)';', (int)0, (boolean)false, (int)6, null);
        if (semicolonIndex != -1) {
            String string2 = uri.substring(0, semicolonIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = uri;
        }
        return string;
    }

    private final String getServletPath(HttpServletRequest request) {
        Object object = request.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE);
        String servletPath = object instanceof String ? (String)object : null;
        String string = servletPath;
        if (string == null && (string = request.getServletPath()) == null) {
            string = "";
        }
        return string;
    }

    private final String getPathInfo(HttpServletRequest request) {
        Object object = request.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE);
        String pathInfo = object instanceof String ? (String)object : null;
        String string = pathInfo;
        if (string == null && (string = request.getPathInfo()) == null) {
            string = "";
        }
        return string;
    }
}

