/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.autoProxys;

import java.util.Iterator;
import kd.bos.olap.autoProxys.ComparisonException;
import kd.bos.olap.autoProxys.ComparisonTaskConfig;
import kd.bos.olap.autoProxys.DatabaseComparison;
import kd.bos.olap.autoProxys.HealthReport;
import kd.bos.olap.autoProxys.HealthReportLevel;
import kd.bos.olap.autoProxys.OlapServerHelper;
import kd.bos.olap.autoProxys.ScheduleTask;
import kd.bos.olapServer2.tools.CubeToolKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00060\bj\u0002`\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lkd/bos/olap/autoProxys/ComparisonTask;", "Lkd/bos/olap/autoProxys/ScheduleTask;", "config", "Lkd/bos/olap/autoProxys/ComparisonTaskConfig;", "logger", "Lorg/slf4j/Logger;", "(Lkd/bos/olap/autoProxys/ComparisonTaskConfig;Lorg/slf4j/Logger;)V", "taskName", "", "Lkd/bos/olapServer2/common/string;", "getTaskName", "()Ljava/lang/String;", "executeCore", "", "bos-olap-tools"})
@SourceDebugExtension(value={"SMAP\nComparisonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComparisonTask.kt\nkd/bos/olap/autoProxys/ComparisonTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ScheduleTask.kt\nkd/bos/olap/autoProxys/ScheduleTask\n+ 4 ScheduleTask.kt\nkd/bos/olap/autoProxys/ScheduleTask$dealException$1\n*L\n1#1,74:1\n1855#2:75\n1856#2:85\n47#3,9:76\n46#3,5:86\n51#3,5:92\n46#3,5:97\n51#3,5:103\n46#3,5:108\n51#3,5:114\n46#4:91\n46#4:102\n46#4:113\n*S KotlinDebug\n*F\n+ 1 ComparisonTask.kt\nkd/bos/olap/autoProxys/ComparisonTask\n*L\n31#1:75\n31#1:85\n33#1:76,9\n51#1:86,5\n51#1:92,5\n52#1:97,5\n52#1:103,5\n69#1:108,5\n69#1:114,5\n51#1:91\n52#1:102\n69#1:113\n*E\n"})
public final class ComparisonTask
extends ScheduleTask {
    @NotNull
    private final ComparisonTaskConfig config;
    @NotNull
    private final Logger logger;

    public ComparisonTask(@NotNull ComparisonTaskConfig config, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(config.getComparisonHour(), config.getComparisonMinute(), config.getComparisonSecond(), config.getComparisonTaskInterval(), logger);
        this.config = config;
        this.logger = logger;
    }

    @Override
    @NotNull
    protected String getTaskName() {
        return "ComparisonTask";
    }

    @Override
    protected void executeCore() {
        boolean hasOnePass = false;
        String lastException = null;
        lastException = "";
        OlapServerHelper server1 = new OlapServerHelper(this.config.getComparisonServerIP1());
        OlapServerHelper server2 = new OlapServerHelper(this.config.getComparisonServerIP2());
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.config.getComparisonNumber());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Unit unit;
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            this.selfInfo(this.logger, "Start the " + it + " time data comparison");
            ScheduleTask this_$iv = this;
            boolean $i$f$dealException = false;
            try {
                boolean bl2 = false;
                new DatabaseComparison(server1, server2).compare();
                hasOnePass = true;
                unit = Unit.INSTANCE;
            }
            catch (Exception ex$iv) {
                Exception ex = ex$iv;
                boolean bl3 = false;
                String string = ex.getMessage();
                if (string == null) {
                    string = "No Exception Message.";
                }
                lastException = string;
                if (ex$iv instanceof ComparisonException) {
                    ScheduleTask.access$selfWarn(this_$iv, ScheduleTask.access$getLogger$p(this_$iv), ex$iv.getMessage());
                } else {
                    ScheduleTask.access$selfError(this_$iv, ScheduleTask.access$getLogger$p(this_$iv), ex$iv.getMessage(), ex$iv);
                }
                unit = null;
            }
            if (it == this.config.getComparisonNumber() - 1) continue;
            Thread.sleep((long)this.config.getComparisonInterval() * 1000L);
        }
        if (!hasOnePass) {
            OlapServerHelper masterServer;
            OlapServerHelper olapServerHelper;
            Boolean it;
            boolean $i$f$dealException = false;
            try {
                boolean bl = false;
                it = Intrinsics.areEqual((Object)server1.getReplicationStatus(), (Object)"Master");
            }
            catch (Exception ex$iv) {
                Exception bl = ex$iv;
                boolean bl4 = false;
                Exception it2 = bl;
                if (ex$iv instanceof ComparisonException) {
                    ScheduleTask.access$selfWarn(this, ScheduleTask.access$getLogger$p(this), ex$iv.getMessage());
                } else {
                    ScheduleTask.access$selfError(this, ScheduleTask.access$getLogger$p(this), ex$iv.getMessage(), ex$iv);
                }
                it = null;
            }
            if (Intrinsics.areEqual((Object)it, (Object)true)) {
                olapServerHelper = server1;
            } else {
                $i$f$dealException = false;
                try {
                    boolean bl = false;
                    it = Intrinsics.areEqual((Object)server2.getReplicationStatus(), (Object)"Master");
                }
                catch (Exception ex$iv) {
                    Exception it2 = ex$iv;
                    boolean bl = false;
                    if (ex$iv instanceof ComparisonException) {
                        ScheduleTask.access$selfWarn(this, ScheduleTask.access$getLogger$p(this), ex$iv.getMessage());
                    } else {
                        ScheduleTask.access$selfError(this, ScheduleTask.access$getLogger$p(this), ex$iv.getMessage(), ex$iv);
                    }
                    it = null;
                }
                if (Intrinsics.areEqual((Object)it, (Object)true)) {
                    olapServerHelper = server2;
                } else {
                    this.selfError(this.logger, "Comparison failed! but no server is master");
                    olapServerHelper = masterServer = null;
                }
            }
            if (masterServer != null) {
                String reportId = "AutoProxy-ComparisonFailed-" + CubeToolKt.getCurrentTime();
                HealthReport report = new HealthReport(reportId, null, "AutoProxy-ComparisonFailed: " + lastException, HealthReportLevel.Error, 0);
                this.selfInfo(this.logger, "Comparison failed! Commit a health report To " + masterServer.getServerIP() + ": " + report);
                boolean $i$f$dealException2 = false;
                try {
                    boolean bl = false;
                    masterServer.commitHealthReport(report);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Exception ex$iv) {
                    Exception bl = ex$iv;
                    boolean bl5 = false;
                    Exception it3 = bl;
                    if (ex$iv instanceof ComparisonException) {
                        ScheduleTask.access$selfWarn(this, ScheduleTask.access$getLogger$p(this), ex$iv.getMessage());
                    } else {
                        ScheduleTask.access$selfError(this, ScheduleTask.access$getLogger$p(this), ex$iv.getMessage(), ex$iv);
                    }
                    Object var11_27 = null;
                }
                this.selfInfo(this.logger, "Complete Commit a health report.");
            }
        }
    }
}

