/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.autoProxys;

import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kd.bos.olap.autoProxys.ComparisonTaskConfig;
import kd.bos.olap.autoProxys.ConfigManager;
import kd.bos.olap.autoProxys.SynchronizationTaskConfig;
import kd.bos.olapServer2.common.Paths;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060\u0003j\u0002`\u00042\n\u0010!\u001a\u00060\u0003j\u0002`\u0004J\u0018\u0010\"\u001a\u00060\u0011j\u0002`\u00122\n\u0010 \u001a\u00060\u0003j\u0002`\u0004H\u0002J4\u0010#\u001a.\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\b\u0012\u00060\u0003j\u0002`\u00040\tj\u0016\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\b\u0012\u00060\u0003j\u0002`\u0004`\nH\u0002J,\u0010$\u001a\u00020\u00012\n\u0010 \u001a\u00060\u0003j\u0002`\u00042\u0016\u0010%\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\u0004\u0012\u00020\u00010&H\u0002J\u0018\u0010'\u001a\u00060(j\u0002`)2\n\u0010 \u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0018\u0010*\u001a\u00060+j\u0002`,2\n\u0010 \u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0018\u0010-\u001a\u00060\u0003j\u0002`\u00042\n\u0010 \u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020\u0003H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R>\u0010\b\u001a2\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0018\u00010\tj\u0018\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0012\b\u0012\u00060\u0003j\u0002`\u0004\u0018\u0001`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R-\u0010\u001a\u001a\u001e\u0012\f\u0012\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\f\u0012\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00040\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lkd/bos/olap/autoProxys/ConfigManager;", "", "xmlFilePath", "", "Lkd/bos/olapServer2/common/string;", "(Ljava/lang/String;)V", "_comparisonTaskConfig", "Lkd/bos/olap/autoProxys/ComparisonTaskConfig;", "_confMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "_synchronizationTaskConfig", "Lkd/bos/olap/autoProxys/SynchronizationTaskConfig;", "comparisonTaskConfig", "getComparisonTaskConfig", "()Lkd/bos/olap/autoProxys/ComparisonTaskConfig;", "executeComparisonTask", "", "Lkd/bos/olapServer2/common/bool;", "getExecuteComparisonTask", "()Z", "serverIP1", "serverIP2", "synchronizationTaskConfig", "getSynchronizationTaskConfig", "()Lkd/bos/olap/autoProxys/SynchronizationTaskConfig;", "user", "Lkotlin/Pair;", "getUser", "()Lkotlin/Pair;", "addOrUpdateValue", "", "key", "value", "getBoolConfigValue", "getConfMap", "getConfigValue", "transform", "Lkotlin/Function1;", "getIntConfigValue", "", "Lkd/bos/olapServer2/common/int;", "getLongConfigValue", "", "Lkd/bos/olapServer2/common/long;", "getStringConfigValue", "save", "document", "Lorg/w3c/dom/Document;", "toString", "bos-olap-tools"})
public final class ConfigManager {
    @NotNull
    private final String xmlFilePath;
    @NotNull
    private final String serverIP1;
    @NotNull
    private final String serverIP2;
    @NotNull
    private final Pair<String, String> user;
    private final boolean executeComparisonTask;
    @Nullable
    private ComparisonTaskConfig _comparisonTaskConfig;
    @Nullable
    private SynchronizationTaskConfig _synchronizationTaskConfig;
    @Nullable
    private HashMap<String, String> _confMap;

    public ConfigManager(@NotNull String xmlFilePath) {
        Intrinsics.checkNotNullParameter((Object)xmlFilePath, (String)"xmlFilePath");
        this.xmlFilePath = xmlFilePath;
        this.serverIP1 = this.getStringConfigValue("serverIP1");
        this.serverIP2 = this.getStringConfigValue("serverIP2");
        this.user = new Pair((Object)this.getConfMap().get("username"), (Object)this.getConfMap().get("password"));
        this.executeComparisonTask = this.getBoolConfigValue("executeComparisonTask");
    }

    @NotNull
    public final Pair<String, String> getUser() {
        return this.user;
    }

    public final boolean getExecuteComparisonTask() {
        return this.executeComparisonTask;
    }

    @NotNull
    public final ComparisonTaskConfig getComparisonTaskConfig() {
        ComparisonTaskConfig config = this._comparisonTaskConfig;
        if (config == null) {
            if (this.executeComparisonTask) {
                this._comparisonTaskConfig = config = new ComparisonTaskConfig(this.serverIP1, this.serverIP2, this.getIntConfigValue("comparisonHour"), this.getIntConfigValue("comparisonMinute"), this.getIntConfigValue("comparisonSecond"), this.getLongConfigValue("comparisonTaskInterval"), this.getIntConfigValue("comparisonNumber"), this.getIntConfigValue("comparisonInterval"));
            } else {
                throw new RuntimeException();
            }
        }
        return config;
    }

    @NotNull
    public final SynchronizationTaskConfig getSynchronizationTaskConfig() {
        SynchronizationTaskConfig config = this._synchronizationTaskConfig;
        if (config == null) {
            this._synchronizationTaskConfig = config = new SynchronizationTaskConfig(this.serverIP1, this.serverIP2, -1, 0, 0, 300L);
        }
        return config;
    }

    private final Object getConfigValue(String key, Function1<? super String, ? extends Object> transform) {
        String value = this.getConfMap().get(key);
        if (value == null) {
            throw new RuntimeException(key + " \u672a\u5728\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e");
        }
        try {
            return transform.invoke((Object)value);
        }
        catch (Exception ex) {
            throw new RuntimeException(key + " \u5e94\u914d\u7f6e\u4e3a\u6570\u503c\u7c7b\u578b");
        }
    }

    private final String getStringConfigValue(String key) {
        Object object = this.getConfigValue(key, (Function1<? super String, ? extends Object>)((Function1)getStringConfigValue.1.INSTANCE));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String{ kd.bos.olapServer2.common.CommonTypesKt.string }");
        return (String)object;
    }

    private final boolean getBoolConfigValue(String key) {
        Object object = this.getConfigValue(key, (Function1<? super String, ? extends Object>)((Function1)getBoolConfigValue.1.INSTANCE));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean{ kd.bos.olapServer2.common.CommonTypesKt.bool }");
        return (Boolean)object;
    }

    private final int getIntConfigValue(String key) {
        Object object = this.getConfigValue(key, (Function1<? super String, ? extends Object>)((Function1)getIntConfigValue.1.INSTANCE));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int{ kd.bos.olapServer2.common.CommonTypesKt.int }");
        return (Integer)object;
    }

    private final long getLongConfigValue(String key) {
        Object object = this.getConfigValue(key, (Function1<? super String, ? extends Object>)((Function1)getLongConfigValue.1.INSTANCE));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long{ kd.bos.olapServer2.common.CommonTypesKt.long }");
        return (Long)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HashMap<String, String> getConfMap() {
        HashMap<String, String> confMap = null;
        confMap = this._confMap;
        if (confMap != null) {
            return confMap;
        }
        confMap = new HashMap();
        File xmlFile = Paths.INSTANCE.toFile(this.xmlFilePath);
        if (!xmlFile.exists()) {
            throw new RuntimeException(this.xmlFilePath + " not found!");
        }
        Closeable closeable = Paths.INSTANCE.createInputStream(this.xmlFilePath);
        Throwable throwable = null;
        try {
            FileInputStream input = (FileInputStream)closeable;
            boolean bl = false;
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(input));
            Document doc = parser.getDocument();
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("config");
            int confNum = nodeList.getLength();
            for (int i = 0; i < confNum; ++i) {
                String string;
                String string2;
                Node node = nodeList.item(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element ele = (Element)node;
                if (Intrinsics.areEqual((Object)ele.getAttribute("key"), (Object)"")) continue;
                Map map = confMap;
                Intrinsics.checkNotNullExpressionValue((Object)ele.getAttribute("key"), (String)"getAttribute(...)");
                Intrinsics.checkNotNullExpressionValue((Object)ele.getAttribute("value"), (String)"getAttribute(...)");
                map.put(string2, string);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this._confMap = confMap;
        return confMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addOrUpdateValue(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        File xmlFile = Paths.INSTANCE.toFile(this.xmlFilePath);
        if (!xmlFile.exists()) {
            throw new RuntimeException(this.xmlFilePath + " not found!");
        }
        boolean isExist = false;
        Closeable closeable = Paths.INSTANCE.createInputStream(this.xmlFilePath);
        Throwable throwable = null;
        try {
            FileInputStream input = (FileInputStream)closeable;
            boolean bl = false;
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(input));
            Document doc = parser.getDocument();
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("config");
            int confNum = nodeList.getLength();
            for (int i = 0; i < confNum; ++i) {
                Node node = nodeList.item(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element ele = (Element)node;
                String node2 = ele.getAttribute("key");
                if (Intrinsics.areEqual((Object)node2, (Object)"") || !Intrinsics.areEqual((Object)node2, (Object)key)) continue;
                ele.setAttribute("value", value);
                isExist = true;
                break;
            }
            if (!isExist) {
                Text tabLine = doc.createTextNode("\t");
                root.appendChild(tabLine);
                Element newParam = doc.createElement("config");
                newParam.setAttribute("key", key);
                newParam.setAttribute("value", value);
                root.appendChild(newParam);
                Text newLine = doc.createTextNode("\n");
                root.appendChild(newLine);
            }
            Intrinsics.checkNotNull((Object)doc);
            this.save(doc);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void save(Document document) {
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        Transformer transformer = transformerFactoryImpl.newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(this.xmlFilePath));
    }

    @NotNull
    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("" + '\n' + this.getSynchronizationTaskConfig());
        if (this.executeComparisonTask) {
            strBuilder.append("" + '\n' + this.getComparisonTaskConfig());
        }
        String string = strBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

