/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.autoProxys;

import kd.bos.olap.autoProxys.ComparisonException;
import kd.bos.olap.autoProxys.CubeComparison;
import kd.bos.olap.autoProxys.OlapServerHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\b\u001a\u00060\tj\u0002`\n2\n\u0010\u000b\u001a\u00060\tj\u0002`\n2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkd/bos/olap/autoProxys/DatabaseComparison;", "", "server1", "Lkd/bos/olap/autoProxys/OlapServerHelper;", "server2", "(Lkd/bos/olap/autoProxys/OlapServerHelper;Lkd/bos/olap/autoProxys/OlapServerHelper;)V", "compare", "", "spliceMassage", "", "Lkd/bos/olapServer2/common/string;", "description", "content1", "content2", "bos-olap-tools"})
public final class DatabaseComparison {
    @NotNull
    private final OlapServerHelper server1;
    @NotNull
    private final OlapServerHelper server2;

    public DatabaseComparison(@NotNull OlapServerHelper server1, @NotNull OlapServerHelper server2) {
        Intrinsics.checkNotNullParameter((Object)server1, (String)"server1");
        Intrinsics.checkNotNullParameter((Object)server2, (String)"server2");
        this.server1 = server1;
        this.server2 = server2;
    }

    public final void compare() {
        String[] cubes2;
        String[] cubes1 = this.server1.getCubes();
        if (cubes1.length != (cubes2 = this.server2.getCubes()).length) {
            String message = this.spliceMassage("cubes\u6570\u91cf", cubes1.length, cubes2.length);
            throw new ComparisonException(message);
        }
        CubeComparison cubeComparison = new CubeComparison(this.server1, this.server2);
        int n = cubes1.length;
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)cubes1[i], (Object)cubes2[i])) {
                String message = this.spliceMassage("\u7b2c[" + i + "]\u4e2acube\u540d\u79f0", cubes1[i], cubes2[i]);
                throw new ComparisonException(message);
            }
            cubeComparison.compare(cubes1[i]);
        }
    }

    private final String spliceMassage(String description, Object content1, Object content2) {
        return description + "\u4e0d\u4e00\u81f4\uff0c(" + this.server1.getServerIP() + "):[" + content1 + "] (" + this.server2.getServerIP() + "):[" + content2 + ']';
    }
}

