/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.autoProxys;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kd.bos.olap.autoProxys.ComparisonException;
import kd.bos.olap.autoProxys.OlapAutoProxyMain;
import kd.bos.olap.autoProxys.ScheduleTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b \u0018\u00002\u00020\u0001B=\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJA\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00152\u0018\b\u0002\u0010\u0016\u001a\u0012\u0012\b\u0012\u00060\u0018j\u0002`\u0019\u0012\u0004\u0012\u00020\u001a0\u0017H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001aJ\b\u0010\u001d\u001a\u00020\u001aH$J\u001c\u0010\u001e\u001a\u00020\u001a*\u00020\u000b2\u000e\u0010\u001f\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000fH\u0004J(\u0010\u001e\u001a\u00020\u001a*\u00020\u000b2\u000e\u0010\u001f\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\n\u0010 \u001a\u00060\u0018j\u0002`\u0019H\u0002J\u001c\u0010!\u001a\u00020\u001a*\u00020\u000b2\u000e\u0010\u001f\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000fH\u0004J\u001c\u0010\"\u001a\u00020\u001a*\u00020\u000b2\u000e\u0010\u001f\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000fH\u0004R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006#"}, d2={"Lkd/bos/olap/autoProxys/ScheduleTask;", "", "initialExecutionHour", "", "Lkd/bos/olapServer2/common/int;", "initialExecutionMinute", "initialExecutionSecond", "taskInterval", "", "Lkd/bos/olapServer2/common/long;", "logger", "Lorg/slf4j/Logger;", "(IIIJLorg/slf4j/Logger;)V", "taskName", "", "Lkd/bos/olapServer2/common/string;", "getTaskName", "()Ljava/lang/String;", "dealException", "T", "tryBlock", "Lkotlin/Function0;", "beforeLogException", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "execute", "executeCore", "selfError", "message", "ex", "selfInfo", "selfWarn", "bos-olap-tools"})
public abstract class ScheduleTask {
    private final int initialExecutionHour;
    private final int initialExecutionMinute;
    private final int initialExecutionSecond;
    private final long taskInterval;
    @NotNull
    private final Logger logger;

    public ScheduleTask(int initialExecutionHour, int initialExecutionMinute, int initialExecutionSecond, long taskInterval, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.initialExecutionHour = initialExecutionHour;
        this.initialExecutionMinute = initialExecutionMinute;
        this.initialExecutionSecond = initialExecutionSecond;
        this.taskInterval = taskInterval;
        this.logger = logger;
    }

    @NotNull
    protected abstract String getTaskName();

    public final void execute() {
        long l;
        if (this.initialExecutionHour == -1) {
            l = 1L;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, this.initialExecutionHour);
            calendar.set(12, this.initialExecutionMinute);
            calendar.set(13, this.initialExecutionSecond);
            if (calendar.getTime().compareTo(new Date()) <= 0) {
                calendar.add(5, 1);
            }
            l = (calendar.getTime().getTime() - new Date().getTime()) / (long)1000;
        }
        long initialDelay = l;
        OlapAutoProxyMain.INSTANCE.getExecutorService$bos_olap_tools().scheduleAtFixedRate(this::executeCore, initialDelay, this.taskInterval, TimeUnit.SECONDS);
    }

    protected abstract void executeCore();

    @Nullable
    protected final <T> T dealException(@NotNull Function0<? extends T> tryBlock, @NotNull Function1<? super Exception, Unit> beforeLogException) {
        Object object;
        Intrinsics.checkNotNullParameter(tryBlock, (String)"tryBlock");
        Intrinsics.checkNotNullParameter(beforeLogException, (String)"beforeLogException");
        boolean $i$f$dealException = false;
        try {
            object = tryBlock.invoke();
        }
        catch (Exception ex) {
            beforeLogException.invoke((Object)ex);
            if (ex instanceof ComparisonException) {
                this.selfWarn(this.logger, ex.getMessage());
            } else {
                this.selfError(this.logger, ex.getMessage(), ex);
            }
            object = null;
        }
        return (T)object;
    }

    public static /* synthetic */ Object dealException$default(ScheduleTask $this, Function0 tryBlock, Function1 beforeLogException, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dealException");
        }
        if ((n & 2) != 0) {
            beforeLogException = dealException.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)tryBlock, (String)"tryBlock");
        Intrinsics.checkNotNullParameter((Object)beforeLogException, (String)"beforeLogException");
        boolean $i$f$dealException = false;
        try {
            object = tryBlock.invoke();
        }
        catch (Exception ex) {
            beforeLogException.invoke((Object)ex);
            if (ex instanceof ComparisonException) {
                $this.selfWarn($this.logger, ex.getMessage());
            } else {
                $this.selfError($this.logger, ex.getMessage(), ex);
            }
            object = null;
        }
        return object;
    }

    protected final void selfInfo(@NotNull Logger $this$selfInfo, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)$this$selfInfo, (String)"<this>");
        $this$selfInfo.info("{} - {}", (Object)this.getTaskName(), (Object)message);
    }

    protected final void selfWarn(@NotNull Logger $this$selfWarn, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)$this$selfWarn, (String)"<this>");
        $this$selfWarn.warn(this.getTaskName() + " - " + message);
    }

    protected final void selfError(@NotNull Logger $this$selfError, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)$this$selfError, (String)"<this>");
        $this$selfError.error(this.getTaskName() + " - " + message);
    }

    private final void selfError(Logger $this$selfError, String message, Exception ex) {
        Object[] objectArray = new Object[]{this.getTaskName(), message, ex};
        $this$selfError.error("{} - {}", objectArray);
    }
}

