/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.progressBar;

import kd.bos.olap.progressBar.ProgressPrinter;
import kd.bos.olap.progressBar.ProgressRenderer;
import kd.bos.olap.progressBar.ProgressState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkd/bos/olap/progressBar/ProgressAction;", "Ljava/lang/Runnable;", "progress", "Lkd/bos/olap/progressBar/ProgressState;", "renderer", "Lkd/bos/olap/progressBar/ProgressRenderer;", "printer", "Lkd/bos/olap/progressBar/ProgressPrinter;", "(Lkd/bos/olap/progressBar/ProgressState;Lkd/bos/olap/progressBar/ProgressRenderer;Lkd/bos/olap/progressBar/ProgressPrinter;)V", "last", "", "refresh", "", "run", "bos-olap-tools"})
public final class ProgressAction
implements Runnable {
    @NotNull
    private final ProgressState progress;
    @NotNull
    private final ProgressRenderer renderer;
    @NotNull
    private final ProgressPrinter printer;
    private long last;

    public ProgressAction(@NotNull ProgressState progress, @NotNull ProgressRenderer renderer, @NotNull ProgressPrinter printer) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        this.progress = progress;
        this.renderer = renderer;
        this.printer = printer;
        this.last = this.progress.getStartValue();
    }

    private final void refresh() {
        if (this.progress.getCurrentValue() > this.last) {
            String rendered = this.renderer.render(this.progress);
            this.printer.print(rendered);
            this.last = this.progress.getCurrentValue();
        }
    }

    @Override
    public void run() {
        this.refresh();
        if (!this.progress.getAlive()) {
            this.printer.close();
        }
    }
}

