/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.progressBar;

import java.io.PrintStream;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.olap.progressBar.ProgressAction;
import kd.bos.olap.progressBar.ProgressPrinter;
import kd.bos.olap.progressBar.ProgressRenderer;
import kd.bos.olap.progressBar.ProgressState;
import kd.bos.olap.progressBar.ProgressStyle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\bBM\u0012\n\u0010\t\u001a\u00060\u0003j\u0002`\n\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u000b\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\"\u001a\u00020#H\u0016J\u0006\u0010$\u001a\u00020\u0000J\u0012\u0010%\u001a\u00020#2\n\u0010&\u001a\u00060'j\u0002`(J\u000e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0005J\u000e\u0010)\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0005R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0016\u001a\u00060\u0003j\u0002`\n2\n\u0010\u0015\u001a\u00060\u0003j\u0002`\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lkd/bos/olap/progressBar/ProgressBar;", "Ljava/lang/AutoCloseable;", "task", "", "startValue", "", "Lkd/bos/olapServer2/common/long;", "maxValue", "(Ljava/lang/String;JJ)V", "taskName", "Lkd/bos/olapServer2/common/string;", "updateIntervalMillis", "elapsedBeforeStart", "Ljava/time/Duration;", "renderer", "Lkd/bos/olap/progressBar/ProgressRenderer;", "printer", "Lkd/bos/olap/progressBar/ProgressPrinter;", "(Ljava/lang/String;JJJLjava/time/Duration;Lkd/bos/olap/progressBar/ProgressRenderer;Lkd/bos/olap/progressBar/ProgressPrinter;)V", "action", "Lkd/bos/olap/progressBar/ProgressAction;", "value", "extraMessage", "getExtraMessage", "()Ljava/lang/String;", "setExtraMessage", "(Ljava/lang/String;)V", "progressState", "Lkd/bos/olap/progressBar/ProgressState;", "scheduledTask", "Ljava/util/concurrent/ScheduledFuture;", "scheduledThreadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "threadName", "close", "", "step", "stepBy", "n", "", "Lkd/bos/olapServer2/common/int;", "stepTo", "bos-olap-tools"})
public final class ProgressBar
implements AutoCloseable {
    @NotNull
    private final String threadName;
    @NotNull
    private final ProgressState progressState;
    @NotNull
    private final ProgressAction action;
    @NotNull
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @NotNull
    private final ScheduledFuture<?> scheduledTask;

    public ProgressBar(@NotNull String taskName, long startValue, long maxValue, long updateIntervalMillis, @NotNull Duration elapsedBeforeStart, @NotNull ProgressRenderer renderer, @NotNull ProgressPrinter printer) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)elapsedBeforeStart, (String)"elapsedBeforeStart");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        this.threadName = "ProgressBar";
        this.progressState = new ProgressState(taskName, maxValue, startValue, elapsedBeforeStart);
        this.action = new ProgressAction(this.progressState, renderer, printer);
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, arg_0 -> ProgressBar._init_$lambda$1(this, arg_0));
        ScheduledFuture<?> scheduledFuture = this.scheduledThreadPoolExecutor.scheduleAtFixedRate(this.action, 0L, updateIntervalMillis, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleAtFixedRate(...)");
        this.scheduledTask = scheduledFuture;
    }

    public ProgressBar(@NotNull String task, long startValue, long maxValue) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
        ProgressRenderer progressRenderer = new ProgressRenderer(ProgressStyle.Companion.getCOLORFUL_UNICODE_BLOCK());
        PrintStream printStream = System.err;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"err");
        this(task, startValue, maxValue, 1000L, duration, progressRenderer, new ProgressPrinter(printStream));
    }

    @NotNull
    public final String getExtraMessage() {
        return this.progressState.getExtraMessage();
    }

    public final void setExtraMessage(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.progressState.setExtraMessage(value);
    }

    public final void stepBy(long n) {
        this.progressState.stepBy(n);
    }

    public final void stepBy(int n) {
        this.progressState.stepBy(n);
    }

    public final void stepTo(long n) {
        this.progressState.stepTo(n);
    }

    @NotNull
    public final ProgressBar step() {
        this.progressState.stepBy(1L);
        return this;
    }

    @Override
    public void close() {
        this.scheduledTask.cancel(false);
        this.progressState.close();
        this.scheduledThreadPoolExecutor.schedule(this.action, 0L, TimeUnit.NANOSECONDS).get();
    }

    private static final Thread _init_$lambda$1(ProgressBar this$0, Runnable runnable) {
        Thread thread;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Thread $this$lambda_u241_u24lambda_u240 = thread = Executors.defaultThreadFactory().newThread(runnable);
        boolean bl = false;
        $this$lambda_u241_u24lambda_u240.setName(this$0.threadName);
        $this$lambda_u241_u24lambda_u240.setDaemon(true);
        return thread;
    }
}

