/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.progressBar;

import java.time.Duration;
import java.util.Arrays;
import kd.bos.olap.progressBar.ProgressState;
import kd.bos.olap.progressBar.ProgressStyle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0016\u001a\u00060\bj\u0002`\u00172\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkd/bos/olap/progressBar/ProgressRenderer;", "", "style", "Lkd/bos/olap/progressBar/ProgressStyle;", "(Lkd/bos/olap/progressBar/ProgressStyle;)V", "maxLength", "", "formatDuration", "", "duration", "Ljava/time/Duration;", "getAlreadyRunTime", "progress", "Lkd/bos/olap/progressBar/ProgressState;", "getLength", "s", "getPercentage", "getProgressFractionalPartNum", "middleLength", "getProgressIntegralPartNum", "getRatio", "getRemainTime", "render", "Lkd/bos/olapServer2/common/string;", "repeat", "c", "", "count", "bos-olap-tools"})
@SourceDebugExtension(value={"SMAP\nProgressRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressRenderer.kt\nkd/bos/olap/progressBar/ProgressRenderer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,135:1\n1174#2,2:136\n*S KotlinDebug\n*F\n+ 1 ProgressRenderer.kt\nkd/bos/olap/progressBar/ProgressRenderer\n*L\n95#1:136,2\n*E\n"})
public final class ProgressRenderer {
    @NotNull
    private final ProgressStyle style;
    private final int maxLength;

    public ProgressRenderer(@NotNull ProgressStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.style = style;
        this.maxLength = 100;
    }

    @NotNull
    public final String render(@NotNull ProgressState progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        String prefix = progress.getTaskName() + ' ' + this.getPercentage(progress) + ' ' + this.style.getLeftBracket();
        int prefixLength = this.getLength(prefix);
        String suffix = this.style.getRightBracket() + ' ' + this.getRatio(progress) + " (" + this.getAlreadyRunTime(progress) + " / " + this.getRemainTime(progress) + ") " + progress.getExtraMessage();
        int suffixLength = this.getLength(suffix);
        int middleLength = this.maxLength - prefixLength - suffixLength;
        StringBuilder sb = new StringBuilder(this.maxLength);
        sb.append(prefix);
        sb.append(this.repeat(this.style.getBlock(), this.getProgressIntegralPartNum(progress, middleLength)));
        if (progress.getCurrentValue() < progress.getMaxValue()) {
            int fraction = this.getProgressFractionalPartNum(progress, middleLength);
            if (fraction != 0) {
                sb.append(this.style.getFractionSymbols().charAt(fraction));
                sb.append(this.style.getDelimitingSequence());
            } else {
                sb.append(this.style.getDelimitingSequence());
                sb.append(this.style.getRightSideFractionSymbol());
            }
            sb.append(this.repeat(this.style.getSpace(), middleLength - this.getProgressIntegralPartNum(progress, middleLength) - 1));
        }
        sb.append(suffix);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getAlreadyRunTime(ProgressState progress) {
        return this.formatDuration(progress.getTotalElapsed());
    }

    private final String getRemainTime(ProgressState progress) {
        String string;
        if (progress.getCurrentValue() - progress.getStartValue() == 0L) {
            string = "?";
        } else {
            Duration res = progress.getElapsedAfterStart().dividedBy(progress.getCurrentValue() - progress.getStartValue()).multipliedBy(progress.getMaxValue() - progress.getCurrentValue());
            Intrinsics.checkNotNull((Object)res);
            string = this.formatDuration(res);
        }
        return string;
    }

    private final String getPercentage(ProgressState progress) {
        String res = "" + (int)Math.floor(100.0 * (double)progress.getCurrentValue() / (double)progress.getMaxValue()) + '%';
        return this.repeat(' ', 4 - res.length()) + res;
    }

    private final String getRatio(ProgressState progress) {
        String m = String.valueOf(progress.getMaxValue());
        String c = String.valueOf(progress.getCurrentValue());
        return this.repeat(' ', m.length() - c.length()) + c + '/' + m;
    }

    private final int getLength(String s) {
        int displayWidth = 0;
        boolean canAdd = false;
        canAdd = true;
        CharSequence $this$forEach$iv = s;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            if (c == '\u001b') {
                canAdd = false;
                continue;
            }
            if (c == 'm') {
                canAdd = true;
                continue;
            }
            if (!canAdd) continue;
            ++displayWidth;
        }
        return displayWidth;
    }

    private final int getProgressIntegralPartNum(ProgressState progress, int middleLength) {
        return (int)(progress.getNormalizedProgress() * (double)middleLength);
    }

    private final int getProgressFractionalPartNum(ProgressState progress, int middleLength) {
        double p = progress.getNormalizedProgress() * (double)middleLength;
        double fraction = (p - Math.floor(p)) * (double)this.style.getFractionSymbols().length();
        return (int)Math.floor(fraction);
    }

    private final String repeat(char c, int count) {
        char[] cArray;
        if (count <= 0) {
            return "";
        }
        char[] $this$repeat_u24lambda_u241 = cArray = new char[count];
        boolean bl = false;
        for (int i = 0; i < count; ++i) {
            $this$repeat_u24lambda_u241[i] = c;
        }
        return StringsKt.concatToString((char[])cArray);
    }

    private final String formatDuration(Duration duration) {
        long seconds = duration.getSeconds();
        String string = "%d:%02d:%02d";
        Object[] objectArray = new Object[]{seconds / (long)3600, seconds % (long)3600 / (long)60, seconds % (long)60};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }
}

