/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.progressBar;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010(\u001a\u00020)H\u0016J\u000e\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u0005J\u000e\u0010,\u001a\u00020)2\u0006\u0010+\u001a\u00020\u0005R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001aR\u0011\u0010&\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0017\u00a8\u0006-"}, d2={"Lkd/bos/olap/progressBar/ProgressState;", "Ljava/lang/AutoCloseable;", "taskName", "", "maxValue", "", "startValue", "elapsedBeforeStart", "Ljava/time/Duration;", "(Ljava/lang/String;JJLjava/time/Duration;)V", "alive", "", "getAlive", "()Z", "setAlive", "(Z)V", "currentValue", "getCurrentValue", "()J", "setCurrentValue", "(J)V", "elapsedAfterStart", "getElapsedAfterStart", "()Ljava/time/Duration;", "extraMessage", "getExtraMessage", "()Ljava/lang/String;", "setExtraMessage", "(Ljava/lang/String;)V", "getMaxValue", "normalizedProgress", "", "getNormalizedProgress", "()D", "startInstant", "Ljava/time/Instant;", "getStartValue", "getTaskName", "totalElapsed", "getTotalElapsed", "close", "", "stepBy", "n", "stepTo", "bos-olap-tools"})
public final class ProgressState
implements AutoCloseable {
    @NotNull
    private final String taskName;
    private final long maxValue;
    private final long startValue;
    @NotNull
    private final Duration elapsedBeforeStart;
    @NotNull
    private String extraMessage;
    private long currentValue;
    @NotNull
    private final Instant startInstant;
    private boolean alive;

    public ProgressState(@NotNull String taskName, long maxValue, long startValue, @NotNull Duration elapsedBeforeStart) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)elapsedBeforeStart, (String)"elapsedBeforeStart");
        this.taskName = taskName;
        this.maxValue = maxValue;
        this.startValue = startValue;
        this.elapsedBeforeStart = elapsedBeforeStart;
        this.extraMessage = "";
        this.alive = true;
        if (!(this.maxValue > 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentValue = this.startValue;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.startInstant = instant;
    }

    @NotNull
    public final String getTaskName() {
        return this.taskName;
    }

    public final long getMaxValue() {
        return this.maxValue;
    }

    public final long getStartValue() {
        return this.startValue;
    }

    @NotNull
    public final String getExtraMessage() {
        return this.extraMessage;
    }

    public final void setExtraMessage(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.extraMessage = string;
    }

    public final long getCurrentValue() {
        return this.currentValue;
    }

    public final void setCurrentValue(long l) {
        this.currentValue = l;
    }

    public final boolean getAlive() {
        return this.alive;
    }

    public final void setAlive(boolean bl) {
        this.alive = bl;
    }

    @NotNull
    public final Duration getElapsedAfterStart() {
        Duration duration = Duration.between(this.startInstant, Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        return duration;
    }

    @NotNull
    public final Duration getTotalElapsed() {
        Duration duration = this.elapsedBeforeStart.plus(this.getElapsedAfterStart());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"plus(...)");
        return duration;
    }

    public final double getNormalizedProgress() {
        return this.maxValue <= 0L ? 0.0 : (this.currentValue > this.maxValue ? 1.0 : (double)this.currentValue / (double)this.maxValue);
    }

    public final void stepBy(long n) {
        this.currentValue += n;
        if (!(this.currentValue <= this.maxValue)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void stepTo(long n) {
        if (!(n <= this.maxValue)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.currentValue = n;
    }

    @Override
    public void close() {
        this.alive = false;
    }
}

