/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.repairTools;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import kd.bos.olap.repairTools.JsonHelper;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.dataSources.BackupCommandInfo;
import kd.bos.olapServer2.dataSources.CommandInfo;
import kd.bos.olapServer2.dataSources.ComputingCommandInfo;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.dataSources.RecoveryCommandInfo;
import kd.bos.olapServer2.dataSources.SaveCommandInfo;
import kd.bos.olapServer2.replication.ReplicationContext;
import kd.bos.olapServer2.server.OlapServer;
import kd.bos.olapServer2.server.OlapSession;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J6\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\f\b\u0002\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\f\b\u0002\u0010\u001a\u001a\u00060\u0018j\u0002`\u00192\n\u0010\u001b\u001a\u00060\u0018j\u0002`\u0019J\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060\u0003j\u0002`\u0004H\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020!H\u0002R\u0012\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkd/bos/olap/repairTools/CubeRebuild;", "Ljava/io/Closeable;", "olapPath", "", "Lkd/bos/olapServer2/common/string;", "cubeName", "(Ljava/lang/String;Ljava/lang/String;)V", "emptyContext", "Lkd/bos/olapServer2/replication/ReplicationContext;", "olapServer", "Lkd/bos/olapServer2/server/OlapServer;", "session", "Lkd/bos/olapServer2/server/OlapSession;", "backup", "", "backupFile", "Ljava/io/File;", "close", "compute", "cmd", "Lkd/bos/olapServer2/dataSources/ComputingCommandInfo;", "rebuildCubeByLog", "logFile", "fromLine", "", "Lkd/bos/olapServer2/common/int;", "toLine", "printCount", "recovery", "saveData", "Lkd/bos/olapServer2/dataSources/SaveCommandInfo;", "values", "updateMetaData", "Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;", "bos-olap-tools"})
public final class CubeRebuild
implements Closeable {
    @NotNull
    private final String cubeName;
    @NotNull
    private final ReplicationContext emptyContext;
    @NotNull
    private OlapServer olapServer;
    @NotNull
    private final OlapSession session;

    public CubeRebuild(@NotNull String olapPath, @NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)olapPath, (String)"olapPath");
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this.cubeName = cubeName;
        this.emptyContext = new ReplicationContext(0, "", null, false, 12, null);
        this.olapServer = new OlapServer(olapPath, false, 0L, this.emptyContext, 6, null);
        this.session = new OlapSession(this.cubeName, null, null, 6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recovery(@NotNull File backupFile) {
        Intrinsics.checkNotNullParameter((Object)backupFile, (String)"backupFile");
        String txtRecovery = "{\"type\":\"recovery.v1\",\"cubeName\":\"" + this.cubeName + "\",\"source\":{\"type\":\"direct.v1\"}}";
        RecoveryCommandInfo cmdRecovery = (RecoveryCommandInfo)JsonHelper.INSTANCE.getMapper().readValue(txtRecovery, RecoveryCommandInfo.class);
        Closeable closeable = Paths.INSTANCE.createInputStream(backupFile);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)cmdRecovery);
            OlapServer.recovery$default((OlapServer)this.olapServer, (RecoveryCommandInfo)cmdRecovery, (OlapSession)this.session, (InputStream)it, null, (int)8, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void backup(@NotNull File backupFile) {
        Intrinsics.checkNotNullParameter((Object)backupFile, (String)"backupFile");
        String txtBackup = "{\"type\":\"backup.v1\",\"target\":{\"type\":\"direct.v1\"}}";
        BackupCommandInfo cmdBackup = (BackupCommandInfo)JsonHelper.INSTANCE.getMapper().readValue(txtBackup, BackupCommandInfo.class);
        Closeable closeable = Paths.INSTANCE.createOutputStream(backupFile);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)cmdBackup);
            long l = this.olapServer.backup(cmdBackup, this.session, (OutputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void compute(ComputingCommandInfo cmd) {
        this.olapServer.computing(cmd, this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveData(SaveCommandInfo cmd, String values) {
        Closeable closeable = new StringReader(values);
        Throwable throwable = null;
        try {
            StringReader it = (StringReader)closeable;
            boolean bl = false;
            this.olapServer.write(cmd, new BufferedReader(it), this.session);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void updateMetaData(MetadataCommandInfo cmd) {
        this.olapServer.updateMetadata(cmd, this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rebuildCubeByLog(@NotNull File logFile, int fromLine, int toLine, int printCount) {
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        String fileName = logFile.getName();
        System.out.println((Object)("\u6587\u4ef6 " + fileName + " \u5f00\u59cb\u6267\u884c"));
        Closeable closeable = Paths.INSTANCE.createInputStream(logFile);
        Object object = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        object = null;
        try {
            int lineNum;
            BufferedReader reader2 = (BufferedReader)closeable;
            boolean bl = false;
            if (fromLine > 0) {
                int n2 = fromLine - 1;
                int n3 = 0;
                while (n3 < n2) {
                    int it = n3++;
                    boolean bl2 = false;
                    if (reader2.readLine() != null) continue;
                    System.out.println((Object)("\u6587\u4ef6 " + fileName + " \u6ca1\u6709\u7b2c " + fromLine + " \u884c!"));
                    return;
                }
            }
            CommandInfo command = null;
            String line = reader2.readLine();
            int n4 = lineNum = fromLine == -1 ? 1 : fromLine;
            while (line != null) {
                block18: {
                    if (lineNum % printCount == 0) {
                        System.out.println((Object)("\u6587\u4ef6 " + fileName + " \u5df2\u6267\u884c\u5230 " + lineNum + " \u884c"));
                    }
                    try {
                        Object object2 = JsonHelper.INSTANCE.getMapper().readValue(line, CommandInfo.class);
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"readValue(...)");
                        CommandInfo commandInfo = command = (CommandInfo)object2;
                        if (commandInfo instanceof MetadataCommandInfo) {
                            this.updateMetaData((MetadataCommandInfo)command);
                            break block18;
                        }
                        if (commandInfo instanceof ComputingCommandInfo) {
                            this.compute((ComputingCommandInfo)command);
                            break block18;
                        }
                        if (commandInfo instanceof SaveCommandInfo) {
                            StringBuilder dataValues = new StringBuilder();
                            String writerData = reader2.readLine();
                            ++lineNum;
                            while (writerData != null && ((CharSequence)writerData).length() > 0) {
                                if (lineNum % printCount == 0) {
                                    System.out.println((Object)("\u6587\u4ef6 " + fileName + " \u5df2\u6267\u884c\u5230 " + lineNum + " \u884c"));
                                }
                                StringBuilder stringBuilder = dataValues.append(writerData);
                                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                                StringsKt.appendln((StringBuilder)stringBuilder);
                                writerData = reader2.readLine();
                                ++lineNum;
                            }
                            SaveCommandInfo saveCommandInfo = (SaveCommandInfo)command;
                            String string = dataValues.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                            this.saveData(saveCommandInfo, string);
                            break block18;
                        }
                        throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684\u8bed\u53e5 : " + line);
                    }
                    catch (Exception ex) {
                        System.out.println((Object)("\u6267\u884c\u9519\u8bef\u7684\u547d\u4ee4: " + fileName + " - " + lineNum + " - " + line));
                        System.out.println((Object)ex.getMessage());
                    }
                }
                if (toLine != -1 && ++lineNum >= toLine) break;
                line = reader2.readLine();
            }
            if (line == null) {
                --lineNum;
            }
            System.out.println((Object)("\u6587\u4ef6 " + fileName + " \u5df2\u5b8c\u6210\u6267\u884c " + (fromLine == -1 ? 1 : fromLine) + " - " + (toLine == -1 ? lineNum : toLine) + " \u884c"));
            reader = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    public static /* synthetic */ void rebuildCubeByLog$default(CubeRebuild cubeRebuild, File file, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = -1;
        }
        if ((n4 & 4) != 0) {
            n2 = -1;
        }
        cubeRebuild.rebuildCubeByLog(file, n, n2, n3);
    }

    @Override
    public void close() {
        this.olapServer.close();
    }
}

