/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.repairTools;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import kd.bos.olap.repairTools.FileTools;
import kd.bos.olapServer2.common.Paths;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0012\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\u0004\u0012\u00020\u00070\u00042\n\u0010\b\u001a\u00060\u0005j\u0002`\u0006J\u001e\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\n2\n\u0010\f\u001a\u00060\u0005j\u0002`\u0006J&\u0010\r\u001a\u0016\u0012\b\u0012\u00060\u000bj\u0002`\u000e\u0012\b\u0012\u00060\u000bj\u0002`\u000e0\u00042\n\u0010\u000f\u001a\u00060\u0005j\u0002`\u0006J&\u0010\u0010\u001a\u0016\u0012\b\u0012\u00060\u000bj\u0002`\u000e\u0012\b\u0012\u00060\u000bj\u0002`\u000e0\u00112\n\u0010\u0012\u001a\u00060\u0005j\u0002`\u0006\u00a8\u0006\u0013"}, d2={"Lkd/bos/olap/repairTools/IndicatorTools;", "", "()V", "getAllCubeSize", "", "", "Lkd/bos/olapServer2/common/string;", "", "databasePath", "getBackupSizeMap", "Ljava/util/SortedMap;", "", "backupFolderPath", "getCommandsNumMap", "Lkd/bos/olapServer2/common/int;", "databaseFolderPath", "getRedoNumMap", "", "redoFolderPath", "bos-olap-tools"})
public final class IndicatorTools {
    @NotNull
    public static final IndicatorTools INSTANCE = new IndicatorTools();

    private IndicatorTools() {
    }

    @NotNull
    public final Map<Integer, Integer> getRedoNumMap(@NotNull String redoFolderPath) {
        Intrinsics.checkNotNullParameter((Object)redoFolderPath, (String)"redoFolderPath");
        Map result = new LinkedHashMap();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        File[] fileArray = Paths.INSTANCE.toFile(redoFolderPath).listFiles();
        Intrinsics.checkNotNull((Object)fileArray);
        for (File redoFile : fileArray) {
            Integer n;
            if (!redoFile.isFile()) continue;
            String string = redoFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".redo", (boolean)false, (int)2, null)) continue;
            String string2 = dateFormat.format(redoFile.lastModified());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            int dateStr = Integer.parseInt(string2);
            if (result.containsKey(dateStr)) {
                n = dateStr;
                Object v = result.get(dateStr);
                Intrinsics.checkNotNull(v);
                result.put(n, ((Number)v).intValue() + 1);
                continue;
            }
            n = dateStr;
            result.put(n, 1);
        }
        return MapsKt.toSortedMap((Map)result);
    }

    @NotNull
    public final SortedMap<Integer, Long> getBackupSizeMap(@NotNull String backupFolderPath) {
        Intrinsics.checkNotNullParameter((Object)backupFolderPath, (String)"backupFolderPath");
        Map result = new LinkedHashMap();
        File[] fileArray = Paths.INSTANCE.toFile(backupFolderPath).listFiles();
        Intrinsics.checkNotNull((Object)fileArray);
        for (File folder : fileArray) {
            Integer n;
            if (!folder.isDirectory()) continue;
            String string = folder.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)"total", (boolean)false, (int)2, null)) {
                String string2 = folder.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string2, (String)"increment", (boolean)false, (int)2, null)) continue;
            }
            String folderName = folder.getName();
            Intrinsics.checkNotNull((Object)folderName);
            String string3 = folderName.substring(0, 8);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            int dateStr = Integer.parseInt(string3);
            String string4 = folder.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
            long totalSize = FileTools.INSTANCE.getSize(string4);
            if (result.containsKey(dateStr)) {
                n = dateStr;
                Object v = result.get(dateStr);
                Intrinsics.checkNotNull(v);
                result.put(n, ((Number)v).longValue() + totalSize);
                continue;
            }
            n = dateStr;
            Long l = totalSize;
            result.put(n, l);
        }
        return MapsKt.toSortedMap((Map)result);
    }

    @NotNull
    public final Map<Integer, Integer> getCommandsNumMap(@NotNull String databaseFolderPath) {
        Intrinsics.checkNotNullParameter((Object)databaseFolderPath, (String)"databaseFolderPath");
        Map result = new LinkedHashMap();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        File[] fileArray = Paths.INSTANCE.toFile(databaseFolderPath).listFiles();
        Intrinsics.checkNotNull((Object)fileArray);
        for (File folder : fileArray) {
            File[] fileArray2;
            if (!folder.isDirectory()) continue;
            Intrinsics.checkNotNull((Object)folder.listFiles());
            for (File file : fileArray2) {
                Integer n;
                String fileName = file.getName();
                Intrinsics.checkNotNull((Object)fileName);
                if (!StringsKt.startsWith$default((String)fileName, (String)"commands_", (boolean)false, (int)2, null)) continue;
                int f1 = StringsKt.indexOf$default((CharSequence)fileName, (String)"_", (int)0, (boolean)false, (int)6, null);
                int f2 = StringsKt.lastIndexOf$default((CharSequence)fileName, (String)"_", (int)0, (boolean)false, (int)6, null);
                int f3 = StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".", (int)0, (boolean)false, (int)6, null);
                String string = fileName.substring(f1 + 1, f2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Integer n1 = Integer.valueOf(string);
                String string2 = fileName.substring(f2 + 1, f3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Integer n2 = Integer.valueOf(string2);
                int n3 = n1;
                Intrinsics.checkNotNull((Object)n2);
                int num = Math.abs(n3 - n2);
                String string3 = dateFormat.format(file.lastModified());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                int dateStr = Integer.parseInt(string3);
                if (result.containsKey(dateStr)) {
                    n = dateStr;
                    Object v = result.get(dateStr);
                    Intrinsics.checkNotNull(v);
                    result.put(n, ((Number)v).intValue() + num);
                    continue;
                }
                n = dateStr;
                Integer n4 = num;
                result.put(n, n4);
            }
        }
        return MapsKt.toSortedMap((Map)result);
    }

    @NotNull
    public final Map<String, Long> getAllCubeSize(@NotNull String databasePath) {
        Intrinsics.checkNotNullParameter((Object)databasePath, (String)"databasePath");
        Map result = new LinkedHashMap();
        File[] fileArray = Paths.INSTANCE.toFile(databasePath).listFiles();
        Intrinsics.checkNotNull((Object)fileArray);
        for (File folder : fileArray) {
            String string;
            if (!folder.isDirectory()) continue;
            Map map = result;
            Intrinsics.checkNotNullExpressionValue((Object)folder.getName(), (String)"getName(...)");
            String string2 = folder.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            Long l = FileTools.INSTANCE.getSize(string2);
            map.put(string, l);
        }
        return result;
    }
}

