/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.log;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.nio.file.Path;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.replication.TimeUtil;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePlugin;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePluginContext;
import kd.bos.olapServer2.storages.plugins.OlapWorkspaceBasicPlugin;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u0019\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001e\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015R\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkd/bos/olap/log/OlapRollbackLogPlugin;", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspaceBasicPlugin;", "Lkd/bos/olap/log/OlapRollbackLogPlugin$CubeRollbackLogPlugin;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "pluginContext", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "(Ljava/lang/String;Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;)V", "cubePluginKey", "", "getCubePluginKey", "()Ljava/lang/Object;", "createCubePlugin", "context", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "write", "", "cubeName", "rollbackID", "", "Lkd/bos/olapServer2/common/long;", "Companion", "CubeRollbackLogPlugin", "bos-olap-webserver"})
public final class OlapRollbackLogPlugin
extends OlapWorkspaceBasicPlugin<CubeRollbackLogPlugin> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootPath;
    @NotNull
    private static final Class<OlapRollbackLogPlugin> pluginKey = OlapRollbackLogPlugin.class;
    @NotNull
    public static final String rollbackLogName = "rollback.log";

    public OlapRollbackLogPlugin(@NotNull String rootPath, @NotNull OlapWorkspacePluginContext pluginContext) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        super(pluginContext, true);
        this.rootPath = rootPath;
    }

    @NotNull
    protected Object getCubePluginKey() {
        return pluginKey;
    }

    @NotNull
    protected CubeRollbackLogPlugin createCubePlugin(@NotNull CubeWorkspacePluginContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String[] stringArray = new String[]{context.getCubeName()};
        Path cubePath = Paths.INSTANCE.get(this.rootPath, stringArray);
        if (!cubePath.toFile().exists()) {
            throw Res.INSTANCE.getIOException("\u56de\u6eda\u65e5\u5fd7\u76ee\u5f55\u4e0d\u5b58\u5728", new Object[0]);
        }
        stringArray = new String[]{rollbackLogName};
        return new CubeRollbackLogPlugin(context, ((Object)Paths.INSTANCE.get(((Object)cubePath).toString(), stringArray)).toString());
    }

    public final void write(@NotNull String cubeName, long rollbackID) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
            if (rollbackID <= 0L) break block1;
            CubeRollbackLogPlugin cubeRollbackLogPlugin = (CubeRollbackLogPlugin)this.getOrCreateCubePlugin(cubeName);
            if (cubeRollbackLogPlugin != null) {
                cubeRollbackLogPlugin.write(rollbackID);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkd/bos/olap/log/OlapRollbackLogPlugin$Companion;", "", "()V", "pluginKey", "Ljava/lang/Class;", "Lkd/bos/olap/log/OlapRollbackLogPlugin;", "rollbackLogName", "", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00112\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkd/bos/olap/log/OlapRollbackLogPlugin$CubeRollbackLogPlugin;", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePlugin;", "Ljava/io/Closeable;", "pluginContext", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "logPath", "", "Lkd/bos/olapServer2/common/string;", "(Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;Ljava/lang/String;)V", "key", "", "getKey", "()Ljava/lang/Object;", "output", "Lkotlin/Lazy;", "Ljava/io/FileOutputStream;", "close", "", "write", "rollbackID", "", "Lkd/bos/olapServer2/common/long;", "bos-olap-webserver"})
    public static final class CubeRollbackLogPlugin
    extends CubeWorkspacePlugin
    implements Closeable {
        @NotNull
        private final String logPath;
        @NotNull
        private final Lazy<FileOutputStream> output;

        public CubeRollbackLogPlugin(@NotNull CubeWorkspacePluginContext pluginContext, @NotNull String logPath) {
            Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
            Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
            super(pluginContext);
            this.logPath = logPath;
            this.output = LazyKt.lazy((Function0)((Function0)new Function0<FileOutputStream>(this){
                final /* synthetic */ CubeRollbackLogPlugin this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final FileOutputStream invoke() {
                    return new FileOutputStream(Paths.INSTANCE.toFile(CubeRollbackLogPlugin.access$getLogPath$p(this.this$0)), true);
                }
            }));
        }

        @NotNull
        public Object getKey() {
            return pluginKey;
        }

        public final synchronized void write(long rollbackID) {
            FileOutputStream fileOutputStream = (FileOutputStream)this.output.getValue();
            String string = "" + rollbackID + '#' + TimeUtil.Companion.toDateString(System.currentTimeMillis(), TimeUtil.Companion.getTimeSdf()) + '\n';
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            fileOutputStream.write(byArray);
        }

        @Override
        public void close() {
            if (this.output.isInitialized()) {
                ((FileOutputStream)this.output.getValue()).close();
            }
        }

        public static final /* synthetic */ String access$getLogPath$p(CubeRollbackLogPlugin $this) {
            return $this.logPath;
        }
    }
}

