/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.log;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.olap.log.CommandLogRecordEntity;
import kd.bos.olap.log.ConcatMeFunctionExecutor;
import kd.bos.olap.log.CubeTransactionLogPlugin;
import kd.bos.olap.log.ITransactionLogReader;
import kd.bos.olap.log.SeqLogElem;
import kd.bos.olap.log.TransactionCommandFunctionExecutor;
import kd.bos.olap.log.TransactionLogReader;
import kd.bos.olap.log.TransactionTraceFunctionExecutor;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.backup.sequenceLog.AbstractSeqLogger;
import kd.bos.olapServer2.backup.sequenceLog.BigStreamCache;
import kd.bos.olapServer2.backup.sequenceLog.CommandLogRecord;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogNameStrategy;
import kd.bos.olapServer2.backup.sequenceLog.SeqLogger;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.dataSources.CommandInfo;
import kd.bos.olapServer2.function.PluginFunctionExecutor;
import kd.bos.olapServer2.server.OlapServer;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePluginContext;
import kd.bos.olapServer2.storages.plugins.OlapMessagePlugin;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 12\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00011B-\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J3\u0010\u001e\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u001f2\n\u0010 \u001a\u00060\u0005j\u0002`\u00062\u0010\u0010!\u001a\f\u0012\b\u0012\u00060\"j\u0002`#0\u001f\u00a2\u0006\u0002\u0010$J5\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\n\u0010 \u001a\u00060\u0005j\u0002`\u00062\u0010\u0010!\u001a\f\u0012\b\u0012\u00060\"j\u0002`#0\u001fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J1\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0\u001f2\n\u0010 \u001a\u00060\u0005j\u0002`\u00062\u0010\u0010!\u001a\f\u0012\b\u0012\u00060\"j\u0002`#0\u001f\u00a2\u0006\u0002\u0010+J;\u0010,\u001a\u00020\u001b2\n\u0010 \u001a\u00060\u0005j\u0002`\u00062\n\u0010-\u001a\u00060\"j\u0002`#2\u000e\u0010.\u001a\n\u0018\u00010\"j\u0004\u0018\u0001`#2\u0006\u0010/\u001a\u00020\u000e\u00a2\u0006\u0002\u00100R\u0012\u0010\u0007\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00062"}, d2={"Lkd/bos/olap/log/OlapTransactionLogPlugin;", "Lkd/bos/olapServer2/storages/plugins/OlapMessagePlugin;", "Lkd/bos/olap/log/SeqLogElem;", "Lkd/bos/olap/log/CubeTransactionLogPlugin;", "rootPath", "", "Lkd/bos/olapServer2/common/string;", "archiveDir", "pluginContext", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "olapServer", "Lkd/bos/olapServer2/server/OlapServer;", "(Ljava/lang/String;Ljava/lang/String;Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;Lkd/bos/olapServer2/server/OlapServer;)V", "cubePluginKey", "", "getCubePluginKey", "()Ljava/lang/Object;", "key", "Ljava/lang/Class;", "getKey", "()Ljava/lang/Class;", "strategy", "Lkd/bos/olapServer2/backup/sequenceLog/SeqLogNameStrategy;", "createCubePlugin", "context", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "onError", "", "ex", "", "readCommand", "", "cubeName", "commandIds", "", "Lkd/bos/olapServer2/common/long;", "(Ljava/lang/String;[Ljava/lang/Long;)[Ljava/lang/String;", "readRecordFlow", "Lkotlinx/coroutines/flow/Flow;", "Lkd/bos/olapServer2/backup/sequenceLog/CommandLogRecord;", "(Ljava/lang/String;[Ljava/lang/Long;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readRecords", "Lkd/bos/olap/log/CommandLogRecordEntity;", "(Ljava/lang/String;[Ljava/lang/Long;)[Lkd/bos/olap/log/CommandLogRecordEntity;", "write", "id", "traceId", "command", "(Ljava/lang/String;JLjava/lang/Long;Ljava/lang/Object;)V", "Companion", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nOlapTransactionLogPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OlapTransactionLogPlugin.kt\nkd/bos/olap/log/OlapTransactionLogPlugin\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,178:1\n11065#2:179\n11400#2,2:180\n11402#2:184\n11065#2:187\n11400#2,2:188\n11402#2:192\n288#3,2:182\n288#3,2:190\n37#4,2:185\n37#4,2:193\n*S KotlinDebug\n*F\n+ 1 OlapTransactionLogPlugin.kt\nkd/bos/olap/log/OlapTransactionLogPlugin\n*L\n92#1:179\n92#1:180,2\n92#1:184\n122#1:187\n122#1:188,2\n122#1:192\n93#1:182,2\n123#1:190,2\n94#1:185,2\n124#1:193,2\n*E\n"})
public final class OlapTransactionLogPlugin
extends OlapMessagePlugin<SeqLogElem, CubeTransactionLogPlugin> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootPath;
    @NotNull
    private final String archiveDir;
    @NotNull
    private final Class<OlapTransactionLogPlugin> key;
    @NotNull
    private final SeqLogNameStrategy strategy;
    @NotNull
    private static final Class<OlapTransactionLogPlugin> pluginKey = OlapTransactionLogPlugin.class;
    private static final Logger log = LoggerFactory.getLogger(pluginKey);
    public static final long TRANSACTION_LOG_MAX_NUMBER = 1000L;
    public static final int LOG_ZIP_FILE_COUNT = 100;
    public static final int LOG_FAULT_TOLERANCE = 20;
    @NotNull
    public static final String LOG_PREFIX = "commands";

    public OlapTransactionLogPlugin(@NotNull String rootPath, @NotNull String archiveDir, @NotNull OlapWorkspacePluginContext pluginContext, @NotNull OlapServer olapServer) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)archiveDir, (String)"archiveDir");
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        Intrinsics.checkNotNullParameter((Object)olapServer, (String)"olapServer");
        super(pluginContext, true);
        this.rootPath = rootPath;
        this.archiveDir = archiveDir;
        pluginContext.registerFunctionExecutor((PluginFunctionExecutor)new TransactionCommandFunctionExecutor());
        pluginContext.registerFunctionExecutor((PluginFunctionExecutor)new TransactionTraceFunctionExecutor(olapServer));
        pluginContext.registerFunctionExecutor((PluginFunctionExecutor)new ConcatMeFunctionExecutor(olapServer));
        this.key = pluginKey;
        this.strategy = AbstractSeqLogger.Companion.createStrategy(CommandLogRecord.class, LOG_PREFIX);
    }

    @NotNull
    public Class<OlapTransactionLogPlugin> getKey() {
        return this.key;
    }

    @NotNull
    protected Object getCubePluginKey() {
        return pluginKey;
    }

    protected void onError(@NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        log.error("Failed to write transaction log file:", ex);
    }

    @NotNull
    protected CubeTransactionLogPlugin createCubePlugin(@NotNull CubeWorkspacePluginContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String[] stringArray = new String[]{context.getCubeName()};
        File transactionLogPath = Paths.INSTANCE.get(this.rootPath, stringArray).toFile();
        Object[] objectArray = new String[]{context.getCubeName()};
        String archiveDirLogDir = Paths.INSTANCE.get(this.archiveDir, (String[])objectArray).toFile().getPath();
        if (!transactionLogPath.exists()) {
            String string = Res.INSTANCE.getOlapTransactionLogPluginException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-OlapTransactionLogPluginException_1>(...)");
            objectArray = new Object[]{transactionLogPath};
            throw Res.INSTANCE.getIOException(string, objectArray);
        }
        String string = transactionLogPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        SeqLogger writer = new SeqLogger(string, 1000L, 100, 20, null, this.strategy, archiveDirLogDir, 16, null);
        return new CubeTransactionLogPlugin(context, writer, this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CommandLogRecordEntity[] readRecords(@NotNull String cubeName, @NotNull Long[] commandIds) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)commandIds, (String)"commandIds");
        List list = new ArrayList();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cubeName, commandIds, (List<CommandLogRecordEntity>)list, null){
            int label;
            final /* synthetic */ OlapTransactionLogPlugin this$0;
            final /* synthetic */ String $cubeName;
            final /* synthetic */ Long[] $commandIds;
            final /* synthetic */ List<CommandLogRecordEntity> $list;
            {
                this.this$0 = $receiver;
                this.$cubeName = $cubeName;
                this.$commandIds = $commandIds;
                this.$list = $list;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = OlapTransactionLogPlugin.access$readRecordFlow(this.this$0, this.$cubeName, this.$commandIds, (Continuation)this);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var3_4 = record = (Flow)v0;
                        var4_5 = this.$list;
                        $i$f$collect = false;
                        this.label = 2;
                        v1 = $this$collect$iv.collect((FlowCollector)new FlowCollector<CommandLogRecord>(var4_5){
                            final /* synthetic */ List $list$inlined;
                            {
                                this.$list$inlined = list;
                            }

                            @Nullable
                            public Object emit(Object value, @NotNull Continuation continuation) {
                                Continuation continuation2 = continuation;
                                CommandLogRecord it = (CommandLogRecord)value;
                                boolean bl = false;
                                this.$list$inlined.add(new CommandLogRecordEntity(it.getId(), it.getTraceId(), it.getTime()));
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v1 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Object $this$map$iv = commandIds;
        boolean $i$f$map = false;
        Long[] longArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Long[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            Object v0;
            Collection collection;
            block2: {
                long l = ((Number)item$iv$iv).longValue();
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    void commandId2;
                    CommandLogRecordEntity it = (CommandLogRecordEntity)element$iv;
                    boolean bl2 = false;
                    if (!(it.getId() == commandId2)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            collection.add(v0);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new CommandLogRecordEntity[0]);
    }

    private final Object readRecordFlow(String cubeName, Long[] commandIds, Continuation<? super Flow<? extends CommandLogRecord>> $completion) {
        ITransactionLogReader iTransactionLogReader;
        CubeTransactionLogPlugin cubeTransactionLogPlugin = (CubeTransactionLogPlugin)this.tryGetCubePluginWithoutLazyLoad(cubeName);
        if (cubeTransactionLogPlugin != null) {
            iTransactionLogReader = cubeTransactionLogPlugin;
        } else {
            String[] stringArray = new String[]{cubeName};
            iTransactionLogReader = new TransactionLogReader(cubeName, this.strategy, ((Object)Paths.INSTANCE.get(this.rootPath, stringArray)).toString(), this.archiveDir);
        }
        ITransactionLogReader reader = iTransactionLogReader;
        return reader.readCommandFlow(commandIds, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] readCommand(@NotNull String cubeName, @NotNull Long[] commandIds) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)commandIds, (String)"commandIds");
        List commands = new ArrayList();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cubeName, commandIds, (List<Pair<Long, String>>)commands, null){
            int label;
            final /* synthetic */ OlapTransactionLogPlugin this$0;
            final /* synthetic */ String $cubeName;
            final /* synthetic */ Long[] $commandIds;
            final /* synthetic */ List<Pair<Long, String>> $commands;
            {
                this.this$0 = $receiver;
                this.$cubeName = $cubeName;
                this.$commandIds = $commandIds;
                this.$commands = $commands;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = OlapTransactionLogPlugin.access$readRecordFlow(this.this$0, this.$cubeName, this.$commandIds, (Continuation)this);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var3_4 = record = (Flow)v0;
                        var4_5 = this.$commands;
                        $i$f$collect = false;
                        this.label = 2;
                        v1 = $this$collect$iv.collect((FlowCollector)new FlowCollector<CommandLogRecord>(var4_5){
                            final /* synthetic */ List $commands$inlined;
                            {
                                this.$commands$inlined = list;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Nullable
                            public Object emit(Object value, @NotNull Continuation continuation) {
                                Continuation continuation2 = continuation;
                                CommandLogRecord it = (CommandLogRecord)value;
                                boolean bl = false;
                                String command = null;
                                Closeable closeable = it.getCommand();
                                Object object = Charsets.UTF_8;
                                closeable = new BufferedReader(new InputStreamReader((InputStream)closeable, (Charset)object));
                                object = null;
                                try {
                                    BufferedReader reader = (BufferedReader)closeable;
                                    boolean bl2 = false;
                                    String string = reader.readLine();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readLine(...)");
                                    command = string;
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable) {
                                    object = throwable;
                                    throw throwable;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                                }
                                this.$commands$inlined.add(new Pair((Object)Boxing.boxLong((long)it.getId()), (Object)command));
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v1 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Object $this$map$iv = commandIds;
        boolean $i$f$map = false;
        Long[] longArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Long[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            Object v0;
            Collection collection;
            block3: {
                long l = ((Number)item$iv$iv).longValue();
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = commands;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    void commandId2;
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!(((Number)it.getFirst()).longValue() == commandId2)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((object = (Pair)v0) == null || (object = (String)object.getSecond()) == null) {
                object = "";
            }
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    public final void write(@NotNull String cubeName, long id, @Nullable Long traceId, @NotNull Object command) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (id > 0L) {
            CubeTransactionLogPlugin cubePlugin = (CubeTransactionLogPlugin)this.getOrCreateCubePlugin(cubeName);
            long timeOffset = Instant.now().toEpochMilli();
            Object object = command;
            if (object instanceof String) {
                CubeTransactionLogPlugin cubeTransactionLogPlugin = cubePlugin;
                if (cubeTransactionLogPlugin != null) {
                    cubeTransactionLogPlugin.write((Object)new SeqLogElem(id, traceId, timeOffset, (String)command));
                }
            } else if (object instanceof BigStreamCache) {
                CubeTransactionLogPlugin cubeTransactionLogPlugin = cubePlugin;
                if (cubeTransactionLogPlugin != null) {
                    cubeTransactionLogPlugin.write((Object)new SeqLogElem(id, traceId, timeOffset, (BigStreamCache)command));
                }
            } else if (object instanceof CommandInfo) {
                CubeTransactionLogPlugin cubeTransactionLogPlugin = cubePlugin;
                if (cubeTransactionLogPlugin != null) {
                    cubeTransactionLogPlugin.write((Object)new SeqLogElem(id, traceId, timeOffset, (CommandInfo)command));
                }
            } else {
                String string = Res.INSTANCE.getOlapTransactionLogPluginException_2();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-OlapTransactionLogPluginException_2>(...)");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
        }
    }

    public static final /* synthetic */ Object access$readRecordFlow(OlapTransactionLogPlugin $this, String cubeName, Long[] commandIds, Continuation $completion) {
        return $this.readRecordFlow(cubeName, commandIds, (Continuation<? super Flow<? extends CommandLogRecord>>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lkd/bos/olap/log/OlapTransactionLogPlugin$Companion;", "", "()V", "LOG_FAULT_TOLERANCE", "", "LOG_PREFIX", "", "LOG_ZIP_FILE_COUNT", "TRANSACTION_LOG_MAX_NUMBER", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "pluginKey", "Ljava/lang/Class;", "Lkd/bos/olap/log/OlapTransactionLogPlugin;", "getPluginKey", "()Ljava/lang/Class;", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Class<OlapTransactionLogPlugin> getPluginKey() {
            return pluginKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

