/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.olap.log.CommandLogRecordEntity;
import kd.bos.olap.log.OlapTransactionLogPlugin;
import kd.bos.olap.log.TransactionTraceInfo;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.backup.IRedoTraceInfoIterator;
import kd.bos.olapServer2.backup.RedoTraceInfo;
import kd.bos.olapServer2.backup.RedoTraceIterableWrapper;
import kd.bos.olapServer2.common.ImmutablePropertyBag;
import kd.bos.olapServer2.common.PropertyBag;
import kd.bos.olapServer2.function.FunctionInfo;
import kd.bos.olapServer2.function.PluginFunctionExecutor;
import kd.bos.olapServer2.server.OlapServer;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePluginContext;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kd.bos.olapServer2.storages.plugins.Plugin;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 72\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u000eH\u0016J\b\u0010*\u001a\u00020+H\u0016J5\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u0002002\n\u00101\u001a\u00060\u0006j\u0002`\u00072\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0002\u00a2\u0006\u0002\u00105J\u0012\u00106\u001a\u0004\u0018\u00010\u0014*\u00060\u0006j\u0002`\u0007H\u0002R\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00060\u0006j\u0002`\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a\u0016\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\b\u0012\u00060\u0006j\u0002`\u00070\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u00060\u0006j\u0002`\u0007*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\n\u0018\u00010 j\u0004\u0018\u0001`!*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00068"}, d2={"Lkd/bos/olap/log/TransactionTraceFunctionExecutor;", "Lkd/bos/olapServer2/function/PluginFunctionExecutor;", "olapServer", "Lkd/bos/olapServer2/server/OlapServer;", "(Lkd/bos/olapServer2/server/OlapServer;)V", "description", "", "Lkd/bos/olapServer2/common/string;", "getDescription", "()Ljava/lang/String;", "name", "getName", "cellKey", "", "Lkd/bos/olapServer2/common/ImmutablePropertyBag;", "getCellKey$annotations", "(Lkd/bos/olapServer2/common/ImmutablePropertyBag;)V", "getCellKey", "(Lkd/bos/olapServer2/common/ImmutablePropertyBag;)Ljava/util/Map;", "deadlineTime", "Ljava/time/LocalDateTime;", "getDeadlineTime", "(Lkd/bos/olapServer2/common/ImmutablePropertyBag;)Ljava/time/LocalDateTime;", "limit", "", "Lkd/bos/olapServer2/common/int;", "getLimit", "(Lkd/bos/olapServer2/common/ImmutablePropertyBag;)I", "measureName", "getMeasureName", "(Lkd/bos/olapServer2/common/ImmutablePropertyBag;)Ljava/lang/String;", "nextToken", "", "Lkd/bos/olapServer2/common/long;", "getNextToken", "(Lkd/bos/olapServer2/common/ImmutablePropertyBag;)Ljava/lang/Long;", "execute", "olapContext", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "cubeContext", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "parameters", "getFunctionInfo", "Lkd/bos/olapServer2/function/FunctionInfo;", "getHistoryRecords", "", "Lkd/bos/olap/log/TransactionTraceInfo;", "plugin", "Lkd/bos/olap/log/OlapTransactionLogPlugin;", "cubeName", "redoTraces", "", "Lkd/bos/olapServer2/backup/RedoTraceInfo;", "(Lkd/bos/olap/log/OlapTransactionLogPlugin;Ljava/lang/String;[Lkd/bos/olapServer2/backup/RedoTraceInfo;)Ljava/util/List;", "parseLocalDataTime", "Companion", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nTransactionTraceFunctionExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionTraceFunctionExecutor.kt\nkd/bos/olap/log/TransactionTraceFunctionExecutor\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,278:1\n26#2:279\n37#3,2:280\n37#3,2:286\n11065#4:282\n11400#4,3:283\n11155#4:288\n11266#4,4:289\n*S KotlinDebug\n*F\n+ 1 TransactionTraceFunctionExecutor.kt\nkd/bos/olap/log/TransactionTraceFunctionExecutor\n*L\n76#1:279\n89#1:280,2\n101#1:286,2\n101#1:282\n101#1:283,3\n102#1:288\n102#1:289,4\n*E\n"})
public final class TransactionTraceFunctionExecutor
extends PluginFunctionExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OlapServer olapServer;
    @NotNull
    private static final String param_limit = "limit";
    @NotNull
    private static final String param_deadlineTime = "deadlineTime";
    @NotNull
    private static final String param_nextToken = "nextToken";
    @NotNull
    private static final String param_cellKey = "cellKey";
    @NotNull
    private static final String param_measureName = "measureName";
    @NotNull
    private static final String result_history = "history";
    @NotNull
    private static final String result_nextToken = "nextToken";
    @NotNull
    private static final String result_currentStorage = "currentStorage";
    @NotNull
    private static final String result_realDeadlineTime = "realDeadlineTime";
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper();

    public TransactionTraceFunctionExecutor(@NotNull OlapServer olapServer) {
        Intrinsics.checkNotNullParameter((Object)olapServer, (String)"olapServer");
        this.olapServer = olapServer;
    }

    @NotNull
    public String getName() {
        return "queryTransactionTraceInfo";
    }

    @NotNull
    public String getDescription() {
        String string = Res.INSTANCE.getTransactionTraceFunctionExecutorDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-TransactionTraceFun\u2026ExecutorDescription>(...)");
        return string;
    }

    @NotNull
    public ImmutablePropertyBag execute(@NotNull OlapWorkspacePluginContext olapContext, @Nullable CubeWorkspacePluginContext cubeContext, @NotNull ImmutablePropertyBag parameters) {
        Intrinsics.checkNotNullParameter((Object)olapContext, (String)"olapContext");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        PropertyBag result2 = new PropertyBag(null, 1, null);
        Object object = cubeContext;
        if (object == null || (object = object.getCubeName()) == null) {
            String string = Res.INSTANCE.getCubeNameEmptyException();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-CubeNameEmptyException>(...)");
            throw Res.INSTANCE.getNullPointerException(string, new Object[0]);
        }
        Object cubeName = object;
        Long token = this.getNextToken(parameters);
        Map<String, String> cellKey = this.getCellKey(parameters);
        int limit = this.getLimit(parameters);
        LocalDateTime deadlineTime = this.getDeadlineTime(parameters);
        String measureName = this.getMeasureName(parameters);
        RedoTraceIterableWrapper redoTraceIterableWrapper = this.olapServer.getRedoTraceInfo((String)cubeName, cellKey, measureName, token, deadlineTime);
        IRedoTraceInfoIterator iterator = redoTraceIterableWrapper.getIterable().iterator();
        List redoTraces = new ArrayList();
        for (int count = 0; count < limit && iterator.hasNext(); ++count) {
            redoTraces.add(iterator.next());
        }
        result2.set(result_currentStorage, redoTraceIterableWrapper.getStorageName());
        Long time = iterator.getCurrentDeadlineTime();
        String string = time != null ? Instant.ofEpochSecond(time / (long)1000).atZone(ZoneId.systemDefault()).toLocalDateTime().format(dateFormat) : "";
        Intrinsics.checkNotNull((Object)string);
        result2.set(result_realDeadlineTime, string);
        if (redoTraces.isEmpty()) {
            boolean $i$f$emptyArray = false;
            String string2 = mapper.writeValueAsString((Object)new TransactionTraceInfo[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
            result2.set(result_history, string2);
            result2.set("nextToken", "");
            return (ImmutablePropertyBag)result2;
        }
        Plugin plugin = olapContext.getPlugins().tryGet(OlapTransactionLogPlugin.Companion.getPluginKey());
        Intrinsics.checkNotNull((Object)plugin, (String)"null cannot be cast to non-null type kd.bos.olap.log.OlapTransactionLogPlugin");
        OlapTransactionLogPlugin plugin2 = (OlapTransactionLogPlugin)plugin;
        Collection $this$toTypedArray$iv = redoTraces;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        List<TransactionTraceInfo> history = this.getHistoryRecords(plugin2, (String)cubeName, thisCollection$iv.toArray(new RedoTraceInfo[0]));
        String string3 = mapper.writeValueAsString(history);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"writeValueAsString(...)");
        result2.set(result_history, string3);
        result2.set("nextToken", history.size() < limit ? "" : String.valueOf(((RedoTraceInfo)CollectionsKt.last((List)redoTraces)).getLsn()));
        return (ImmutablePropertyBag)result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TransactionTraceInfo> getHistoryRecords(OlapTransactionLogPlugin plugin, String cubeName, RedoTraceInfo[] redoTraces) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        CommandLogRecordEntity[] $this$toTypedArray$iv;
        Collection<Long> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        RedoTraceInfo[] redoTraceInfoArray = redoTraces;
        String string = cubeName;
        Object object = plugin;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_15 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTransactionId());
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = ((OlapTransactionLogPlugin)((Object)object)).readRecords(string, thisCollection$iv.toArray(new Long[0]));
        boolean $i$f$mapIndexed = false;
        thisCollection$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(((void)$this$mapIndexed$iv).length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            TransactionTraceInfo transactionTraceInfo;
            void index;
            void record;
            int n2 = index$iv$iv++;
            void bl = item$iv$iv;
            int n3 = n2;
            object = destination$iv$iv;
            boolean bl2 = false;
            if (record != null) {
                Long transactionTime = record.getTime();
                String time = transactionTime == null ? redoTraces[index].getTime() : Instant.ofEpochSecond(transactionTime / (long)1000).atZone(ZoneId.systemDefault()).toLocalDateTime().format(dateFormat);
                Long traceId = record.getTraceId() == -1L ? null : Long.valueOf(record.getTraceId());
                transactionTraceInfo = new TransactionTraceInfo(record.getId(), traceId, time, redoTraces[index].getValue());
            } else {
                transactionTraceInfo = new TransactionTraceInfo(redoTraces[index].getTransactionId(), null, redoTraces[index].getTime(), redoTraces[index].getValue());
            }
            object.add(transactionTraceInfo);
        }
        return (List)destination$iv$iv;
    }

    private final Map<String, String> getCellKey(ImmutablePropertyBag $this$cellKey) {
        String cellKey = (String)$this$cellKey.get((Object)param_cellKey);
        if (((CharSequence)cellKey).length() == 0) {
            String string = Res.INSTANCE.getTransactionTraceCellKeyNullException();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-TransactionTraceCellKeyNullException>(...)");
            throw Res.INSTANCE.getNullPointerException(string, new Object[0]);
        }
        try {
            Object object = JsonHelper.INSTANCE.getMapper().readValue(cellKey, HashMap.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.HashMap<kotlin.String, kotlin.String>{ kotlin.collections.TypeAliasesKt.HashMap<kotlin.String, kotlin.String> }");
            return (HashMap)object;
        }
        catch (Exception e) {
            String string = Res.INSTANCE.getTransactionTraceCellKeyFormatException();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-TransactionTraceCellKeyFormatException>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
    }

    private static /* synthetic */ void getCellKey$annotations(ImmutablePropertyBag immutablePropertyBag) {
    }

    private final String getMeasureName(ImmutablePropertyBag $this$measureName) {
        String measureName = (String)$this$measureName.get((Object)param_measureName);
        if (((CharSequence)measureName).length() == 0) {
            String string = Res.INSTANCE.getTransactionTraceMeasureNameNullException();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-TransactionTraceMea\u2026reNameNullException>(...)");
            throw Res.INSTANCE.getNullPointerException(string, new Object[0]);
        }
        return measureName;
    }

    private final LocalDateTime getDeadlineTime(ImmutablePropertyBag $this$deadlineTime) {
        String deadlineTime = (String)$this$deadlineTime.get((Object)param_deadlineTime);
        if (((CharSequence)deadlineTime).length() == 0) {
            String string = Res.INSTANCE.getTransactionTraceDeadlineTimeNullException();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-TransactionTraceDea\u2026neTimeNullException>(...)");
            throw Res.INSTANCE.getNullPointerException(string, new Object[0]);
        }
        LocalDateTime localDateTime = this.parseLocalDataTime(deadlineTime);
        if (localDateTime == null) {
            String string = Res.INSTANCE.getTransactionTraceDeadlineTimeFormatException();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-TransactionTraceDea\u2026TimeFormatException>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        return localDateTime;
    }

    private final int getLimit(ImmutablePropertyBag $this$limit) {
        int limit;
        Integer n = StringsKt.toIntOrNull((String)((String)$this$limit.get((Object)param_limit)));
        int n2 = limit = n != null ? n : 10;
        if (!(0 <= limit ? limit < 1001 : false)) {
            String string = Res.INSTANCE.getTransactionTraceLimitRangeException();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-TransactionTraceLimitRangeException>(...)");
            Object[] objectArray = new Object[]{limit, 0, 1000};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
        return limit;
    }

    private final Long getNextToken(ImmutablePropertyBag $this$nextToken) {
        return StringsKt.toLongOrNull((String)((String)$this$nextToken.get((Object)"nextToken")));
    }

    private final LocalDateTime parseLocalDataTime(String $this$parseLocalDataTime) {
        LocalDateTime localDateTime;
        try {
            localDateTime = LocalDateTime.parse($this$parseLocalDataTime, dateFormat);
        }
        catch (DateTimeParseException e) {
            localDateTime = null;
        }
        return localDateTime;
    }

    @NotNull
    public FunctionInfo getFunctionInfo() {
        FunctionInfo functionInfo = new FunctionInfo(this.getName(), this.getDescription(), false, false, null, null, 56, null);
        String string = Res.INSTANCE.getTransactionTraceParam_1();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-TransactionTraceParam_1>(...)");
        FunctionInfo functionInfo2 = functionInfo.addParameter(new FunctionInfo.ParameterItem(param_cellKey, string, "string", true, false));
        String string2 = Res.INSTANCE.getTransactionTraceParam_5();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-TransactionTraceParam_5>(...)");
        FunctionInfo functionInfo3 = functionInfo2.addParameter(new FunctionInfo.ParameterItem(param_measureName, string2, "string", true, false));
        String string3 = Res.INSTANCE.getTransactionTraceParam_2();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-TransactionTraceParam_2>(...)");
        FunctionInfo functionInfo4 = functionInfo3.addParameter(new FunctionInfo.ParameterItem("nextToken", string3, "long", false, false));
        String string4 = Res.INSTANCE.getTransactionTraceParam_3();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"<get-TransactionTraceParam_3>(...)");
        FunctionInfo functionInfo5 = functionInfo4.addParameter(new FunctionInfo.ParameterItem(param_deadlineTime, string4, "string", true, false));
        String string5 = Res.INSTANCE.getTransactionTraceParam_4();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"<get-TransactionTraceParam_4>(...)");
        return functionInfo5.addParameter(new FunctionInfo.ParameterItem(param_limit, string5, "int", true, false)).addResult(new FunctionInfo.ResultItem(result_history, null, "json")).addResult(new FunctionInfo.ResultItem(result_currentStorage, null, "string")).addResult(new FunctionInfo.ResultItem("nextToken", null, "string")).addResult(new FunctionInfo.ResultItem(result_realDeadlineTime, null, "string"));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkd/bos/olap/log/TransactionTraceFunctionExecutor$Companion;", "", "()V", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "param_cellKey", "", "param_deadlineTime", "param_limit", "param_measureName", "param_nextToken", "result_currentStorage", "result_history", "result_nextToken", "result_realDeadlineTime", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

