/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.logTrace;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.Session;
import kd.bos.olap.logTrace.CommandLog;
import kd.bos.olap.logTrace.OlapTrace;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePlugin;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePluginContext;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bR\u0015\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkd/bos/olap/logTrace/CubeTrace;", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePlugin;", "Ljava/io/Closeable;", "pluginContext", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "owner", "Lkd/bos/olap/logTrace/OlapTrace;", "(Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;Lkd/bos/olap/logTrace/OlapTrace;)V", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "getCubeName", "()Ljava/lang/String;", "key", "", "getKey", "()Ljava/lang/Object;", "sessionSet", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Ljavax/websocket/Session;", "addSession", "", "session", "close", "closeSession", "massSendMessage", "log", "Lkd/bos/olap/logTrace/CommandLog;", "Companion", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nCubeTrace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CubeTrace.kt\nkd/bos/olap/logTrace/CubeTrace\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1855#2,2:80\n1855#2,2:82\n*S KotlinDebug\n*F\n+ 1 CubeTrace.kt\nkd/bos/olap/logTrace/CubeTrace\n*L\n49#1:80,2\n76#1:82,2\n*E\n"})
public final class CubeTrace
extends CubeWorkspacePlugin
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OlapTrace owner;
    @NotNull
    private final CopyOnWriteArraySet<Session> sessionSet;
    @NotNull
    private final String cubeName;
    private static final Logger logger = LoggerFactory.getLogger(CubeTrace.class);

    public CubeTrace(@NotNull CubeWorkspacePluginContext pluginContext, @NotNull OlapTrace owner) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(pluginContext);
        this.owner = owner;
        this.sessionSet = new CopyOnWriteArraySet();
        this.cubeName = pluginContext.getCubeName();
    }

    @Nullable
    public Object getKey() {
        return OlapTrace.Companion.getPluginKey();
    }

    public final void addSession(@NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.sessionSet.add(session);
    }

    @NotNull
    public final String getCubeName() {
        return this.cubeName;
    }

    public final void massSendMessage(@NotNull CommandLog log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        List errorSessionList = null;
        for (Session session : this.sessionSet) {
            try {
                String message = log.toString();
                if (!session.isOpen()) continue;
                session.getBasicRemote().sendText(message);
            }
            catch (Exception ex) {
                logger.error("session.id=" + session.getId(), (Throwable)ex);
                if (errorSessionList == null) {
                    errorSessionList = new ArrayList();
                }
                Intrinsics.checkNotNull((Object)session);
                errorSessionList.add(session);
            }
        }
        List list = errorSessionList;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Session it = (Session)element$iv;
                boolean bl = false;
                if (it.isOpen()) {
                    it.close();
                }
                this.sessionSet.remove(it);
            }
        }
        if (this.sessionSet.isEmpty()) {
            this.close();
            this.owner.removeCube(this.cubeName);
        }
    }

    public final void closeSession(@NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        session.close();
        this.sessionSet.remove(session);
        if (this.sessionSet.isEmpty()) {
            this.close();
            this.owner.removeCube(this.cubeName);
        }
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.sessionSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Session it = (Session)element$iv;
            boolean bl = false;
            it.close();
        }
        this.sessionSet.clear();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkd/bos/olap/logTrace/CubeTrace$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

