/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.logTrace;

import java.io.Closeable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.websocket.Session;
import kd.bos.olap.logTrace.CommandLog;
import kd.bos.olap.logTrace.CubeTrace;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.storages.plugins.CubeWorkspacePluginContext;
import kd.bos.olapServer2.storages.plugins.OlapWorkspaceBasicPlugin;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001!B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001a\u0010\u001c\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\tJ\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u00022\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016J\b\u0010 \u001a\u00020\u0013H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lkd/bos/olap/logTrace/OlapTrace;", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspaceBasicPlugin;", "Lkd/bos/olap/logTrace/CubeTrace;", "Ljava/io/Closeable;", "pluginContext", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "(Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;)V", "_commandLogQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkd/bos/olap/logTrace/CommandLog;", "_sendThread", "Ljava/lang/Thread;", "_stopMe", "", "cubePluginKey", "", "getCubePluginKey", "()Ljava/lang/Object;", "close", "", "cubeName", "", "Lkd/bos/olapServer2/common/string;", "session", "Ljavax/websocket/Session;", "createCubePlugin", "context", "Lkd/bos/olapServer2/storages/plugins/CubeWorkspacePluginContext;", "open", "putLog", "log", "removeCube", "send", "Companion", "bos-olap-webserver"})
public final class OlapTrace
extends OlapWorkspaceBasicPlugin<CubeTrace>
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedBlockingQueue<CommandLog> _commandLogQueue;
    @NotNull
    private final Thread _sendThread;
    private volatile boolean _stopMe;
    @NotNull
    private static final CommandLog POISONLOG = new CommandLog("", "", 0.0f, "");
    @NotNull
    private static final Class<OlapTrace> pluginKey = OlapTrace.class;
    private static final Logger logger = LoggerFactory.getLogger(pluginKey);
    private static final int Message_Queue_Capacity = 1024;

    public OlapTrace(@NotNull OlapWorkspacePluginContext pluginContext) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        super(pluginContext, false);
        this._commandLogQueue = new LinkedBlockingQueue(1024);
        this._sendThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"OlapTrace", (int)0, (Function0)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                OlapTrace.access$send((OlapTrace)this.receiver);
            }
        }), (int)23, null);
    }

    public final void putLog(@NotNull CommandLog log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        if (!this._stopMe) {
            if (this._commandLogQueue.remainingCapacity() > 0) {
                this._commandLogQueue.offer(log, 5L, TimeUnit.SECONDS);
            } else {
                this._commandLogQueue.clear();
                this._commandLogQueue.offer(new CommandLog(log.getCubeName(), log.getStartDate(), log.getSpendTime(), Res.INSTANCE.getOlapTrace_1()));
            }
        }
    }

    private final void send() {
        while (!this._stopMe) {
            try {
                CubeTrace lastCubeTrace;
                CommandLog cmdLog = this._commandLogQueue.take();
                if (Intrinsics.areEqual((Object)cmdLog, (Object)POISONLOG)) {
                    return;
                }
                CubeTrace cubeTrace = lastCubeTrace = (CubeTrace)this.getOrCreateCubePlugin(cmdLog.getCubeName());
                if (cubeTrace == null) continue;
                Intrinsics.checkNotNull((Object)cmdLog);
                cubeTrace.massSendMessage(cmdLog);
            }
            catch (Exception ex) {
                try {
                    logger.error("send error.", (Throwable)ex);
                }
                catch (Throwable ex2) {
                    this._commandLogQueue.clear();
                }
            }
        }
    }

    public final void open(@NotNull String cubeName, @NotNull Session session) {
        block0: {
            CubeTrace cubeTrace;
            Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            CubeTrace cubeTrace2 = cubeTrace = (CubeTrace)this.getOrCreateCubePlugin(cubeName);
            if (cubeTrace2 == null) break block0;
            cubeTrace2.addSession(session);
        }
    }

    @NotNull
    protected Object getCubePluginKey() {
        return pluginKey;
    }

    @NotNull
    protected CubeTrace createCubePlugin(@NotNull CubeWorkspacePluginContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new CubeTrace(context, this);
    }

    public final void close(@NotNull String cubeName, @NotNull Session session) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            CubeTrace cubeTrace = (CubeTrace)this.getOrCreateCubePlugin(cubeName);
            if (cubeTrace == null) break block0;
            cubeTrace.closeSession(session);
        }
    }

    @Nullable
    public final CubeTrace removeCube(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        return (CubeTrace)this.removeCubePlugin(cubeName);
    }

    @Override
    public void close() {
        this._stopMe = true;
        this._commandLogQueue.put(POISONLOG);
        this._sendThread.join();
    }

    public static final /* synthetic */ void access$send(OlapTrace $this) {
        $this.send();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lkd/bos/olap/logTrace/OlapTrace$Companion;", "", "()V", "Message_Queue_Capacity", "", "POISONLOG", "Lkd/bos/olap/logTrace/CommandLog;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "pluginKey", "Ljava/lang/Class;", "Lkd/bos/olap/logTrace/OlapTrace;", "getPluginKey", "()Ljava/lang/Class;", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Class<OlapTrace> getPluginKey() {
            return pluginKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

