/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.schedule;

import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import kd.bos.olap.common.WebOlapConfigItemCollection;
import kd.bos.olap.log.OlapBackupLogger;
import kd.bos.olap.schedule.DirectFile;
import kd.bos.olap.schedule.VersionFileContainer;
import kd.bos.olapServer2.backup.BackupFile;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.IContinueToken;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.dataSources.BackupCommandInfo;
import kd.bos.olapServer2.server.IOlapLogger;
import kd.bos.olapServer2.server.OlapServer;
import kd.bos.olapServer2.server.OlapSession;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 %2\u00020\u0001:\u0002%&B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0014\u001a\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00060\u0007j\u0002`\b2\n\u0010\u0019\u001a\u00060\u0007j\u0002`\bH\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\f\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0002J\u0018\u0010!\u001a\u00060\u0015j\u0002`\u00162\n\u0010\u0017\u001a\u00060\u0007j\u0002`\bH\u0002J\u0006\u0010\"\u001a\u00020\u001bJ\u0014\u0010#\u001a\u00020\u001b2\n\u0010$\u001a\u00060\u0007j\u0002`\bH\u0002R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lkd/bos/olap/schedule/BackupFlow;", "", "olapServer", "Lkd/bos/olapServer2/server/OlapServer;", "configItems", "Lkd/bos/olap/common/WebOlapConfigItemCollection;", "tempFolderPath", "", "Lkd/bos/olapServer2/common/string;", "(Lkd/bos/olapServer2/server/OlapServer;Lkd/bos/olap/common/WebOlapConfigItemCollection;Ljava/lang/String;)V", "backupPath", "closingToken", "Lkd/bos/olapServer2/common/IContinueToken;", "command", "logger", "Lkd/bos/olap/log/OlapBackupLogger;", "sdf", "Ljava/text/SimpleDateFormat;", "versionContainer", "Lkd/bos/olap/schedule/VersionFileContainer;", "backupToLocalFile", "", "Lkd/bos/olapServer2/common/long;", "cubeName", "checkCmd", "cmd", "close", "", "copyToCommand", "relativePath", "isWindows", "", "Lkd/bos/olapServer2/common/bool;", "needUpdate", "run", "startBackupCube", "cube", "Companion", "TempLogFile", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nBackupFlow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupFlow.kt\nkd/bos/olap/schedule/BackupFlow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,304:1\n1855#2,2:305\n*S KotlinDebug\n*F\n+ 1 BackupFlow.kt\nkd/bos/olap/schedule/BackupFlow\n*L\n80#1:305,2\n*E\n"})
public final class BackupFlow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OlapServer olapServer;
    @NotNull
    private final WebOlapConfigItemCollection configItems;
    @NotNull
    private final String tempFolderPath;
    @NotNull
    private final OlapBackupLogger logger;
    @NotNull
    private final String command;
    @NotNull
    private final String backupPath;
    @NotNull
    private final VersionFileContainer versionContainer;
    @NotNull
    private final SimpleDateFormat sdf;
    @NotNull
    private final IContinueToken closingToken;
    @NotNull
    private static final String BACKUP_FILE_EXTENSION = "backup";

    public BackupFlow(@NotNull OlapServer olapServer, @NotNull WebOlapConfigItemCollection configItems, @NotNull String tempFolderPath) {
        Intrinsics.checkNotNullParameter((Object)olapServer, (String)"olapServer");
        Intrinsics.checkNotNullParameter((Object)configItems, (String)"configItems");
        Intrinsics.checkNotNullParameter((Object)tempFolderPath, (String)"tempFolderPath");
        this.olapServer = olapServer;
        this.configItems = configItems;
        this.tempFolderPath = tempFolderPath;
        this.logger = new OlapBackupLogger(this.olapServer);
        this.command = this.configItems.getCommand();
        this.backupPath = this.olapServer.getBackupPath();
        this.versionContainer = new VersionFileContainer(this.backupPath);
        this.sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        this.closingToken = CancellableToken.INSTANCE.getContinueToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            File backupFile = Paths.INSTANCE.toFile(this.backupPath);
            if (!backupFile.exists()) {
                backupFile.mkdir();
            }
            this.versionContainer.load();
            List cubes = this.olapServer.getCubes();
            int cubeSize = cubes.size();
            this.logger.info("start run {} ...{}", (Object)cubeSize, (Object)this.backupPath);
            if (cubeSize == 0) {
                return;
            }
            Iterable $this$forEach$iv = cubes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.startBackupCube(it);
            }
            this.logger.info("all cubes is finished");
            this.olapServer.cleanBackupFiles((IOlapLogger)this.logger);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "empty message";
            }
            this.logger.error(string, (Object)e);
        }
        finally {
            this.versionContainer.save();
        }
    }

    private final void startBackupCube(String cube) {
        long backupVersion;
        if (!this.closingToken.canContinue()) {
            return;
        }
        long currentVersion = this.needUpdate(cube);
        if (currentVersion >= 0L && (backupVersion = this.backupToLocalFile(cube)) >= 0L) {
            this.versionContainer.put(cube, String.valueOf(backupVersion));
        }
    }

    private final long needUpdate(String cubeName) {
        long l;
        Object object = this.versionContainer.get(cubeName);
        long version = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : -1L;
        try {
            long l2;
            long currentVersion = this.olapServer.getTransactionVersion(cubeName);
            if (currentVersion == -2L) {
                this.logger.info("cube {} is deleted.", (Object)cubeName);
                this.versionContainer.remove(cubeName);
                l2 = -2L;
            } else if (currentVersion == -1L) {
                if (version < 0L) {
                    l2 = 0L;
                } else {
                    this.logger.info("cube {} not loaded.", (Object)cubeName);
                    l2 = -1L;
                }
            } else if (currentVersion != version) {
                l2 = currentVersion;
            } else {
                this.logger.info("cube {} not changed.", (Object)cubeName);
                l2 = -1L;
            }
            l = l2;
        }
        catch (Exception ex) {
            this.logger.error("get cube:" + cubeName + " version error", (Object)ex);
            l = -1L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long backupToLocalFile(String cubeName) {
        DirectFile file = new DirectFile();
        String[] stringArray = new String[]{cubeName};
        File cubeFile = Paths.INSTANCE.get(this.backupPath, stringArray).toFile();
        if (!cubeFile.exists()) {
            cubeFile.mkdir();
            this.copyToCommand(cubeName);
        }
        String backupCubeFileName = cubeName + '-' + this.sdf.format(new Date()) + ".backup";
        String tempFileName = backupCubeFileName + ".temp";
        String string = cubeFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String[] stringArray2 = new String[]{tempFileName};
        file.setUrl(((Object)Paths.INSTANCE.get(string, stringArray2)).toString());
        this.logger.info("'{}' starting backup to '{}'", (Object)cubeName, (Object)file.getUrl());
        BackupCommandInfo cmd = new BackupCommandInfo((BackupFile)file);
        try {
            long l;
            Closeable closeable = file.outputStream();
            String[] stringArray3 = null;
            try {
                OutputStream outputStream = (OutputStream)closeable;
                boolean bl = false;
                l = this.olapServer.backup(cmd, new OlapSession(cubeName, null, null, 6, null), outputStream);
            }
            catch (Throwable object) {
                stringArray3 = object;
                throw object;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)stringArray3);
            }
            long version = l;
            File file2 = Paths.INSTANCE.toFile(file.getUrl());
            String string2 = cubeFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            stringArray3 = new String[]{backupCubeFileName};
            boolean ok = file2.renameTo(Paths.INSTANCE.toFile(((Object)Paths.INSTANCE.get(string2, stringArray3)).toString()));
            if (!ok) {
                this.logger.error("'{}' rename failed...", (Object)file.getUrl());
            }
            this.copyToCommand(cubeName + '/' + backupCubeFileName);
            this.logger.info("'{}' backup finished.", (Object)cubeName);
            return version;
        }
        catch (Exception ex) {
            this.logger.error("'{}' backup failed...", (Object)cubeName, (Object)ex);
            Files.delete(Paths.INSTANCE.get(file.getUrl(), new String[0]));
            if (!(ex instanceof CancellationException)) {
                this.logger.reportAndError("AutoBackupFailed-" + cubeName, cubeName, "AutoBackupFailed-" + cubeName + ": Auto backup failed! There may be some mistakes.", ex);
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyToCommand(String relativePath) {
        TempLogFile errorResult;
        TempLogFile infoResult;
        block9: {
            String infoText;
            String cmd = this.command;
            if (((CharSequence)cmd).length() == 0) {
                return;
            }
            String realCMD = StringsKt.replace$default((String)cmd, (String)"%s", (String)relativePath, (boolean)false, (int)4, null);
            infoResult = new TempLogFile("BackupCmdInfo.log", this.tempFolderPath);
            errorResult = new TempLogFile("BackupCmdError.log", this.tempFolderPath);
            try {
                ProcessBuilder processBuilder;
                String[] stringArray;
                this.logger.info("command is :" + realCMD);
                if (this.isWindows()) {
                    stringArray = new String[]{this.checkCmd(realCMD)};
                    ProcessBuilder processBuilder2 = new ProcessBuilder(stringArray);
                    processBuilder = processBuilder2;
                } else {
                    stringArray = new String[]{"/bin/sh", "-c", this.checkCmd(realCMD)};
                    ProcessBuilder processBuilder3 = new ProcessBuilder(stringArray);
                    processBuilder = processBuilder3;
                }
                ProcessBuilder proBuilder = processBuilder;
                proBuilder.redirectOutput(infoResult.getFile());
                proBuilder.redirectError(errorResult.getFile());
                Process pro = proBuilder.start();
                pro.waitFor(20L, TimeUnit.MINUTES);
                infoText = infoResult.getText();
                if (!(((CharSequence)infoText).length() > 0)) break block9;
            }
            catch (Exception e) {
                block10: {
                    String infoText2;
                    try {
                        this.logger.error("{}", (Object)realCMD, (Object)e);
                        String errorText = errorResult.getText();
                        if (((CharSequence)errorText).length() > 0) {
                            this.logger.warn("{}", (Object)errorText);
                        }
                        if (!(((CharSequence)(infoText2 = infoResult.getText())).length() > 0)) break block10;
                    }
                    catch (Throwable throwable) {
                        String infoText3 = infoResult.getText();
                        if (((CharSequence)infoText3).length() > 0) {
                            this.logger.info("{}", (Object)infoText3);
                        }
                        infoResult.close();
                        errorResult.close();
                        throw throwable;
                    }
                    this.logger.info("{}", (Object)infoText2);
                }
                infoResult.close();
                errorResult.close();
            }
            this.logger.info("{}", (Object)infoText);
        }
        infoResult.close();
        errorResult.close();
    }

    private final boolean isWindows() {
        String string = System.getProperty("os.name");
        return string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"windows", (boolean)true) : false;
    }

    private final String checkCmd(String cmd) {
        if (StringsKt.contains$default((CharSequence)cmd, (CharSequence)"&", (boolean)false, (int)2, null)) {
            throw new RuntimeException("the cmd '" + cmd + "' can not contains illegal character");
        }
        return cmd;
    }

    public final void close() {
        try {
            List cubes = this.olapServer.getCubes();
            if (!((Collection)cubes).isEmpty()) {
                for (String cube : cubes) {
                    if (this.needUpdate(cube) < 0L) continue;
                    this.versionContainer.put(cube, "-1");
                }
            }
            this.versionContainer.save();
        }
        catch (Exception ex) {
            this.logger.error("write version.dat error when closed", (Object)ex);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkd/bos/olap/schedule/BackupFlow$Companion;", "", "()V", "BACKUP_FILE_EXTENSION", "", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\u0003R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lkd/bos/olap/schedule/BackupFlow$TempLogFile;", "Ljava/io/Closeable;", "name", "", "Lkd/bos/olapServer2/common/string;", "tempFolderPath", "(Ljava/lang/String;Ljava/lang/String;)V", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "close", "", "getText", "bos-olap-webserver"})
    private static final class TempLogFile
    implements Closeable {
        @NotNull
        private final File file;

        public TempLogFile(@NotNull String name, @NotNull String tempFolderPath) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)tempFolderPath, (String)"tempFolderPath");
            String[] stringArray = new String[]{name};
            File file = Paths.INSTANCE.get(tempFolderPath, stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            this.file = file;
            if (this.file.exists()) {
                this.file.delete();
            }
            this.file.createNewFile();
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final String getText() {
            return FilesKt.readText((File)this.file, (Charset)Charsets.UTF_8);
        }

        @Override
        public void close() {
            this.file.delete();
        }
    }
}

