/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.schedule;

import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.olap.schedule.AutoBackupRule;
import kd.bos.olap.schedule.AutoBackupRuleList;
import kd.bos.olap.schedule.BackupFlow;
import kd.bos.olap.schedule.CrontabJobContainerKt;
import kd.bos.olap.schedule.CrontabJobItem;
import kd.bos.olap.schedule.CrontabJobManager;
import kd.bos.olap.schedule.CrontabJobRule;
import kd.bos.olap.schedule.CrontabJobRuleList;
import kd.bos.olap.schedule.CrontabJobRuleShow;
import kd.bos.olap.schedule.CrontabJobType;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.BackgroundOlapBackupCommandExecutor;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olapServer2.common.CancellableToken;
import kd.bos.olapServer2.common.ICancellable;
import kd.bos.olapServer2.common.ITempFolder;
import kd.bos.olapServer2.common.OlapContext;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.replication.BackupType;
import kd.bos.olapServer2.server.OlapServer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronTrigger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 %2\u00020\u0001:\u0002%&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u0011H\u0002J\u0012\u0010\u0016\u001a\u00020\n2\n\u0010\u0017\u001a\u00060\u0010j\u0002`\u0011J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fJ\u0006\u0010 \u001a\u00020\nJ\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lkd/bos/olap/schedule/CrontabJobContainer;", "Ljava/io/Closeable;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "ruleListFile", "Ljava/io/File;", "(Lkd/bos/olap/server/HttpOlapServer;Ljava/io/File;)V", "crontabJobManager", "Lkd/bos/olap/schedule/CrontabJobManager;", "addCrontabJobRule", "", "item", "Lkd/bos/olap/schedule/CrontabJobItem;", "type", "Lkd/bos/olap/schedule/CrontabJobType;", "crontab", "", "Lkd/bos/olapServer2/common/string;", "close", "dealUpgradeRuleList", "Lkd/bos/olap/schedule/CrontabJobRuleList;", "ruleListContent", "deleteCrontabJobRule", "jobName", "force", "list", "getCrontabJobRuleList", "", "Lkd/bos/olap/schedule/CrontabJobRuleShow;", "hasAnyTotalIncrementTask", "", "Lkd/bos/olapServer2/common/bool;", "load", "upgradeV1ToV2", "originRuleList", "Lkd/bos/olap/schedule/AutoBackupRuleList;", "upgradeV2ToV3", "Companion", "CrontabJob", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nCrontabJobContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrontabJobContainer.kt\nkd/bos/olap/schedule/CrontabJobContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,407:1\n1855#2,2:408\n1855#2,2:410\n1855#2,2:412\n1747#2,3:414\n1011#2,2:419\n215#3,2:417\n*S KotlinDebug\n*F\n+ 1 CrontabJobContainer.kt\nkd/bos/olap/schedule/CrontabJobContainer\n*L\n31#1:408,2\n114#1:410,2\n143#1:412,2\n196#1:414,3\n221#1:419,2\n206#1:417,2\n*E\n"})
public final class CrontabJobContainer
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpOlapServer currentServer;
    @NotNull
    private final File ruleListFile;
    @NotNull
    private final CrontabJobManager crontabJobManager;
    @NotNull
    private static final Class<CrontabJob> jobClazz = CrontabJob.class;
    @NotNull
    public static final String OLDJOB_Prefix_NAME = "BACKUP_JOB_";
    @NotNull
    public static final String JOB_Prefix_NAME = "CRONTAB_JOB_";
    @NotNull
    public static final String Increment_Backup_Job_Rule = "0 0 0 ? * MON,TUE,WED,THU,FRI,SAT,SUN";
    @NotNull
    public static final String Total_Backup_Job_Rule = "0 30 0 ? * SUN";
    @NotNull
    private static final String DEFAULT_JOB_AUTO_BACKUP = "DEFAULT_JOB_AUTO_BACKUP";

    public CrontabJobContainer(@NotNull HttpOlapServer currentServer, @NotNull File ruleListFile) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        Intrinsics.checkNotNullParameter((Object)ruleListFile, (String)"ruleListFile");
        this.currentServer = currentServer;
        this.ruleListFile = ruleListFile;
        this.crontabJobManager = new CrontabJobManager();
    }

    public final void load() {
        String ruleListContent = this.ruleListFile.exists() ? FilesKt.readText((File)this.ruleListFile, (Charset)Charsets.UTF_8) : null;
        CrontabJobRuleList ruleList = this.dealUpgradeRuleList(ruleListContent);
        Iterable $this$forEach$iv = ruleList.getList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CrontabJobRule it = (CrontabJobRule)element$iv;
            boolean bl = false;
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                ((Map)params).put("type", it.getType().name());
                this.crontabJobManager.addJob(it.getRule(), it.getJobName(), jobClazz, params);
            }
            catch (Throwable ex) {
                this.crontabJobManager.getLogger().error("Failed to load rule {}.", (Object)it.getJobName(), (Object)ex);
            }
        }
    }

    private final CrontabJobRuleList dealUpgradeRuleList(String ruleListContent) {
        Object upgradeList;
        Object originRuleList;
        Object object;
        boolean needForce = false;
        CharSequence charSequence = ruleListContent;
        if (charSequence == null || charSequence.length() == 0) {
            object = new CrontabJobRuleList(null, 1, null);
        } else if (StringsKt.contains$default((CharSequence)ruleListContent, (CharSequence)OLDJOB_Prefix_NAME, (boolean)false, (int)2, null)) {
            originRuleList = (AutoBackupRuleList)JsonHelper.INSTANCE.getMapper().readValue(ruleListContent, AutoBackupRuleList.class);
            Intrinsics.checkNotNull((Object)originRuleList);
            upgradeList = this.upgradeV1ToV2((AutoBackupRuleList)originRuleList);
            if (!((Collection)((CrontabJobRuleList)upgradeList).getList()).isEmpty()) {
                needForce = true;
            }
            object = upgradeList;
        } else if (StringsKt.contains$default((CharSequence)ruleListContent, (CharSequence)"CleanFiles", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)ruleListContent, (CharSequence)"Increment", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)ruleListContent, (CharSequence)"ConditionIncrement", (boolean)false, (int)2, null)) {
            originRuleList = (CrontabJobRuleList)JsonHelper.INSTANCE.getMapper().readValue(ruleListContent, CrontabJobRuleList.class);
            Intrinsics.checkNotNull((Object)originRuleList);
            upgradeList = this.upgradeV2ToV3((CrontabJobRuleList)originRuleList);
            if (!((Collection)((CrontabJobRuleList)upgradeList).getList()).isEmpty()) {
                needForce = true;
            }
            object = upgradeList;
        } else {
            object = (CrontabJobRuleList)JsonHelper.INSTANCE.getMapper().readValue(ruleListContent, CrontabJobRuleList.class);
        }
        CrontabJobRuleList result2 = object;
        int interval = this.currentServer.getConfigItems().getIntervalConfigItem$bos_olap_webserver().getValue();
        if (interval > 0 && ((upgradeList = (CharSequence)ruleListContent) == null || upgradeList.length() == 0 || !StringsKt.contains$default((CharSequence)ruleListContent, (CharSequence)DEFAULT_JOB_AUTO_BACKUP, (boolean)false, (int)2, null))) {
            String timeUnit = this.currentServer.getConfigItems().getTimeUnitConfigItem$bos_olap_webserver().getValue();
            try {
                String rule = Companion.convertToRule(interval, timeUnit);
                result2.getList().add(new CrontabJobRule(DEFAULT_JOB_AUTO_BACKUP, CrontabJobType.AutoBackup, rule));
                this.currentServer.refreshSchedule(-1);
                this.crontabJobManager.getLogger().info("The old version of the automatic backup configuration has been successfully upgraded. interval={}, timeUnit='{}'.", (Object)interval, (Object)timeUnit);
                needForce = true;
            }
            catch (Throwable ex) {
                this.crontabJobManager.getLogger().error("Failed to upgrade interval={}, timeUnit='{}'..", (Object)interval, (Object)timeUnit);
            }
        }
        if (needForce) {
            Intrinsics.checkNotNull((Object)result2);
            this.force(result2);
        }
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    private final CrontabJobRuleList upgradeV1ToV2(AutoBackupRuleList originRuleList) {
        List resRuleList = new ArrayList();
        Iterable $this$forEach$iv = originRuleList.getList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoBackupRule it = (AutoBackupRule)element$iv;
            boolean bl = false;
            String realRule = WhenMappings.$EnumSwitchMapping$0[it.getBackupType().ordinal()] == 1 ? (Intrinsics.areEqual((Object)it.getRule(), (Object)"0 0 0 ? * SUN") ? Total_Backup_Job_Rule : it.getRule()) : it.getRule();
            resRuleList.add(new CrontabJobRule(StringsKt.replace$default((String)it.getJobName(), (String)OLDJOB_Prefix_NAME, (String)JOB_Prefix_NAME, (boolean)false, (int)4, null), CrontabJobType.valueOf(it.getBackupType().name()), realRule));
        }
        return new CrontabJobRuleList(resRuleList);
    }

    private final CrontabJobRuleList upgradeV2ToV3(CrontabJobRuleList originRuleList) {
        List resRuleList = new ArrayList();
        Iterable $this$forEach$iv = originRuleList.getList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CrontabJobRule it = (CrontabJobRule)element$iv;
            boolean bl = false;
            if (it.getType() == CrontabJobType.Increment || it.getType() == CrontabJobType.ConditionIncrement || it.getType() == CrontabJobType.CleanFiles) continue;
            resRuleList.add(it);
        }
        return new CrontabJobRuleList(resRuleList);
    }

    public final synchronized void addCrontabJobRule(@NotNull CrontabJobItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        HashMap<String, String> params = new HashMap<String, String>();
        ((Map)params).put("type", item.getType().name());
        String jobName = CrontabJobContainer.Companion.getJobName();
        this.crontabJobManager.addJob(item.getRule(), jobName, jobClazz, params);
        List<CrontabJobRuleShow> ruleList = this.getCrontabJobRuleList();
        this.force(CrontabJobContainerKt.access$toCrontabJobRuleList(ruleList));
    }

    public final void addCrontabJobRule(@NotNull CrontabJobType type, @NotNull String crontab) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)crontab, (String)"crontab");
        this.addCrontabJobRule(new CrontabJobItem(null, type, crontab, 1, null));
    }

    private final void force(CrontabJobRuleList list) {
        JsonHelper.INSTANCE.getMapper().writerWithDefaultPrettyPrinter().writeValue(this.ruleListFile, (Object)list);
    }

    public final synchronized void deleteCrontabJobRule(@NotNull String jobName) {
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        this.crontabJobManager.removeJob(jobName);
        List<CrontabJobRuleShow> ruleList = this.getCrontabJobRuleList();
        ruleList.removeIf(arg_0 -> CrontabJobContainer.deleteCrontabJobRule$lambda$3((Function1)new Function1<CrontabJobRuleShow, Boolean>(jobName){
            final /* synthetic */ String $jobName;
            {
                this.$jobName = $jobName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull CrontabJobRuleShow it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getJobName(), (Object)this.$jobName);
            }
        }, arg_0));
        this.force(CrontabJobContainerKt.access$toCrontabJobRuleList(ruleList));
    }

    public final boolean hasAnyTotalIncrementTask() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getCrontabJobRuleList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CrontabJobRuleShow it = (CrontabJobRuleShow)element$iv;
                    boolean bl2 = false;
                    if (!(it.getType() == CrontabJobType.Total || it.getType() == CrontabJobType.Increment)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final synchronized List<CrontabJobRuleShow> getCrontabJobRuleList() {
        HashMap<TriggerKey, JobDetailImpl> map = this.crontabJobManager.getAllJobs();
        List list = new ArrayList();
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            TriggerKey triggerKey = (TriggerKey)entry.getKey();
            JobDetailImpl jobDetail = (JobDetailImpl)entry.getValue();
            Trigger trigger = this.crontabJobManager.getTrigger(triggerKey);
            Intrinsics.checkNotNull((Object)trigger, (String)"null cannot be cast to non-null type org.quartz.CronTrigger");
            CronTrigger cronTrigger = (CronTrigger)trigger;
            String type = jobDetail.getJobDataMap().getString("type");
            String previousTime = cronTrigger.getPreviousFireTime() == null ? "" : CrontabJobManager.Companion.getDataFormat().format(cronTrigger.getPreviousFireTime());
            String string = jobDetail.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Intrinsics.checkNotNull((Object)type);
            CrontabJobType crontabJobType = CrontabJobType.valueOf(type);
            String string2 = cronTrigger.getCronExpression();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCronExpression(...)");
            Intrinsics.checkNotNull((Object)previousTime);
            String string3 = CrontabJobManager.Companion.getDataFormat().format(cronTrigger.getNextFireTime());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            list.add(new CrontabJobRuleShow(string, crontabJobType, string2, previousTime, string3));
        }
        List $this$sortByDescending$iv = list;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CrontabJobRuleShow it = (CrontabJobRuleShow)b;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getJobName());
                    it = (CrontabJobRuleShow)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getJobName())));
                }
            });
        }
        return list;
    }

    @Override
    public void close() {
        this.crontabJobManager.close();
        HttpOlapServer $this$close_u24lambda_u247 = this.currentServer;
        boolean bl = false;
        new BackupFlow($this$close_u24lambda_u247.getOlapServer(), $this$close_u24lambda_u247.getConfigItems(), $this$close_u24lambda_u247.getTempFolderPath()).close();
    }

    private static final boolean deleteCrontabJobRule$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000e\u001a\u00020\u00042\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\n\u0010\u0012\u001a\u00060\u0004j\u0002`\u0013J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0004j\u0002`\u0013J\f\u0010\u0019\u001a\u00060\u0004j\u0002`\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lkd/bos/olap/schedule/CrontabJobContainer$Companion;", "", "()V", "DEFAULT_JOB_AUTO_BACKUP", "", "Increment_Backup_Job_Rule", "JOB_Prefix_NAME", "OLDJOB_Prefix_NAME", "Total_Backup_Job_Rule", "jobClazz", "Ljava/lang/Class;", "Lkd/bos/olap/schedule/CrontabJobContainer$CrontabJob;", "getJobClazz", "()Ljava/lang/Class;", "convertToRule", "interval", "", "Lkd/bos/olapServer2/common/int;", "timeUnit", "Lkd/bos/olapServer2/common/string;", "create", "Lkd/bos/olap/schedule/CrontabJobContainer;", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "path", "getJobName", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Class<CrontabJob> getJobClazz() {
            return jobClazz;
        }

        private final String getJobName() {
            return CrontabJobContainer.JOB_Prefix_NAME + System.currentTimeMillis();
        }

        @NotNull
        public final CrontabJobContainer create(@NotNull HttpOlapServer currentServer, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File ruleListFile = Paths.INSTANCE.toFile(path, "ruleList.json");
            CrontabJobContainer result2 = new CrontabJobContainer(currentServer, ruleListFile);
            try {
                result2.load();
            }
            catch (Throwable ex) {
                result2.crontabJobManager.getLogger().error("Failed to load {}.", (Object)ruleListFile, (Object)ex);
            }
            return result2;
        }

        @NotNull
        public final String convertToRule(int interval, @NotNull String timeUnit) {
            Intrinsics.checkNotNullParameter((Object)timeUnit, (String)"timeUnit");
            String rule = Intrinsics.areEqual((Object)timeUnit, (Object)"second") ? "0/" + interval + " * * * * ?" : (interval < 60 ? "0 0/" + interval + " * * * ?" : (interval < 1440 ? "0 0 0/" + interval / 60 + " * * ?" : (interval < 44640 ? "0 0 0 1/" + interval / (60 * 24) + " * ?" : "0 0 0 1 1/6 ?")));
            return rule;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @DisallowConcurrentExecution
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00060\nj\u0002`\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\f\u00a8\u0006\u0014"}, d2={"Lkd/bos/olap/schedule/CrontabJobContainer$CrontabJob;", "Lorg/quartz/InterruptableJob;", "Lkd/bos/olapServer2/common/ICancellable;", "()V", "closingToken", "exception", "", "getException", "()Ljava/lang/Throwable;", "isCancel", "", "Lkd/bos/olapServer2/common/bool;", "()Z", "cancel", "", "ex", "execute", "context", "Lorg/quartz/JobExecutionContext;", "interrupt", "bos-olap-webserver"})
    @SourceDebugExtension(value={"SMAP\nCrontabJobContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrontabJobContainer.kt\nkd/bos/olap/schedule/CrontabJobContainer$CrontabJob\n+ 2 OlapContext.kt\nkd/bos/olapServer2/common/OlapContext$Companion\n*L\n1#1,407:1\n129#2,10:408\n*S KotlinDebug\n*F\n+ 1 CrontabJobContainer.kt\nkd/bos/olap/schedule/CrontabJobContainer$CrontabJob\n*L\n264#1:408,10\n*E\n"})
    public static final class CrontabJob
    implements InterruptableJob,
    ICancellable {
        @NotNull
        private final ICancellable closingToken = CancellableToken.INSTANCE.createCancellable();

        public void interrupt() {
            this.closingToken.cancel();
        }

        public void cancel(@NotNull Throwable ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            this.closingToken.cancel(ex);
        }

        @Nullable
        public Throwable getException() {
            return this.closingToken.getException();
        }

        public boolean isCancel() {
            return this.closingToken.isCancel() || HttpOlapServer.Companion.getCurrent().isClosing();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void execute(@NotNull JobExecutionContext context) throws JobExecutionException {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                void this_$iv;
                OlapContext.Companion companion = OlapContext.Companion;
                Object[] objectArray = new Object[]{new ITempFolder(){

                    @NotNull
                    public File getTempFolder() {
                        return Paths.INSTANCE.toFile(HttpOlapServer.Companion.getCurrent().getTempFolderPath());
                    }
                }, this};
                List contexts$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$withContext = false;
                try {
                    Object object;
                    for (Object context$iv : contexts$iv) {
                        this_$iv.push(context$iv);
                    }
                    boolean bl = false;
                    OlapServer currentServer = HttpOlapServer.Companion.getCurrent().getOlapServer();
                    String type = context.getMergedJobDataMap().getString("type");
                    Intrinsics.checkNotNull((Object)type);
                    CrontabJobType crontabJobType = CrontabJobType.valueOf(type);
                    switch (WhenMappings.$EnumSwitchMapping$0[crontabJobType.ordinal()]) {
                        case 1: 
                        case 2: {
                            currentServer.cleanRecoveryTmpFiles();
                            currentServer.checkExecuteByFreeSpace();
                            BackupType backupType = BackupType.valueOf((String)crontabJobType.name());
                            object = new BackgroundOlapBackupCommandExecutor(HttpOlapServer.Companion.getCurrent(), backupType).execute();
                            break;
                        }
                        case 3: {
                            new BackupFlow(currentServer, HttpOlapServer.Companion.getCurrent().getConfigItems(), HttpOlapServer.Companion.getCurrent().getTempFolderPath()).run();
                            object = Unit.INSTANCE;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("unsupported operation type: " + (Object)((Object)crontabJobType));
                        }
                    }
                    Object object2 = object;
                }
                finally {
                    for (int i$iv = contexts$iv.size() - 1; -1 < i$iv; --i$iv) {
                        this_$iv.pop(contexts$iv.get(i$iv));
                    }
                }
            }
            catch (Throwable t) {
                throw new JobExecutionException(t);
            }
        }

        public void cancel() {
            ICancellable.DefaultImpls.cancel((ICancellable)this);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CrontabJobType.values().length];
                try {
                    nArray[CrontabJobType.Total.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CrontabJobType.Increment.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CrontabJobType.AutoBackup.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackupType.values().length];
            try {
                nArray[BackupType.Total.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

