/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.schedule;

import java.io.Closeable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002Jh\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u001128\b\u0002\u0010\u0013\u001a2\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\b\u0012\u00060\rj\u0002`\u000e\u0018\u00010\u0014j\u0018\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\b\u0012\u00060\rj\u0002`\u000e\u0018\u0001`\u0015J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\"\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0014j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019`\u0015J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018J\u0012\u0010\u001d\u001a\u00020\u000b2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000eR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkd/bos/olap/schedule/CrontabJobManager;", "Ljava/io/Closeable;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "scheduler", "Lorg/quartz/Scheduler;", "addJob", "", "cron", "", "Lkd/bos/olapServer2/common/string;", "jobName", "jobClass", "Ljava/lang/Class;", "Lorg/quartz/Job;", "params", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "close", "getAllJobs", "Lorg/quartz/TriggerKey;", "Lorg/quartz/impl/JobDetailImpl;", "getTrigger", "Lorg/quartz/Trigger;", "triggerKey", "removeJob", "Companion", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nCrontabJobManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrontabJobManager.kt\nkd/bos/olap/schedule/CrontabJobManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n215#2,2:99\n1855#3,2:101\n*S KotlinDebug\n*F\n+ 1 CrontabJobManager.kt\nkd/bos/olap/schedule/CrontabJobManager\n*L\n50#1:99,2\n74#1:101,2\n*E\n"})
public final class CrontabJobManager
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private static final String JOB_GROUP_NAME = "CRONTAB_JOB_GROUP";
    @NotNull
    private static final String TRIGGER_GROUP_NAME = "CRONTAB_TRIGGER_GROUP";
    @NotNull
    private static final SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public CrontabJobManager() {
        Scheduler scheduler = new StdSchedulerFactory().getScheduler();
        Intrinsics.checkNotNullExpressionValue((Object)scheduler, (String)"getScheduler(...)");
        this.scheduler = scheduler;
        if (!this.scheduler.isStarted() && !this.scheduler.isShutdown()) {
            this.scheduler.start();
        }
    }

    public final Logger getLogger() {
        return this.logger;
    }

    public final synchronized void addJob(@NotNull String cron, @NotNull String jobName, @NotNull Class<? extends Job> jobClass, @Nullable HashMap<String, String> params) {
        Intrinsics.checkNotNullParameter((Object)cron, (String)"cron");
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        Intrinsics.checkNotNullParameter(jobClass, (String)"jobClass");
        JobBuilder jobBuilder = JobBuilder.newJob(jobClass).withIdentity(jobName, JOB_GROUP_NAME);
        HashMap<String, String> hashMap = params;
        if (hashMap != null) {
            Map $this$forEach$iv = hashMap;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                jobBuilder.usingJobData(key, value);
            }
        }
        JobDetail jobDetail = jobBuilder.build();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName + "_trigger", TRIGGER_GROUP_NAME).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron).withMisfireHandlingInstructionDoNothing()).build();
        Intrinsics.checkNotNull((Object)trigger, (String)"null cannot be cast to non-null type org.quartz.impl.triggers.CronTriggerImpl");
        ((CronTriggerImpl)trigger).setMisfireInstruction(2);
        this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
    }

    public static /* synthetic */ void addJob$default(CrontabJobManager crontabJobManager, String string, String string2, Class clazz, HashMap hashMap, int n, Object object) {
        if ((n & 8) != 0) {
            hashMap = null;
        }
        crontabJobManager.addJob(string, string2, clazz, hashMap);
    }

    public final synchronized void removeJob(@NotNull String jobName) {
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        TriggerKey triggerKey = TriggerKey.triggerKey((String)(jobName + "_trigger"), (String)TRIGGER_GROUP_NAME);
        this.scheduler.pauseTrigger(triggerKey);
        this.scheduler.unscheduleJob(triggerKey);
        this.scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)JOB_GROUP_NAME));
    }

    @NotNull
    public final synchronized HashMap<TriggerKey, JobDetailImpl> getAllJobs() {
        HashMap<TriggerKey, JobDetailImpl> map = new HashMap<TriggerKey, JobDetailImpl>();
        Set triggerSets = this.scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)TRIGGER_GROUP_NAME));
        Intrinsics.checkNotNull((Object)triggerSets);
        Iterable $this$forEach$iv = triggerSets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TriggerKey trigger = (TriggerKey)element$iv;
            boolean bl = false;
            Trigger trigger2 = this.scheduler.getTrigger(trigger);
            Intrinsics.checkNotNull((Object)trigger2, (String)"null cannot be cast to non-null type org.quartz.CronTrigger");
            CronTrigger cronTrigger = (CronTrigger)trigger2;
            JobKey jobKey = cronTrigger.getJobKey();
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            Intrinsics.checkNotNull((Object)jobDetail, (String)"null cannot be cast to non-null type org.quartz.impl.JobDetailImpl");
            JobDetailImpl jobDetail2 = (JobDetailImpl)jobDetail;
            Map map2 = map;
            Intrinsics.checkNotNull((Object)trigger);
            map2.put(trigger, jobDetail2);
        }
        return map;
    }

    @NotNull
    public final Trigger getTrigger(@NotNull TriggerKey triggerKey) {
        Intrinsics.checkNotNullParameter((Object)triggerKey, (String)"triggerKey");
        Trigger trigger = this.scheduler.getTrigger(triggerKey);
        Intrinsics.checkNotNullExpressionValue((Object)trigger, (String)"getTrigger(...)");
        return trigger;
    }

    @Override
    public void close() {
        try {
            if (this.scheduler.isStarted() || !this.scheduler.isShutdown()) {
                this.scheduler.shutdown(true);
            }
        }
        catch (SchedulerException e) {
            this.logger.error(e.getMessage(), (Object)e.getStackTrace());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lkd/bos/olap/schedule/CrontabJobManager$Companion;", "", "()V", "JOB_GROUP_NAME", "", "TRIGGER_GROUP_NAME", "dataFormat", "Ljava/text/SimpleDateFormat;", "getDataFormat", "()Ljava/text/SimpleDateFormat;", "bos-olap-webserver"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleDateFormat getDataFormat() {
            return dataFormat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

