/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.schedule;

import java.io.File;
import java.util.Map;
import kd.bos.olap.common.WebOlapConfigItemCollection;
import kd.bos.olap.server.OlapPaths;
import kd.bos.olap.tools.XmlTool;
import kd.bos.olapServer2.common.EventArgs;
import kd.bos.olapServer2.common.OlapConfigItem;
import kd.bos.olapServer2.common.Paths;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePlugin;
import kd.bos.olapServer2.storages.plugins.OlapWorkspacePluginContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkd/bos/olap/schedule/RefreshContextPlugin;", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePlugin;", "context", "Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;", "webOlapConfigItems", "Lkd/bos/olap/common/WebOlapConfigItemCollection;", "(Lkd/bos/olapServer2/storages/plugins/OlapWorkspacePluginContext;Lkd/bos/olap/common/WebOlapConfigItemCollection;)V", "lastModified", "", "Lkd/bos/olapServer2/common/long;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "webXmlFile", "Ljava/io/File;", "refreshContext", "", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nRefreshContextPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshContextPlugin.kt\nkd/bos/olap/schedule/RefreshContextPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1855#2,2:59\n*S KotlinDebug\n*F\n+ 1 RefreshContextPlugin.kt\nkd/bos/olap/schedule/RefreshContextPlugin\n*L\n40#1:59,2\n*E\n"})
public final class RefreshContextPlugin
extends OlapWorkspacePlugin {
    @NotNull
    private final WebOlapConfigItemCollection webOlapConfigItems;
    private final Logger logger;
    @NotNull
    private final File webXmlFile;
    private long lastModified;

    public RefreshContextPlugin(@NotNull OlapWorkspacePluginContext context, @NotNull WebOlapConfigItemCollection webOlapConfigItems) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)webOlapConfigItems, (String)"webOlapConfigItems");
        super(context);
        this.webOlapConfigItems = webOlapConfigItems;
        this.logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getSimpleName());
        this.webXmlFile = Paths.INSTANCE.toFile(OlapPaths.Companion.getCurrent().getWebXml());
        this.lastModified = this.webXmlFile.lastModified();
        context.getCollecting().plusAssign((Function2)new Function2<OlapWorkspacePluginContext, EventArgs, Unit>(){

            public final void invoke(@NotNull OlapWorkspacePluginContext olapWorkspacePluginContext, @NotNull EventArgs eventArgs) {
                Intrinsics.checkNotNullParameter((Object)olapWorkspacePluginContext, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)eventArgs, (String)"<anonymous parameter 1>");
                try {
                    this.refreshContext();
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    private final void refreshContext() {
        long modifyTime = this.webXmlFile.lastModified();
        if (this.lastModified != modifyTime) {
            this.lastModified = modifyTime;
            String string = this.webXmlFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Map<String, String> hashMap = XmlTool.Companion.getConfigPairs(string);
            Iterable $this$forEach$iv = this.webOlapConfigItems.getItems().keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String keyName = (String)element$iv;
                boolean bl = false;
                String newValue = hashMap.get(keyName);
                OlapConfigItem olapConfigItem = this.webOlapConfigItems.getItems().get(keyName);
                if (olapConfigItem == null) {
                    this.logger.warn("web.xml not exist " + keyName);
                    continue;
                }
                if (!olapConfigItem.getRefreshEnabled() || Intrinsics.areEqual((Object)olapConfigItem.getLastValue(), (Object)newValue)) continue;
                String lastValue = olapConfigItem.getLastValue();
                try {
                    olapConfigItem.update(newValue);
                    this.logger.info("web.xml had been updated " + keyName + ':' + lastValue + " -> " + newValue);
                }
                catch (Throwable e) {
                    this.logger.error("web.xml update " + keyName + ':' + lastValue + " -> " + newValue + " error", e);
                }
            }
        }
    }
}

