/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.schedule;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olapServer2.common.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\t2\n\u0010\f\u001a\u00060\u0003j\u0002`\tJ\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\n\u0010\f\u001a\u00060\u0003j\u0002`\t2\n\u0010\u0012\u001a\u00060\u0003j\u0002`\tJ\u0012\u0010\u0013\u001a\u00020\u00112\n\u0010\f\u001a\u00060\u0003j\u0002`\tJ\u0006\u0010\u0014\u001a\u00020\u0011J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010\u0007\u001a.\u0012\b\u0012\u00060\u0003j\u0002`\t\u0012\b\u0012\u00060\u0003j\u0002`\t0\bj\u0016\u0012\b\u0012\u00060\u0003j\u0002`\t\u0012\b\u0012\u00060\u0003j\u0002`\t`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkd/bos/olap/schedule/VersionFileContainer;", "", "backupPath", "", "(Ljava/lang/String;)V", "versionFile", "Ljava/io/File;", "versionMap", "Ljava/util/HashMap;", "Lkd/bos/olapServer2/common/string;", "Lkotlin/collections/HashMap;", "get", "cubeName", "load", "", "Lkd/bos/olapServer2/common/bool;", "put", "", "version", "remove", "save", "toString", "bos-olap-webserver"})
public final class VersionFileContainer {
    @NotNull
    private File versionFile;
    @NotNull
    private HashMap<String, String> versionMap;

    public VersionFileContainer(@NotNull String backupPath) {
        Intrinsics.checkNotNullParameter((Object)backupPath, (String)"backupPath");
        this.versionFile = Paths.INSTANCE.toFile(backupPath + "/version.dat");
        this.versionMap = new HashMap();
    }

    public final void put(@NotNull String cubeName, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        ((Map)this.versionMap).put(cubeName, version);
    }

    @Nullable
    public final String get(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        return this.versionMap.get(cubeName);
    }

    public final void remove(@NotNull String cubeName) {
        Intrinsics.checkNotNullParameter((Object)cubeName, (String)"cubeName");
        this.versionMap.remove(cubeName);
    }

    public final boolean load() {
        if (!this.versionFile.exists()) {
            return false;
        }
        Object object = JsonHelper.INSTANCE.getMapper().readValue(this.versionFile, HashMap.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.HashMap<kotlin.String{ kd.bos.olapServer2.common.CommonTypesKt.string }, kotlin.String{ kd.bos.olapServer2.common.CommonTypesKt.string }>{ kotlin.collections.TypeAliasesKt.HashMap<kotlin.String{ kd.bos.olapServer2.common.CommonTypesKt.string }, kotlin.String{ kd.bos.olapServer2.common.CommonTypesKt.string }> }");
        this.versionMap = (HashMap)object;
        return true;
    }

    public final void save() {
        JsonHelper.INSTANCE.getMapper().writeValue(this.versionFile, this.versionMap);
    }

    @NotNull
    public String toString() {
        StringBuilder result2 = new StringBuilder("VersionFileContainer(" + this.versionFile + "):{");
        for (Map.Entry elem : ((Map)this.versionMap).entrySet()) {
            result2.append((String)elem.getKey() + '=' + (String)elem.getValue() + ',');
        }
        result2.append('}');
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

