/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.tools.OlapSecurityManager;
import kd.bos.olap.tools.Res;
import kd.bos.security.config.Ini;
import kd.bos.security.subject.ISubject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Path(value="/account")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\n\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u000b\u001a\u00060\bj\u0002`\tH\u0007JD\u0010\f\u001a\u00060\rj\u0002`\u000e2\f\b\u0001\u0010\u000f\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u0010\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u0011\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u0012\u001a\u00060\bj\u0002`\tH\u0007J\f\u0010\u0013\u001a\u00060\rj\u0002`\u000eH\u0007J\u001c\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\bj\u0002`\tH\u0002J(\u0010\u0019\u001a\u00060\rj\u0002`\u000e2\f\b\u0001\u0010\u000f\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u001a\u001a\u00060\bj\u0002`\tH\u0007J*\u0010\u001b\u001a\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\t0\u001c2\f\b\u0001\u0010\u000f\u001a\u00060\bj\u0002`\tH\u0007J6\u0010\u001d\u001a\u00060\rj\u0002`\u000e2\f\b\u0001\u0010\u000f\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u001e\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u0011\u001a\u00060\bj\u0002`\tH\u0007J6\u0010\u001f\u001a\u00060\rj\u0002`\u000e2\f\b\u0001\u0010\u000f\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u001e\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u0018\u001a\u00060\bj\u0002`\tH\u0007J6\u0010 \u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u000f\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010!\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u0011\u001a\u00060\bj\u0002`\tH\u0007J\u001c\u0010 \u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\b2\n\u0010\u000b\u001a\u00060\bj\u0002`\tH\u0002J\u001a\u0010\"\u001a\u00060\bj\u0002`\t2\f\b\u0001\u0010\u000b\u001a\u00060\bj\u0002`\tH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkd/bos/olap/server/AccountService;", "", "olapServer", "Lkd/bos/olap/server/HttpOlapServer;", "(Lkd/bos/olap/server/HttpOlapServer;)V", "securityManager", "Lkd/bos/olap/tools/OlapSecurityManager;", "accountLogin", "", "Lkd/bos/olapServer2/common/string;", "userName", "password", "addNormalAccount", "", "Lkd/bos/olapServer2/common/bool;", "authorization", "newUserName", "newPassword", "roles", "adminHasSetPassword", "checkRoles", "", "ini", "Lkd/bos/security/config/Ini;", "newRoles", "deleteNormalAccount", "deleteUserName", "getNormalAccount", "", "modifyNormalAccountPassword", "normalUserName", "modifyNormalAccountRoles", "modifyPassword", "oldPassword", "setAdminPassword", "bos-olap-webserver"})
public final class AccountService {
    @NotNull
    private final OlapSecurityManager securityManager;

    public AccountService(@NotNull HttpOlapServer olapServer) {
        Intrinsics.checkNotNullParameter((Object)olapServer, (String)"olapServer");
        this.securityManager = olapServer.getSecurityManager();
    }

    @POST
    @Path(value="/adminHasSetPassword")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public final boolean adminHasSetPassword() {
        return this.securityManager.getAdminHasSetPassword();
    }

    @POST
    @Path(value="/setAdminPassword")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String setAdminPassword(@HeaderParam(value="password") @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        if (((CharSequence)password).length() == 0) {
            String string = Res.INSTANCE.getAccountServiceException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        if (this.securityManager.getAdminHasSetPassword()) {
            String string = Res.INSTANCE.getAccountServiceException_1();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_1>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        this.modifyPassword("admin", password);
        this.securityManager.setAdminHasSetPassword(true);
        return OlapSecurityManager.Companion.getBasicAuthorizationHeaderValue("admin", password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/login")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String accountLogin(@HeaderParam(value="userName") @NotNull String userName, @HeaderParam(value="password") @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        if (((CharSequence)userName).length() == 0 || ((CharSequence)password).length() == 0) {
            String string = Res.INSTANCE.getAccountServiceException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        Pair<ISubject, String> pair = this.securityManager.login(userName, password);
        ISubject currentUser = (ISubject)pair.component1();
        String encryptedPassword = (String)pair.component2();
        try {
            String string = OlapSecurityManager.Companion.getBasicAuthorizationHeaderValue(userName, encryptedPassword);
            return string;
        }
        finally {
            currentUser.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/modifyPassword")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String modifyPassword(@HeaderParam(value="Authorization") @NotNull String authorization, @HeaderParam(value="oldPassword") @NotNull String oldPassword, @HeaderParam(value="newPassword") @NotNull String newPassword) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)oldPassword, (String)"oldPassword");
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        Pair<String, String> pair = OlapSecurityManager.Companion.getUserNameAndPassWord(authorization);
        String userName = (String)pair.component1();
        String password = (String)pair.component2();
        if (!Intrinsics.areEqual((Object)password, (Object)oldPassword)) {
            String string = Res.INSTANCE.getAccountServiceException_3();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_3>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        if (((CharSequence)newPassword).length() == 0) {
            String string = Res.INSTANCE.getAccountServiceException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        ISubject currentUser = (ISubject)this.securityManager.login(userName, password).getFirst();
        try {
            this.modifyPassword(userName, newPassword);
            String string = OlapSecurityManager.Companion.getBasicAuthorizationHeaderValue(userName, newPassword);
            return string;
        }
        finally {
            currentUser.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/addNormalAccount")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public final boolean addNormalAccount(@HeaderParam(value="Authorization") @NotNull String authorization, @HeaderParam(value="newUserName") @NotNull String newUserName, @HeaderParam(value="newPassword") @NotNull String newPassword, @HeaderParam(value="roles") @NotNull String roles) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)newUserName, (String)"newUserName");
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        if (((CharSequence)newUserName).length() == 0 || ((CharSequence)newPassword).length() == 0) {
            String string = Res.INSTANCE.getAccountServiceException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        OlapSecurityManager.Companion.checkAccount(newUserName);
        ISubject currentUser = this.securityManager.loginByAuthorization(authorization, true);
        try {
            OlapSecurityManager olapSecurityManager = this.securityManager;
            synchronized (olapSecurityManager) {
                boolean bl = false;
                Ini ini = this.securityManager.buildIni();
                Ini.Section userSession = ini.getSection("users");
                String valueStr = (String)userSession.get((Object)newUserName);
                if (valueStr != null) {
                    String string = Res.INSTANCE.getAccountServiceException_4();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_4>(...)");
                    Object[] objectArray = new Object[]{newUserName};
                    throw Res.INSTANCE.getRuntimeException(string, objectArray);
                }
                if (((CharSequence)roles).length() == 0) {
                    ((Map)userSession).put(newUserName, newPassword);
                } else {
                    this.checkRoles(ini, roles);
                    ((Map)userSession).put(newUserName, newPassword + ',' + roles);
                }
                this.securityManager.updateAndSaveIni(ini);
                Unit unit = Unit.INSTANCE;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            currentUser.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/getNormalAccount")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @NotNull
    public final Map<String, String> getNormalAccount(@HeaderParam(value="Authorization") @NotNull String authorization) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        ISubject currentUser = this.securityManager.loginByAuthorization(authorization, true);
        try {
            Ini ini = this.securityManager.getIni();
            Ini.Section userSession = ini.getSection("users");
            HashMap map = new HashMap();
            for (Map.Entry user : ((Map)userSession).entrySet()) {
                if (OlapSecurityManager.Companion.getSpecialUsers().contains(user.getKey())) continue;
                String[] stringArray = new String[]{","};
                List values = StringsKt.split$default((CharSequence)((CharSequence)user.getValue()), (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                if (values.size() >= 2) {
                    ((Map)map).put(user.getKey(), values.get(1));
                    continue;
                }
                ((Map)map).put(user.getKey(), "");
            }
            Map map2 = map;
            return map2;
        }
        finally {
            currentUser.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/deleteNormalAccount")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public final boolean deleteNormalAccount(@HeaderParam(value="Authorization") @NotNull String authorization, @HeaderParam(value="deleteUserName") @NotNull String deleteUserName) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)deleteUserName, (String)"deleteUserName");
        if (((CharSequence)deleteUserName).length() == 0) {
            String string = Res.INSTANCE.getAccountServiceException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        if (OlapSecurityManager.Companion.getSpecialUsers().contains(deleteUserName)) {
            String string = Res.INSTANCE.getAccountServiceException_5();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_5>(...)");
            Object[] objectArray = new Object[]{deleteUserName};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
        ISubject currentUser = this.securityManager.loginByAuthorization(authorization, true);
        try {
            OlapSecurityManager olapSecurityManager = this.securityManager;
            synchronized (olapSecurityManager) {
                boolean bl = false;
                Ini ini = this.securityManager.buildIni();
                Ini.Section userSession = ini.getSection("users");
                String valueStr = (String)userSession.get((Object)deleteUserName);
                if (valueStr == null) {
                    String string = Res.INSTANCE.getAccountServiceException_6();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_6>(...)");
                    Object[] objectArray = new Object[]{deleteUserName};
                    throw Res.INSTANCE.getRuntimeException(string, objectArray);
                }
                userSession.remove((Object)deleteUserName);
                this.securityManager.updateAndSaveIni(ini);
                Unit unit = Unit.INSTANCE;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            currentUser.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/modifyNormalAccountPassword")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public final boolean modifyNormalAccountPassword(@HeaderParam(value="Authorization") @NotNull String authorization, @HeaderParam(value="normalUserName") @NotNull String normalUserName, @HeaderParam(value="newPassword") @NotNull String newPassword) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)normalUserName, (String)"normalUserName");
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        if (((CharSequence)normalUserName).length() == 0 || ((CharSequence)newPassword).length() == 0) {
            String string = Res.INSTANCE.getAccountServiceException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        if (OlapSecurityManager.Companion.getSpecialUsers().contains(normalUserName)) {
            String string = Res.INSTANCE.getAccountServiceException_5();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_5>(...)");
            Object[] objectArray = new Object[]{normalUserName};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
        ISubject currentUser = this.securityManager.loginByAuthorization(authorization, true);
        try {
            this.modifyPassword(normalUserName, newPassword);
            boolean bl = true;
            return bl;
        }
        finally {
            currentUser.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/modifyNormalAccountRoles")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public final boolean modifyNormalAccountRoles(@HeaderParam(value="Authorization") @NotNull String authorization, @HeaderParam(value="normalUserName") @NotNull String normalUserName, @HeaderParam(value="newRoles") @NotNull String newRoles) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)normalUserName, (String)"normalUserName");
        Intrinsics.checkNotNullParameter((Object)newRoles, (String)"newRoles");
        if (((CharSequence)normalUserName).length() == 0) {
            String string = Res.INSTANCE.getAccountServiceException_2();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_2>(...)");
            throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
        }
        if (OlapSecurityManager.Companion.getSpecialUsers().contains(normalUserName)) {
            String string = Res.INSTANCE.getAccountServiceException_5();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_5>(...)");
            Object[] objectArray = new Object[]{normalUserName};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
        ISubject currentUser = this.securityManager.loginByAuthorization(authorization, true);
        try {
            OlapSecurityManager olapSecurityManager = this.securityManager;
            synchronized (olapSecurityManager) {
                boolean bl = false;
                Ini ini = this.securityManager.buildIni();
                Ini.Section userSession = ini.getSection("users");
                String string = (String)userSession.get((Object)normalUserName);
                if (string == null) {
                    String string2 = Res.INSTANCE.getAccountServiceException_6();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-AccountServiceException_6>(...)");
                    Object[] objectArray = new Object[]{normalUserName};
                    throw Res.INSTANCE.getRuntimeException(string2, objectArray);
                }
                String valueStr = string;
                this.checkRoles(ini, newRoles);
                String[] stringArray = new String[]{","};
                List values = StringsKt.split$default((CharSequence)valueStr, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                ((Map)userSession).put(normalUserName, (String)values.get(0) + ',' + newRoles);
                this.securityManager.updateAndSaveIni(ini);
                Unit unit = Unit.INSTANCE;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            currentUser.logout();
        }
    }

    private final void checkRoles(Ini ini, String newRoles) {
        Set realRoles = ini.getSection("roles").keySet();
        String[] stringArray = new String[]{","};
        List roles = StringsKt.split$default((CharSequence)newRoles, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (String role : roles) {
            if (Intrinsics.areEqual((Object)role, (Object)"admin")) {
                String string = Res.INSTANCE.getAccountServiceException_8();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_8>(...)");
                throw Res.INSTANCE.getRuntimeException(string, new Object[0]);
            }
            if (realRoles.contains(role)) continue;
            String string = Res.INSTANCE.getAccountServiceException_7();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-AccountServiceException_7>(...)");
            Object[] objectArray = new Object[]{role};
            throw Res.INSTANCE.getRuntimeException(string, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void modifyPassword(String userName, String password) {
        OlapSecurityManager olapSecurityManager = this.securityManager;
        synchronized (olapSecurityManager) {
            boolean bl = false;
            Ini ini = this.securityManager.buildIni();
            Ini.Section userSession = ini.getSection("users");
            String string = (String)userSession.get((Object)userName);
            if (string == null) {
                String string2 = Res.INSTANCE.getAccountServiceException_6();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-AccountServiceException_6>(...)");
                throw Res.INSTANCE.getRuntimeException(string2, new Object[0]);
            }
            String valueStr = string;
            String[] stringArray = new String[]{","};
            List values = StringsKt.split$default((CharSequence)valueStr, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            if (values.size() >= 2) {
                ((Map)userSession).put(userName, password + ',' + (String)values.get(1));
            } else {
                ((Map)userSession).put(userName, password);
            }
            this.securityManager.updateAndSaveIni(ini);
            Unit unit = Unit.INSTANCE;
        }
    }
}

