/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.olap.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import kd.bos.olap.schedule.CrontabJobRule;
import kd.bos.olap.server.CoreService;
import kd.bos.olap.server.HttpOlapServer;
import kd.bos.olap.server.executor.IOlapExecutor;
import kd.bos.olap.server.http.HttpExecuteKt;
import kd.bos.olap.server.http.HttpOlapRequest;
import kd.bos.olap.server.http.HttpOlapResponse;
import kd.bos.olap.server.session.OlapAgency;
import kd.bos.olap.tools.JsonHelper;
import kd.bos.olap.tools.Res;
import kd.bos.olapServer2.backup.BackupFile;
import kd.bos.olapServer2.backup.DirectFile;
import kd.bos.olapServer2.dataSources.BackupCommandInfo;
import kd.bos.olapServer2.dataSources.BatchCommandInfo;
import kd.bos.olapServer2.dataSources.CommandInfo;
import kd.bos.olapServer2.dataSources.ComputingCommandInfo;
import kd.bos.olapServer2.dataSources.FunctionCommandInfo;
import kd.bos.olapServer2.dataSources.Level;
import kd.bos.olapServer2.dataSources.MetadataCommandInfo;
import kd.bos.olapServer2.dataSources.RecoveryCommandInfo;
import kd.bos.olapServer2.dataSources.SelectCommandInfo;
import kd.bos.olapServer2.dataSources.TimeBackupCommandInfo;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.jetbrains.annotations.NotNull;

@Path(value="/httpolap")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\f\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\r\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J$\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J$\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00122\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J$\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00142\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u0015\u001a\u00060\u0006j\u0002`\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J$\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J'\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u001bJ'\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001a2\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u001eJ$\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\"\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010#\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010$\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J \u0010%\u001a\u00060\u0006j\u0002`\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J$\u0010&\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020'2\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J$\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*2\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010+\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lkd/bos/olap/server/CoreService;", "", "currentServer", "Lkd/bos/olap/server/HttpOlapServer;", "(Lkd/bos/olap/server/HttpOlapServer;)V", "addCrontabJobRule", "", "Lkd/bos/olapServer2/common/string;", "req", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "backup", "backupOlap", "backupV2", "commandInfo", "Lkd/bos/olapServer2/dataSources/BackupCommandInfo;", "batch", "Lkd/bos/olapServer2/dataSources/BatchCommandInfo;", "computing", "Lkd/bos/olapServer2/dataSources/ComputingCommandInfo;", "deleteCrontabJobRule", "function", "functionCommandInfo", "Lkd/bos/olapServer2/dataSources/FunctionCommandInfo;", "getBackupHistory", "", "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)[Ljava/lang/String;", "getCrontabJobRuleList", "Lkd/bos/olap/schedule/CrontabJobRule;", "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)[Lkd/bos/olap/schedule/CrontabJobRule;", "query", "selectCommandInfo", "Lkd/bos/olapServer2/dataSources/SelectCommandInfo;", "recovery", "recoveryOlap", "recoveryV2", "saveConcatMe", "timeBackup", "Lkd/bos/olapServer2/dataSources/TimeBackupCommandInfo;", "updateMetadata", "metadataCommand", "Lkd/bos/olapServer2/dataSources/MetadataCommandInfo;", "write", "UploadFileRequest", "bos-olap-webserver"})
@SourceDebugExtension(value={"SMAP\nCoreService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreService.kt\nkd/bos/olap/server/CoreService\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,318:1\n37#2,2:319\n37#2,2:321\n*S KotlinDebug\n*F\n+ 1 CoreService.kt\nkd/bos/olap/server/CoreService\n*L\n271#1:319,2\n295#1:321,2\n*E\n"})
public final class CoreService {
    @NotNull
    private final HttpOlapServer currentServer;

    public CoreService(@NotNull HttpOlapServer currentServer) {
        Intrinsics.checkNotNullParameter((Object)currentServer, (String)"currentServer");
        this.currentServer = currentServer;
    }

    @POST
    @Path(value="/query")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String query(@NotNull SelectCommandInfo selectCommandInfo, @Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)selectCommandInfo, (String)"selectCommandInfo");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute((CommandInfo)selectCommandInfo, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)query.1.INSTANCE));
    }

    @POST
    @Path(value="/function")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String function(@NotNull FunctionCommandInfo functionCommandInfo, @Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)functionCommandInfo, (String)"functionCommandInfo");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute((CommandInfo)functionCommandInfo, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)function.1.INSTANCE));
    }

    @POST
    @Path(value="/computing")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String computing(@NotNull ComputingCommandInfo commandInfo, @Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)commandInfo, (String)"commandInfo");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute((CommandInfo)commandInfo, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)computing.1.INSTANCE));
    }

    @POST
    @Path(value="/batch")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String batch(@NotNull BatchCommandInfo commandInfo, @Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)commandInfo, (String)"commandInfo");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        for (Level level : commandInfo.getLevels()) {
            for (CommandInfo cmd : level.getCommands()) {
                CommandInfo commandInfo2 = cmd;
                if (commandInfo2 instanceof ComputingCommandInfo) {
                    this.computing((ComputingCommandInfo)cmd, req, response);
                    continue;
                }
                if (commandInfo2 instanceof MetadataCommandInfo) {
                    this.updateMetadata((MetadataCommandInfo)cmd, req, response);
                    continue;
                }
                throw Res.INSTANCE.getRuntimeException("Unsupported commandInfo : " + cmd, new Object[0]);
            }
        }
        return "true";
    }

    @POST
    @Path(value="/write")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String write(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)write.1.INSTANCE));
    }

    @POST
    @Path(value="/updateMetadata")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @NotNull
    public final String updateMetadata(@NotNull MetadataCommandInfo metadataCommand, @Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)metadataCommand, (String)"metadataCommand");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (Intrinsics.areEqual((Object)"olapTestCube", (Object)metadataCommand.getName())) {
            return HttpExecuteKt.httpExecute((CommandInfo)metadataCommand, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)updateMetadata.1.INSTANCE));
        }
        return HttpExecuteKt.httpExecute((CommandInfo)metadataCommand, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)updateMetadata.2.INSTANCE));
    }

    @POST
    @Path(value="/backup")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @NotNull
    public final String backup(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        BackupCommandInfo command = new BackupCommandInfo((BackupFile)new DirectFile());
        return HttpExecuteKt.httpExecute((CommandInfo)command, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)backup.1.INSTANCE));
    }

    @POST
    @Path(value="/backup.v2")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @NotNull
    public final String backupV2(@NotNull BackupCommandInfo commandInfo, @Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        String string;
        Intrinsics.checkNotNullParameter((Object)commandInfo, (String)"commandInfo");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (commandInfo.getTime() != -1L || ((CharSequence)commandInfo.getIgnoreIds()).length() > 0) {
            TimeBackupCommandInfo timeBackupCommandInfo = new TimeBackupCommandInfo(commandInfo.getTime(), commandInfo.getIgnoreIds());
            string = HttpExecuteKt.httpExecute((CommandInfo)timeBackupCommandInfo, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)backupV2.1.INSTANCE));
        } else {
            string = HttpExecuteKt.httpExecute((CommandInfo)commandInfo, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)backupV2.2.INSTANCE));
        }
        return string;
    }

    @POST
    @Path(value="/timeBackup")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @NotNull
    public final String timeBackup(@NotNull TimeBackupCommandInfo commandInfo, @Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)commandInfo, (String)"commandInfo");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute((CommandInfo)commandInfo, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)timeBackup.1.INSTANCE));
    }

    @POST
    @Path(value="/backupOlap")
    @Produces(value={"text/plain"})
    @NotNull
    public final String backupOlap(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)backupOlap.1.INSTANCE));
    }

    @POST
    @Path(value="/recovery")
    @Produces(value={"application/octet-stream"})
    @NotNull
    public final String recovery(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List items = upload.parseRequest(req);
        ArrayList<FileItem> param = new ArrayList<FileItem>();
        for (Object item : items) {
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type org.apache.commons.fileupload.FileItem");
            FileItem fileItem = item;
            param.add(fileItem);
        }
        if (!(param.size() > 1)) {
            Object item;
            item = "Failed requirement.";
            throw new IllegalArgumentException(item.toString());
        }
        InputStream inputStream = ((FileItem)param.get(1)).getInputStream();
        String string = req.getHeader("cubeName");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHeader(...)");
        RecoveryCommandInfo command = new RecoveryCommandInfo(string, (BackupFile)new DirectFile());
        Intrinsics.checkNotNull((Object)inputStream);
        UploadFileRequest olapRequest = new UploadFileRequest(inputStream, req);
        HttpOlapResponse olapResponse = new HttpOlapResponse(response);
        return HttpExecuteKt.httpExecute((CommandInfo)command, olapRequest, olapResponse, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)recovery.1.INSTANCE));
    }

    @POST
    @Path(value="/recovery.v2")
    @NotNull
    public final String recoveryV2(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String json = req.getHeader("command");
        ObjectMapper mapper = JsonHelper.INSTANCE.getMapper();
        RecoveryCommandInfo command = (RecoveryCommandInfo)mapper.readValue(json, RecoveryCommandInfo.class);
        return HttpExecuteKt.httpExecute((CommandInfo)command, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)recoveryV2.1.INSTANCE));
    }

    @POST
    @Path(value="/recoveryOlap")
    @Produces(value={"text/plain"})
    @NotNull
    public final String recoveryOlap(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)recoveryOlap.1.INSTANCE));
    }

    @POST
    @Path(value="/getBackupHistory")
    @Produces(value={"application/json"})
    @NotNull
    public final String[] getBackupHistory(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Collection $this$toTypedArray$iv = this.currentServer.getOlapServer().getBackupRecords();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @POST
    @Path(value="/addCrontabJobRule")
    @Produces(value={"text/plain"})
    @NotNull
    public final String addCrontabJobRule(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)addCrontabJobRule.1.INSTANCE));
    }

    @POST
    @Path(value="/getCrontabJobRuleList")
    @Produces(value={"application/json"})
    @NotNull
    public final CrontabJobRule[] getCrontabJobRuleList(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Collection $this$toTypedArray$iv = this.currentServer.getCrontabJob().getCrontabJobRuleList();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new CrontabJobRule[0]);
    }

    @POST
    @Path(value="/deleteCrontabJobRule")
    @Produces(value={"text/plain"})
    @NotNull
    public final String deleteCrontabJobRule(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)deleteCrontabJobRule.1.INSTANCE));
    }

    @POST
    @Path(value="/saveConcatMe")
    @Produces(value={"text/plain"})
    @NotNull
    public final String saveConcatMe(@Context @NotNull HttpServletRequest req, @Context @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return HttpExecuteKt.httpExecute(null, req, response, this.currentServer, (Function2<? super HttpOlapServer, ? super OlapAgency, ? extends IOlapExecutor<String>>)((Function2)saveConcatMe.1.INSTANCE));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lkd/bos/olap/server/CoreService$UploadFileRequest;", "Lkd/bos/olap/server/http/HttpOlapRequest;", "inputStream", "Ljava/io/InputStream;", "req", "Ljavax/servlet/http/HttpServletRequest;", "(Ljava/io/InputStream;Ljavax/servlet/http/HttpServletRequest;)V", "getInputStream", "()Ljava/io/InputStream;", "bos-olap-webserver"})
    private static final class UploadFileRequest
    extends HttpOlapRequest {
        @NotNull
        private final InputStream inputStream;

        public UploadFileRequest(@NotNull InputStream inputStream, @NotNull HttpServletRequest req) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)req, (String)"req");
            super(req);
            this.inputStream = inputStream;
        }

        @Override
        @NotNull
        public InputStream getInputStream() {
            return this.inputStream;
        }
    }
}

